<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	private $_id;
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate()
	{
		$user = User::model()->findByAttributes(array('email'=>$this->username));
		if(strpos($this->username, '@') !== false){
			$user = User::model()->findByAttributes(array('email'=>$this->username));
		}else{
			//Otherwise we search using the username
			$user = User::model()->findByAttributes(array('username'=>$this->username));
		}
		if( !isset($this->username) || null === $user )
		{
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		}
		elseif( !isset($this->password) || null === $user )
		{
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		}
		elseif( $user->password === md5($this->password) )
		{
			$this->username = $user->username;
			$this->_id = $user->id;

			$this->errorCode=self::ERROR_NONE;
		}

		return !$this->errorCode;
	}

	public function getId()
	{
		return $this->_id;
	}
}