<?php
$this->pageTitle= '用户面板 - ' . Yii::app()->name;
?>
<div class="container">
    <div class="row">
        <ul class="nav nav-tabs">
            <li class="active"><a href="#profilePanel" data-toggle="tab">个人信息</a></li>
            <li><a href="#pwdPanel" data-toggle="tab">修改密码</a></li>
        </ul>
        <div class="tab-content m-t-20">
            <div class="tab-pane active" id="profilePanel">
                <?php $form=$this->beginWidget('CActiveForm', array(
                    'id' => 'profile-form',
                    'enableClientValidation'=>true,
                    'clientOptions'=>array(
                        'validateOnSubmit'=>true,
                    ),
                    'action' => $this->createUrl('/account/updateProfile'),
                    'htmlOptions'=>array(
                        'class'=>'form-horizontal',
                        'method' => 'post'
                    ),
                )); ?>
                <div class="form-group">
                    <label class="col-lg-4 control-label">电子邮箱</label>
                    <div class="col-lg-6">
                        <p class="form-control-static"><?php echo $user->email; ?></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label">注册时间</label>
                    <div class="col-lg-6">
                        <p class="form-control-static"><?php echo $user->created; ?></p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label">用户名</label>
                    <div class="col-lg-3">
                        <?php echo $form->textField($profile,'username', array('class'=>'form-control', 'placeholder'=>$user->username, 'required'=>'required')); ?>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label"></label>
                    <div class="col-lg-3">
                        <?php echo CHtml::submitButton('修改',array('class'=>'btn btn-primary')); ?>
                    </div>
                </div>
                <?php $this->endWidget(); ?>
            </div>
            <div class="tab-pane" id="pwdPanel">
                <?php $form=$this->beginWidget('CActiveForm', array(
                    'id'=> 'passwordForm',
                    'enableClientValidation'=>true,
                    'clientOptions'=>array(
                        'validateOnSubmit'=>true,
                    ),
                    'action'=>$this->createUrl('/account/updatePassword'),
                    'htmlOptions'=>array(
                        'class'=>'form-horizontal',
                        'method'=>'post'
                    )
                )) ; ?>
                <div class="form-group">
                    <label class="col-lg-4 control-label" for="old_pwd">旧密码</label>
                    <div class="col-lg-6">
                        <?php echo $form->passwordField($password, 'old_password', array('class'=>'form-control','placeholder'=>'旧密码','required'=>'required')); ?>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label" for="new_pwd">新密码</label>
                    <div class="col-lg-6">
                        <?php echo $form->passwordField($password, 'new_password', array('class'=>'form-control','placeholder'=>'新密码','required'=>'required')); ?>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label" for="repeat_pwd">确认密码</label>
                    <div class="col-lg-6">
                        <?php echo $form->passwordField($password, 'repeat_password', array('class'=>'form-control','placeholder'=>'确认密码','required'=>'required')); ?>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-lg-4 control-label"></label>
                    <div class="col-lg-6">
                        <?php echo CHtml::submitButton('修改',array('class'=>'btn btn-primary')); ?>
                    </div>
                </div>
                <?php $this->endWidget(); ?>
            </div>
        </div>
    </div>
</div>