<?php
$this->pageTitle = '登录 - ' . Yii::app()->name;
?>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="language" content="en">
    <title><?php echo CHtml::encode($this->pageTitle); ?></title>
    <meta name="viewport" content="initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <!-- build:css(.) /public/default/css/login.min.css -->
    <link rel="stylesheet" href="/public/default/vendor/bootstrap/css/bootstrap.css"/>
    <link rel="stylesheet" href="/public/default/css/style.css"/>
    <link rel="stylesheet" href="/public/default/css/account.css"/>
    <!-- endbuild -->
</head>

<body>
<div class="panel panel-primary login-panel">
    <div class="panel-heading">
        <h3 class="panel-title">用户登录</h3>
    </div>
    <div class="panel-body">
        <?php if(Yii::app()->user->hasFlash('register_success')) : ?>
            <div class="alert alert-success" role="alert"><?php echo Yii::app()->user->getFlash('register_success'); ?></div>
        <?php endif; ?>
        <?php $form=$this->beginWidget('CActiveForm', array(
            'id'=>'login-form',
            'enableClientValidation'=>false,
            'errorMessageCssClass'=>'alert alert-warning',
            'clientOptions'=>array(
                'validateOnSubmit'=>true,
            ),
        )); ?>
        <div class="form-group">
            <?php echo $form->labelEx($model,'电子邮箱'); ?>
            <?php echo $form->emailField($model,'email',array('class'=>'form-control','required'=>'required','value'=>'demo@focalhot.com')); ?>
            <?php echo $form->error($model,'email'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($model,'密码'); ?>
            <?php echo $form->passwordField($model,'password',array('class'=>'form-control', 'required'=>'required','value'=>'focalhot')); ?>
            <?php echo $form->error($model,'password'); ?>
        </div>
        <div class="checkbox">
            <label>
                <input type="checkbox"> 记住密码
            </label>
        </div>
        <button type="submit" class="btn btn-primary">登录</button>
        <!--<a onclick="alert('注册功能已关闭，请联系管理员直接添加账号！');" href="javascript:;" class="btn btn-default">注册</a>-->
        <?php $this->endWidget(); ?>
    </div>
</div>
<!-- build:js(.) /public/default/js/login.min.js -->
<script src="/public/default/vendor/jquery/jquery.js"></script>
<script src="/public/default/vendor/bootstrap/js/bootstrap.js"></script>
<script src="/public/default/vendor/jquery-html5Validate.js"></script>
<script src="/public/default/js/account.js"></script>
<!-- endbuild -->
</body>
</html>