$(function(){
    // 设置BootBox语言为中文
    bootbox.setDefaults("locale","zh_CN");

    // 扫描物流跟踪号
    $('#Package_tracking_no').focus().keydown( function(e) {
        if (e.keyCode === 13) { // barcode scanned!
            $('#Package_weight').focus();
        }
    });

    // 电子秤重
    $('#Package_weight').keydown( function(e) {
        if (e.keyCode === 13) {
            $('#submit').trigger('click');
        }
    });

    // 提交表单
    $('#submit').click(function () {
        var data = $('#package-form').serialize(),
            url = $('#package-form').attr('action');
        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: data,
            url: url,
            beforeSend: function () {
                $('#submit').prop('disabled',true);
            },
            success: function(res) {
                if (res.success) {
                    $('#audio')[0].play();
                    setTimeout(function() {
                        location.href = res.url;
                    },1000);
                }
            },
            complete: function () {
                $('#submit').prop('disabled',false);
            }
        });
    });

    // 设置日期格式
    $('.datetimepicker').datetimepicker({
        format: 'YYYY-MM-DD HH:mm:ss'
    });

    //删除记录
    $('.js-btn-delete').click(function () {
        var $this = $(this),
            url = $this.data('url');
        bootbox.confirm("你确定要删除此记录吗？", function(result) {
            if (result) {
                location.href = url;
            }
        });
    });

    // 更新记录
    $('.js-btn-update').click(function () {
        var $this = $(this),
            url = $this.data('url');
        $('#myModal').load(url).modal('show');
    });
});