﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="page_import/site_temporaryvar.xslt"/>
  <xsl:import href="page_import/site_countbar.xslt"/>
  <xsl:import href="page_import/site_basefile.xslt"/>
  <xsl:import href="page_import/site_language.xslt"/>
  <xsl:import href="page_import/site_mainmenu.xslt"/>
  <xsl:import href="page_import/site_baseinfo.xslt"/>
  <xsl:import href="page_import/site_adsinfo.xslt"/>
  <xsl:import href="page_import/site_webcounter.xslt"/>
  <xsl:import href="page_import/site_othermenu.xslt"/>
  <xsl:import href="page_import/site_nmbanner.xslt"/>
  <xsl:import href="page_import/sortmenu_column.xslt"/>
  <xsl:import href="page_import/sortmenu_products.xslt"/>
  <xsl:import href="page_import/sortmenu_nmsubmenu.xslt"/>
  <xsl:import href="page_import/index_downslist.xslt"/>
  <xsl:import href="page_import/index_newslist.xslt"/>
  <xsl:import href="page_import/page_productslist.xslt"/>
  <xsl:import href="page_import/index_productslist.xslt"/>
  <xsl:import href="page_import/index_linkslist.xslt"/>
  <xsl:import href="page_import/index_jobslist.xslt"/>
  <xsl:import href="page_import/index_surveylist.xslt"/>
  <xsl:import href="page_import/index_companyinfo.xslt"/>
  <xsl:import href="page_import/index_contactus.xslt"/>
  <xsl:import href="page_import/userdefined_index.xslt"/>
  <xsl:import href="page_import/site_nmindextoplist.xslt"/>
  <xsl:import href="page_import/searchbar_products.xslt"/>
  <xsl:template match="/">
    <xsl:call-template name="import_doctype"/>
    <html>
      <head>
        <xsl:call-template name="import_htmlheader"/>
      </head>
      <body>
        <div class="header mauto clearfix">
          <div class="logo">
            <xsl:call-template name="import_weblogo"/>
          </div>
          <div class="top_nav">
            <ul>
              <xsl:call-template name="import_languagebar"/>
            </ul>
            <ul class="search">
              <xsl:call-template name="import_productsearchbar"/>
            </ul>
          </div>
        </div>
        <div class="clear"></div>
        <div class="topline mauto"></div>
        <div class="i_banner mauto">
          <xsl:call-template name="import_webadsinfo"/>
        </div>
        <div class="i_nav mauto clearfix">
          <ul>
            <xsl:call-template name="import_mainmenubar"/>
          </ul>
        </div>
        <div class="clear"></div>
        <div class="container clearfix mauto">
          <xsl:call-template name="import_nmdefined01"/>
          <div class="i_p_list">
            <h1>
              <a href="{//pagemodules/products_toptitle/@modulelink}"><xsl:value-of select="//pagemodules/products_sortname"/></a>
            </h1>
            <xsl:call-template name="import_indexsortbar_products"/>
            <div>
              <img src="/templates/images/bot1.gif"/>
            </div>
            <xsl:call-template name="import_nmdefined02"/>
          </div>
          <div class="i_n_list">
            <div class="i_n_t">
              <ul class="n1">
                <xsl:call-template name="import_indexsortbar_news"/>
              </ul>
              <ul class="n2">
                <li class="color">
                  <a href="{//pagemodules/news_toptitle/@modulelink}"><xsl:value-of select="//pagemodules/news_toptitle/@modulemore" /></a>
                </li>
              </ul>
            </div>
            <div class="clear"></div>
            <xsl:call-template name="import_indexnews"/>
            <xsl:call-template name="import_nmdefined03"/>
          </div>
          <div class="i_rig">
            <h1>
              <a href="{//indexsingles/company/@singleurl}"><xsl:value-of select="//indexsingles/company/@singleshort"/></a>
            </h1>
            <ul class="i_r_com">
              <xsl:value-of select="//indexsingles/company" disable-output-escaping="yes"/>
            </ul>
            <div class="abc">
              <img src="/templates/images/bot2.gif"/>
            </div>
            <xsl:call-template name="import_nmdefined04"/>
            <h2>
              <xsl:call-template name="import_indexlinks"/>
            </h2>
          </div>
        </div>
        <div class="clear"></div>
        <div class="mtop"></div>
        <div class="footer clearfix mauto">
          <h1></h1>
          <dl>
            <dt>
              <xsl:call-template name="import_othermenubar"/>
            </dt>
            <dd class="color1">
              <xsl:call-template name="import_copyright"/>
              <xsl:call-template name="import_webcounter"/>
              <xsl:call-template name="import_webbackground"/>
              <xsl:call-template name="import_chgbackground"/>
              <xsl:call-template name="import_webbgmusic"/>
            </dd>
          </dl>
          <div class="clear"></div>
          <div class="mtop"></div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>