<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="adsInfoDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webAdsInfo', '.xml'))"/>
  <xsl:variable name="adsInfo" select="$adsInfoDoc/web_adsinfo"/>
  <xsl:template name="import_webadsinfo">
    <xsl:param name="adsType" select="0" />
    <xsl:param name="adsItems" select="$adsInfo/adsitems[@adstype=$adsType]" />
    <xsl:if test="$adsType=0">
    </xsl:if>
    <xsl:if test="$adsType=1">
      <xsl:if test="$adsItems/adsisuseing!=0">
        <script src="/jscript/float_ads.js" language="javascript" type="text/javascript"></script>
        <script type="text/javascript">
          if(window.attachEvent){window.attachEvent('onload',floatAds_Open)}else if(window.addEventListener){window.addEventListener('load',floatAds_Open,false)};function floatAds_Open(){var b=new scrollBanner(10,10);b.add($ById("floatAds"),10,0,1,$ById("ads_close"));b=null}
        </script>
        <style type="text/css">
        #floatAds
        {
            width: 192px;
        }
        #floatAds .floatMain
        {
            clear: both;
        }
        .adsTit
        {
            background: url(/images/ser_title.jpg);
            color: #FFFFFF;
            height: 22px;
            line-height: 22px;
            padding-left: 4px;
        }
        .adsTit span
        {
            float: left;
        }
        .adsTit img
        {
            float: right;
            padding: 3px;
            margin-top: 3px;
            margin-right: 4px;
        }
        .nomralAds
        {
        }
        .minAds
        {
            height: 29px;
        }
        .nomralAds .floatMain
        {
            display: block;
            overflow: auto;
            height: 170px;
            background-color: #E6F7FF;
        }
        .minAds .floatMain
        {
            display: none;
        }
        </style>
        <div id="floatAds" class="nomralAds">
          <div class="adsTit">
            <span>
              <xsl:value-of select="$adsItems/adstopic"/>
            </span>
            <img id="ads_close" src="/images/boxmin.jpg" />
          </div>
          <div class="floatMain">
            <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark" disable-output-escaping="yes"/></a>
          </div>
          <div>
            <img src="/images/ser_b.jpg" width="192" height="7" />
          </div>
        </div>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$adsType=2">
      <div id="floadAds">
        <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark"/></a>
      </div>
    </xsl:if>
    <xsl:if test="$adsType=3">
      <div id="floadAds">
        <a href="{$adsItems/adslink}" target="_blank"><xsl:value-of select="$adsItems/adsremark"/></a>
      </div>
    </xsl:if>
    <xsl:if test="$adsType=4">
      <link rel="stylesheet" type="text/css" href="/templates/fun_css/imgscroll.css"/>
      <script src="/templates/jscript/img_scroll.js" language="javascript" type="text/javascript"></script>
      <script language="javascript" type="text/javascript">
        var showImageIndex = -1;
        var imageTimer;
      </script>
      <div id="flash_show_out">
        <div id="flash_show">
          <div id="flash_img"></div>
          <div id="flash_btn">
            <xsl:for-each select="$adsItems">
              <div class="ads_btnimg" title="{adstopic}">
                <a onClick="javascript:showImage({position()-1});return false;" href="javascript:;">
                  <xsl:value-of select="position()" />
                </a>
              </div>
            </xsl:for-each>
          </div>
        </div>
        <div id="flash_show_ctl" style="display: none;">
          <div id="flash_show_ctl_msg">
            <span class="img_topic">
              <a id="flash_title" href="#"></a>
            </span>
          </div>
        </div>
        <script language="javascript" type="text/javascript">
          var fImgs = new Array();
          <xsl:for-each select="$adsItems">
            fImgs[<xsl:value-of select="position()-1" />] = {title:&quot;<xsl:value-of select="adstopic" />&quot;,img:&quot;<xsl:value-of select="adsfile" />&quot;,href:&quot;<xsl:value-of select="adslink" />&quot;};
          </xsl:for-each>
          imagePlay(fImgs,showImageIndex,imageTimer);
        </script>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>