﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://www.yisence.com/" exclude-result-prefixes="msxsl user">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="lanConfigDoc" select="document(concat('../../','ConfigXML/languageConfig', '.xml'))"/>
  <xsl:variable name="languageConfig" select="$lanConfigDoc/languageconfig"/>
  <xsl:template name="import_languagebar">
    <xsl:param name="iscoverUse" select="0"/>
    <xsl:param name="init" select="0"/>
    <xsl:param name="increase" select="1"/>
    <xsl:param name="languageClass" select="'i_l_link'"/>
    <xsl:param name="languageId" select="$languageConfig/languagekeyid"/>
    <xsl:param name="languageList" select="$languageConfig/languagetopic"/>
    <xsl:param name="languageTitle" select="$languageConfig/languagetitle"/>
    <xsl:param name="languageNum" select="user:getLanLen(string($languageList),'|')"/>
    <xsl:if test="$languageNum &gt; 1">
      <xsl:if test="$init &lt; $languageNum">
        <xsl:if test="$iscoverUse=0">
          <xsl:if test="$init &gt; 0">
            <li>|</li>
          </xsl:if>
          <li>
            <a href="/?lan={user:getLanguage(string($languageList),$init)}_{user:getLanguage(string($languageId),$init)}"><xsl:value-of select="user:getLanguage(string($languageTitle),$init)"/></a>
          </li>
        </xsl:if>
        <xsl:if test="$iscoverUse=1">
          <xsl:if test="$init &gt; 0">|</xsl:if>
          <a href="/?lan={user:getLanguage(string($languageList),$init)}_{user:getLanguage(string($languageId),$init)}"><xsl:value-of select="user:getLanguage(string($languageTitle),$init)"/></a>
        </xsl:if>
        <xsl:call-template name="import_languagebar">
          <xsl:with-param name="iscoverUse" select="$iscoverUse"/>
          <xsl:with-param name="init" select="$init+$increase"/>
          <xsl:with-param name="increase" select="$increase"/>
          <xsl:with-param name="languageClass" select="$languageClass"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
    <xsl:if test="$iscoverUse=1 and $languageNum&lt;=1">
      <xsl:choose>
        <xsl:when test="//pagemodules/entersite_btn!=''">
          <li>
            <a href="index.htm"><xsl:value-of select="//pagemodules/entersite_btn"/></a>
          </li>
        </xsl:when>
        <xsl:otherwise>
          <li>
            <a href="index.htm">Enter</a>
          </li>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
    <xsl:if test="$iscoverUse=0 and $languageNum&lt;=1">
      <xsl:call-template name="import_topcountbar" />
    </xsl:if>
  </xsl:template>
  <msxsl:script language="JavaScript" implements-prefix="user">
    <![CDATA[
        function getLanLen(str,split_chr){if(str==""){return 0;}else{return str.split(split_chr).length;}}
        function getLanguage(str,i){if(str==""){return "";}else{return str.split("|")[i];}}
        ]]>
  </msxsl:script>
</xsl:stylesheet>