﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="nmIndexTopDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/nmIsIndexList', '.xml'))"/>
  <xsl:variable name="nmIsIndexTop" select="$nmIndexTopDoc/nmindextoplists"/>
  <xsl:variable name="indexSortDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexSortList', '.xml'))"/>
  <xsl:variable name="indexSortList" select="$indexSortDoc/indexsortlist"/>
  <xsl:template name="import_isindextop_article">
    <xsl:param name="nmIndexVar" select="'article'" />
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]" />
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <h3>
          <a href="{$nmIsTopItem/@menuurl}"><xsl:value-of select="$nmIsTopItem/@menushort"/></a>
          <img src="/templates/images/icon03.gif" class="img" />
        </h3>
        <div class="i_contont">
          <ul class="nlist">
            <xsl:for-each select="$nmIsTopItem/viewitem">
              <xsl:if test="position()&lt;11">
                <li>
                  <a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic" /></a>
                </li>
              </xsl:if>
            </xsl:for-each>
          </ul>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div title="{$nmIndexVar}">
          友情提示：请在网站“菜单管理”增加(标识栏目参数为：<xsl:value-of select="$nmIndexVar" />)的菜单栏目！
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_isindextop_cases">
    <xsl:param name="nmIndexVar" select="'cases'" />
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]" />
    <h3>
      <a href="{$nmIsTopItem/@menuurl}"><xsl:value-of select="$nmIsTopItem/@menushort"/></a>
      <img src="/templates/images/icon05.gif" class="img" />
    </h3>
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <div class="i_contont">
          <ul class="nlist">
            <xsl:for-each select="$nmIsTopItem/viewitem">
              <xsl:if test="position()&lt;11">
                <li>
                  <a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic" /></a>
                </li>
              </xsl:if>
            </xsl:for-each>
          </ul>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="i_contont" title="{$nmIndexVar}">
          友情提示：请在网站“菜单管理”增加(标识栏目参数为：<xsl:value-of select="$nmIndexVar" />)的菜单栏目！
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_isindextop_honor">
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <xsl:param name="productSellUnitTit" select="//pagemodules/sell_unittit"/>
    <xsl:param name="nmIndexVar" select="'honor'" />
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]" />
    <xsl:for-each select="$nmIsTopItem/viewitem">
      <xsl:if test="position()&lt;7">
        <ul class="i_productlist">
          <li class="img_liouter">
            <a href="{urlpath}" title="{viewtopic}"><img src="{viewimage}" alt="{viewtopic}" /></a>
          </li>
          <li class="pltext">
            <a href="{urlpath}" class="item_title" title="{viewtopic}"><xsl:value-of select="viewtopic"/></a>
            <xsl:if test="viewprice!=0 and viewprice!=''">
              <span class="ithe_price">
                <xsl:value-of select="$productSellUnitTit"/>：<span class="color01">
                  ￥<xsl:value-of select="viewprice"/>
                </span>
              </span>
            </xsl:if>
            <span class="ithe_gobtn">
              <a href="{urlpath}"><img src="/templates/images/look.jpg" /></a>
              <a href="gbook.htm"><img src="/templates/images/buy.jpg" /></a>
            </span>
          </li>
        </ul>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="import_sortindex_products">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="nmIndexVar" select="'products'" />
    <xsl:param name="sortUlClass" select="'i_n_title'"/>
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <xsl:param name="productSellUnitTit" select="//pagemodules/sell_unittit"/>
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]" />
    <xsl:variable name="tab_sortnum">
      <xsl:choose>
        <xsl:when test="//pagemodules/tabsortnum!=''">
          <xsl:choose>
            <xsl:when test="//pagemodules/tabsortnum/@modulemore &gt; 0 and //pagemodules/tabsortnum/@modulemore &lt; 5">
              <xsl:value-of select="//pagemodules/tabsortnum/@modulemore"/>
            </xsl:when>
            <xsl:otherwise>4</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>4</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <ul class="p1tit">
      <li class="p1t0">
        <xsl:value-of select="//pagemodules/products_lasttitle"/>
      </li>
      <li class="p1t1">
        <ul>
          <xsl:for-each select="$indexSortList/sortitem[@nmindexvar=$nmIndexVar and @parentid=$parentId]">
            <xsl:if test="position() &lt;= $tab_sortnum">
              <li id="tabitemid_{position()}" onmouseover="changetab_objdiv('tabitemid_','tabremark_',{position()},{$tab_sortnum},'phover','');">
                <xsl:if test="position()=1">
                  <xsl:attribute name="class">
                    <xsl:value-of select="'phover'"/>
                  </xsl:attribute>
                </xsl:if>
                <xsl:element name="a">
                  <xsl:attribute name="href">
                    <xsl:value-of select="@urlpath"/>
                  </xsl:attribute>
                  <xsl:attribute name="title">
                    <xsl:value-of select="@sorttopic"/>
                  </xsl:attribute>
                  <xsl:value-of select="@sorttopic"/>
                  <xsl:if test="@urltarget=''">
                    <xsl:attribute name="target">
                      <xsl:value-of select="@urltarget"/>
                    </xsl:attribute>
                  </xsl:if>
                </xsl:element>
              </li>
            </xsl:if>
          </xsl:for-each>
        </ul>
      </li>
    </ul>
    <div class="clear"></div>
    <div class="main_p1list">
      <xsl:for-each select="$indexSortList/sortitem[@nmindexvar=$nmIndexVar and @parentid=$parentId]">
        <xsl:if test="position() &lt;= $tab_sortnum">
          <xsl:variable name="item_sortid" select="concat(@parentid,'_',@sortid)" />
          <xsl:variable name="item_subsortid" select="concat(@sortid,'_')" />
          <xsl:variable name="lgth_subsortid" select="string-length(concat(@sortid,'_'))" />
          <ul id="tabremark_{position()}" class="p1list">
            <xsl:if test="position()&gt;1">
              <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:for-each select="$nmIsTopItem/viewitem[viewsort=$item_sortid or substring(viewsort,1,$lgth_subsortid)=$item_subsortid]">
              <xsl:if test="position()&lt;6">
                <li>
                  <a href="{urlpath}" class="img_liouter" title="{viewtopic}"><img src="{viewimage}" alt="{viewtopic}" /></a>
                  <p>
                    <a href="{urlpath}" class="item_title" title="{viewtopic}"><xsl:value-of select="viewtopic"/></a>
                    <xsl:if test="viewprice!=0 and viewprice!=''">
                      <span class="item_price">
                        <xsl:if test="$productSellUnitTit!=''">
                          <xsl:value-of select="$productSellUnitTit"/>：
                        </xsl:if>
                        <span class="color2">
                          ￥<xsl:value-of select="viewprice"/>
                        </span>
                      </span>
                    </xsl:if>
                    <span class="item_gobtn">
                      <a href="{urlpath}"><img src="/templates/images/look.jpg" /></a>
                      <a href="gbook.htm"><img src="/templates/images/buy.jpg" /></a>
                    </span>
                  </p>
                </li>
              </xsl:if>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </xsl:for-each>
    </div>
    <div>
      <img src="/templates/images/pbot1.gif" />
    </div>
  </xsl:template>
</xsl:stylesheet>