<?php

namespace App\Http\Controllers\Admin;


use App\Types\EventOrderItemStatus;
use App\Types\EventOrderStatus;
use Edwin404\Admin\Cms\Field\FieldDatetime;
use Edwin404\Admin\Cms\Field\FieldEmpty;
use Edwin404\Admin\Cms\Field\FieldModel;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Helpers\AdminLogHelper;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\InputHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Demo\Helpers\DemoHelper;
use Edwin404\Shop\Services\GoodsService;
use Edwin404\Shop\Types\OrderStatus;
use Edwin404\SmartAssets\Helper\AssetsHelper;
use Edwin404\Tecmz\Helpers\AdminCmsHelper;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;

class OrderItemController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'event_order_item',
        'pageTitle' => '报名列表',
        'group' => 'data',
        'primaryKeyShow' => false,
        'fields' => [
            'memberUserId' => ['type' => FieldEmpty::class, 'title' => '用户', 'list' => true,],
            'checkCode' => ['type' => FieldText::class, 'title' => '票号', 'search' => true,],
            'status' => ['type' => FieldSelect::class, 'title' => '状态', 'list' => true, 'edit' => true, 'add' => true, 'search' => true, 'optionType' => EventOrderItemStatus::class],
            '_basic' => ['type' => FieldEmpty::class, 'title' => '信息', 'list' => true,],
            '_customField' => ['type' => FieldEmpty::class, 'title' => '信息', 'list' => true,],
            '_action' => ['type' => FieldEmpty::class, 'title' => '操作', 'list' => true,],
        ]
    ];

    public function dataProcessView(&$item, &$record)
    {
        $statusColorMap = [
            EventOrderItemStatus::WAIT_SIGN_IN => '<span class="uk-text-warning">待签到</span>',
            EventOrderItemStatus::COMPLETED => '<span class="uk-text-success">已完成</span>',
            EventOrderItemStatus::ABSENT => '<span class="uk-text-danger">未参加</span>',
        ];
        if (isset($statusColorMap[$record['status']])) {
            $item['status'] = $statusColorMap[$record['status']];
        }
        $item['memberUserId'] = AdminCmsHelper::memberUserId($record['memberUserId']);
    }

    public function dataProcessViewField($key, &$record)
    {
        switch ($key) {
            case '_basic':
                $event = ModelHelper::loadWithCache('event', ['id' => $record['eventId']]);
                return View::make('admin.orderItem.basic', [
                    'event' => $event,
                    'record' => $record,
                ])->render();
            case '_action':
                return View::make('admin.orderItem.viewListAction', [
                    'record' => $record,
                ])->render();
            case '_customField':
                $record['_event'] = ModelHelper::loadWithCache('event', ['id' => $record['eventId']]);
                return View::make('admin.orderItem.fieldCustom', [
                    'orderItem' => $record,
                ])->render();
        }
    }

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);
    }

    public function dataListWaitSignIn(BasicCms $basicCms)
    {
        $this->cmsConfigBasic['fields']['status']['search'] = false;
        $this->cmsConfigBasic['listFilter'] = ['where' => ['status' => EventOrderItemStatus::WAIT_SIGN_IN]];
        return $basicCms->executeList($this, $this->cmsConfigBasic);
    }

    public function dataListCompleted(BasicCms $basicCms)
    {
        $this->cmsConfigBasic['fields']['status']['search'] = false;
        $this->cmsConfigBasic['listFilter'] = ['where' => ['status' => EventOrderItemStatus::COMPLETED]];
        return $basicCms->executeList($this, $this->cmsConfigBasic);
    }

    public function dataListAbsent(BasicCms $basicCms)
    {
        $this->cmsConfigBasic['fields']['status']['search'] = false;
        $this->cmsConfigBasic['listFilter'] = ['where' => ['status' => EventOrderItemStatus::ABSENT]];
        return $basicCms->executeList($this, $this->cmsConfigBasic);
    }

    public function signIn($id)
    {
        if (DemoHelper::shouldDenyAdminDemo()) {
            return Response::send(-1, '演示账号禁止修改信息');
        }
        $order = ModelHelper::load('event_order_item', ['id' => $id]);
        switch ($order['status']) {
            case EventOrderItemStatus::WAIT_SIGN_IN:
                ModelHelper::updateOne('event_order_item', ['id' => $id], ['status' => EventOrderItemStatus::COMPLETED]);
                AdminLogHelper::addInfoLog('报名设置已签到', ['票号' => $order['checkCode']]);
                return Response::send(0, null, null, '[js]window.__cms.action.refresh();');
        }
        return Response::send(-1, '状态错误');
    }

    public function absent($id)
    {
        if (DemoHelper::shouldDenyAdminDemo()) {
            return Response::send(-1, '演示账号禁止修改信息');
        }
        $order = ModelHelper::load('event_order_item', ['id' => $id]);
        switch ($order['status']) {
            case EventOrderItemStatus::WAIT_SIGN_IN:
                ModelHelper::updateOne('event_order_item', ['id' => $id], ['status' => EventOrderItemStatus::ABSENT]);
                AdminLogHelper::addInfoLog('报名设置未参加', ['票号' => $order['checkCode']]);
                return Response::send(0, null, null, '[js]window.__cms.action.refresh();');
        }
        return Response::send(-1, '状态错误');
    }
}