@extends('admin::frame')

@if(empty($event))
    @section('pageTitle','增加活动')
@else
    @section('pageTitle','修改活动')
@endif

@section('adminScript')
    @parent
    <link rel="stylesheet" href="@assets('assets/vue/iview/iview.css')">
    <script src="@assets('assets/vue/iview/iview.js')"></script>
@endsection

@section('bodyAppend')
    @parent
    <script>
        var runtime = {
            applyTextEditor:null,
            applySuccessTextEditor:null,
            contentEditor:null,
            applyInfoEXField:null,
        };
        var data = {
            categoryList:@jsonArray($categoryList),
            categoryId:@jsonNumber($event['categoryId']),
            title:@jsonString($event['title']),
            showStatus:@jsonNumber($event['showStatus']),
            status:@jsonNumber($event['status']),
            time:@jsonDatetime($event['time']),
            applyTimeLimit:@jsonBoolean($event['applyTimeLimit']),
            applyStartTime:@jsonDatetime($event['applyStartTime']),
            applyEndTime:@jsonDatetime($event['applyEndTime']),
            applyNumberLimit:@jsonBoolean($event['applyNumberLimit']),
            applyNumberMax:@jsonNumber($event['applyNumberMax']),
            price:@jsonString($event['price']),
            summary:@jsonString($event['summary']),
            cover:@jsonString($event['cover']),
            photos:@jsonArray($event['photos']),
            param:@jsonArray($event['param']),
            applyText:@jsonString($event['applyText']),
            applySuccessText:@jsonString($event['applySuccessText']),
            fieldCustoms:@jsonArray($event['_fieldCustom']),
            content:@jsonString($event['content']),
        };
        var methods = {
            save:function () {
                window.api.dialog.loadingOn();
                var data = $.extend({},this.$data);
                data.applyText = runtime.applyTextEditor.getContent();
                data.applySuccessText = runtime.applySuccessTextEditor.getContent();
                data.content = runtime.contentEditor.getContent();
                delete data.categoryList;
                $.post('?',{_id:@jsonNumber($_id),data:JSON.stringify(data)},function (res) {
                    window.api.dialog.loadingOff();
                    window.api.base.defaultFormCallback(res);
                });
            }
        };
        var watch={
        };

        runtime.applyInfoEXField = new window.api.EXField({
            appModule:'applyInfoEXField',
            app:function(){
                return app;
            },
            appData:data,
            appMethods:methods,
            appWatch:watch,
            moduleLimit:5,
            moduleData:@jsonArray($event['_fieldCustom']),
            moduleChange:function (modules) {
                if(app){
                    app.fieldCustoms = modules;
                }
            }
        });

        var init = function () {
            runtime.applyTextEditor = window.api.editor('applyText', function () {
                runtime.applyTextEditor.setContent(data.applyText, false);
            });
            runtime.applySuccessTextEditor = window.api.editor('applySuccessText', function () {
                runtime.applySuccessTextEditor.setContent(data.applySuccessText, false);
            });
            runtime.contentEditor = window.api.editor('content', function () {
                runtime.contentEditor.setContent(data.content, false);
            });
            $('[data-cover-box]').on('image-widget.change',function (event,value) {
                if(app){
                    app.cover = value;
                }
            }).imageWidget().val(data.cover);
            $('[data-photos-box]').on('images-widget.change',function (event,value) {
                if(app){
                    app.photos = value;
                }
            }).imagesWidget().val(data.photos);
            $('[data-param-box]').on('attr-widget.change',function (event,value) {
                if(app){
                    app.param = value;
                }
            }).attrWidget().val(data.param);
        };
        var app = new Vue({
            el: '#app',
            data: data,
            methods: methods,
            watch:watch,
            mounted: function () {
                setTimeout(function () {
                    init();
                }, 100);
            }
        });
    </script>
@endsection

@section('bodyContent')

    <div id="app" v-cloak>

        <div class="block admin-form">
            <div class="body">
                <i-form :label-width="100">
                    <Form-item label="分类">
                        <i-select v-model="categoryId" style="width:200px">
                            <i-option v-for="category in categoryList" :value="category.id" :key="category.id">@{{ category.title }}</i-option>
                        </i-select>
                    </Form-item>
                    <Form-item label="名称">
                        <i-input v-model="title"></i-input>
                    </Form-item>
                    <Form-item label="显示：">
                        <Radio-group v-model="showStatus">
                            @foreach(\App\Types\EventShowStatus::getList() as $k=>$v)
                                <Radio label="{{$k}}">{{$v}}</Radio>
                            @endforeach
                        </Radio-group>
                    </Form-item>
                    <Form-item label="状态：">
                        <Radio-group v-model="status">
                            @foreach(\App\Types\EventStatus::getList() as $k=>$v)
                                <Radio label="{{$k}}">{{$v}}</Radio>
                            @endforeach
                        </Radio-group>
                    </Form-item>
                    <Form-item label="时间">
                        <Date-picker type="datetime" v-model="time"></Date-picker>
                    </Form-item>
                    <Form-item label="限制时间">
                        <i-switch v-model="applyTimeLimit"></i-switch>
                    </Form-item>
                    <Form-item label="报名时间" v-show="applyTimeLimit">
                        <Row>
                            <i-col span="4">
                                <Date-picker class="uk-width-1-1" type="datetime" v-model="applyStartTime"></Date-picker>
                            </i-col>
                            <i-col span="1" style="text-align:center">-</i-col>
                            <i-col span="4">
                                <Date-picker class="uk-width-1-1" type="datetime" v-model="applyEndTime"></Date-picker>
                            </i-col>
                        </Row>
                    </Form-item>
                    <Form-item label="限制人数">
                        <i-switch v-model="applyNumberLimit"></i-switch>
                    </Form-item>
                    <Form-item label="人数" v-show="applyNumberLimit">
                        <i-input v-model="applyNumberMax"></i-input>
                    </Form-item>
                    <Form-item label="价格">
                        <i-input v-model="price"></i-input>
                    </Form-item>
                    <Form-item label="活动描述">
                        <i-input v-model="summary" type="textarea" :autosize="{minRows:2}"></i-input>
                    </Form-item>
                    <Form-item label="封面">
                        <div data-image-widget data-cover-box>
                            <input type="hidden" name="cover" data-image value="assets/lib/img/none.png" />
                            <span class="image" style="background-image:url(@assets('assets/lib/img/none.png'));"></span>
                            <span class="add"><i class="uk-icon-plus"></i></span>
                            <span class="delete"><i class="uk-icon-remove"></i></span>
                        </div>
                    </Form-item>
                    <Form-item label="图片">
                        <div data-images-widget data-photos-box>
                            <div class="list">
                                <div class="add">
                                    <i class="uk-icon-plus"></i>
                                </div>
                                <div class="cf"></div>
                            </div>
                            <input data-images type="hidden" name="photos" value="" />
                        </div>
                    </Form-item>
                    <Form-item label="属性">
                        <div data-attr-widget data-param-box>
                            <div class="list">
                            </div>
                            <div class="add">
                                <i class="uk-icon-plus"></i>
                            </div>
                            <input data-attr type="hidden" name="param" value="" />
                        </div>
                    </Form-item>
                    <Form-item label="报名字段">
                        <div class="ex-field">
                            <?php
                            echo (new \Edwin404\EXField\EXField())->setAppModule('applyInfoEXField')->renderEditor([
                                'Text'=>'单行文本',
                                'Radio'=>'单选',
                            ]);
                            ?>
                        </div>
                    </Form-item>
                    <Form-item label="报名说明">
                        <script id="applyText" name="applyText" type="text/plain"></script>
                    </Form-item>
                    <Form-item label="报名成功说明">
                        <script id="applySuccessText" name="applySuccessText" type="text/plain"></script>
                    </Form-item>
                    <Form-item label="详细描述">
                        <script id="content" name="content" type="text/plain"></script>
                    </Form-item>
                </i-form>
            </div>
        </div>

        <div class="bottom-action-spacer"></div>
        <div class="bottom-action">
            <button class="uk-button uk-button-primary" @click="save()">保存</button>
        </div>

    </div>

@endsection