@extends('admin::frameDialog')

@section('pageTitle','订单详情')

@section('dialogBody')

    <div class="admin-form uk-form">
        <table>
            <tbody>
            <tr>
                <td>
                    <div class="line">
                        <div class="label">
                            订单号
                        </div>
                        <div class="value">
                            {{$order['sn']}}
                        </div>
                    </div>
                </td>
                <td>
                    <div class="line">
                        <div class="label">时间</div>
                        <div class="value">{{$order['created_at']}}</div>
                    </div>
                </td>
                <td>
                    <div class="line">
                        <div class="label">
                            状态
                        </div>
                        <div class="field">
                            {{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventOrderStatus::class,$order['status'])}}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="3">
                    <div class="line">
                        <div class="label">报名信息</div>
                        <div class="value">

                            <table class="uk-table" style="border:2px solid #CCC;">
                                <thead style="border-bottom:2px solid #CCC;">
                                    <tr>
                                        <th width="300">活动</th>
                                        <th>信息</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($order['_items'] as $orderItem)
                                        <tr>
                                            <td>
                                                <a class="title" href="/event/{{$orderItem['_event']['id']}}" target="_blank">
                                                    {{$orderItem['_event']['title']}}
                                                </a>
                                            </td>
                                            <td>
                                                <div class="buyInfo">
                                                    @foreach(\Edwin404\EXField\EXFieldUtil::pair($orderItem['_event'],$orderItem) as $item)
                                                        {{$item['name']}}:{{$item['value']}}
                                                        <br>
                                                    @endforeach
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="uk-text-right" style="font-style:normal;font-size:16px;">
                                            <div>
                                                总计：{{$order['totalFee']}}
                                            </div>
                                            <div>
                                                实际支付：{{$order['payFee']}}
                                            </div>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>
    </div>

@endsection
