@extends('theme.default.m.frame')

@section('bodyScript')
    <script src="@assets('assets/m/default/home.js')"></script>
@endsection

@section('pageTitle',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteName')))
@section('pageTitleMain',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteName')))
@section('pageKeywords',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords')))
@section('pageDescription',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteDescription')))
@section('headerLeft')@endsection

@section('bodyContent')

    <div class="pb-home-search">
        <form action="/search" method="get">
            <div class="mui-input-row mui-search">
                <input type="search" name="keyword" class="mui-input-clear" placeholder="输入关键词搜索">
            </div>
        </form>
    </div>

    <div class="pb-home-banner swiper-container">
        <div class="swiper-wrapper">
            @if(empty($banners))
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
                <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
            @else
                @foreach($banners as $banner)
                    <a class="swiper-slide"
                       style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($banner['image'])}});"
                       @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                @endforeach
            @endif
        </div>
        <div class="swiper-pagination"></div>
    </div>

    @foreach($eventCategories as $eventCategory)
        <div class="pb pb-event-list">
            <div class="head">{{$eventCategory['title']}}</div>
            <div class="body">
                @foreach($eventCategory['_events'] as $event)
                    <a href="/event/{{$event['id']}}" class="item">
                        <div class="cover" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}}"></div>
                        <div class="title">
                            @if($event['status']==\App\Types\EventStatus::APPLYING)
                                [正在报名]
                            @else
                                [{{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventStatus::class,$event['status'])}}]
                            @endif
                            {{$event['title']}}
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    @endforeach

@endsection






































