@extends($_frameLayoutView)

@section('pageTitle','我的')
@section('pageTitleMain','我的')
@section('pageKeywords',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords')))
@section('pageDescription',htmlspecialchars(\Edwin404\Config\Facades\ConfigFacade::get('siteDescription')))

@section('bodyContent')

    <div class="pb-member-home-head">
        <div class="body">
            @if(empty($_memberUser['id']))
                <a class="avatar" href="/login?redirect={{urlencode('/member')}}">
                    <img src="@assets('assets/lib/img/avatar.png')" />
                </a>
            @else
                <a class="avatar" href="/member/profile_avatar">
                    <img src="{{$_memberUser['avatar']}}"/>
                </a>
            @endif
            <div class="name">
                @if(empty($_memberUser['id']))
                    @if(!\Edwin404\Config\Facades\ConfigFacade::get('registerDisable',false))
                        登录 / 注册
                    @else
                        点击登录
                    @endif
                @else
                    {{$_memberUser['username']}}的中心
                @endif
            </div>
        </div>
    </div>

    <div class="pb-member-home-order">
        <div class="head">我的订单</div>
        <div class="body">
            <a href="/member/order">
                <i class="iconfont">&#xe601;</i>
                <span>全部</span>
            </a>
            <a href="/member/order?status={{\Edwin404\Shop\Types\OrderStatus::WAIT_PAY}}">
                <i class="iconfont">&#xe683;</i>
                <span>待付款</span>
            </a>
            <a href="/member/order?status={{\Edwin404\Shop\Types\OrderStatus::COMPLETED}}">
                <i class="iconfont">&#xe632;</i>
                <span>已完成</span>
            </a>
        </div>
    </div>
    </div>

    <div class="pb-member-home-nav">
        <ul class="mui-table-view mui-table-view-chevron" style="margin-top:10px;">
            <li class="mui-table-view-cell">
                <a class="mui-navigate-right" href="/member/order">
                    <span class="iconfont">&#xe601;</span>
                    我的活动
                </a>
            </li>
            <li class="mui-table-view-cell">
                <a class="mui-navigate-right" href="/member/profile">
                    <span class="iconfont">&#xe60b;</span>
                    我的资料
                </a>
            </li>
            <li class="mui-table-view-cell">
                <a class="mui-navigate-right" href="/member/profile_password">
                    <span class="iconfont">&#xe60e;</span>
                    修改密码
                </a>
            </li>
        </ul>

        @if(!empty($_memberUser))
            <ul class="mui-table-view mui-table-view-chevron" style="margin-top:10px;">
                <li class="mui-table-view-cell">
                    <a class="mui-navigate-right" href="javascript:;" data-confirm="确定退出？" data-href="/logout">
                        <span class="iconfont">&#xe70f;</span>
                        退出登录
                    </a>
                </li>
            </ul>
        @endif

    </div>

@endsection