@extends('theme.default.pc.frame')

@section('pageTitle',\Edwin404\Config\Facades\ConfigFacade::get('siteName'))

@section('bodyScript')
    <script src="@assets('assets/main/default/home.js')"></script>
@endsection

@section('bodyContent')

    <div class="pb-home-banner">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                @if(empty($banners))
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x400');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x400');"></a>
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x400');"></a>
                @else
                    @foreach($banners as $banner)
                        <a class="swiper-slide"
                           style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($banner['image'])}});"
                           @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                    @endforeach
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination-white"></div>
            <div class="swiper-button-next swiper-button-white"></div>
            <div class="swiper-button-prev swiper-button-white"></div>
        </div>
    </div>

    <div class="main-container">

        @foreach($eventCategories as $eventCategory)
            <div class="pb-event-list" style="margin-top:30px;">
                <div class="head">
                    <div class="more">
                        <a href="/category/{{$eventCategory['id']}}">更多&gt;&gt;</a>
                    </div>
                    <div class="title">
                        {{$eventCategory['title']}}
                        <span class="sub">
                        {{$eventCategory['summary']}}
                    </span>
                    </div>
                </div>
                <div class="body">
                    <div class="list">
                        <div class="uk-grid">
                            @foreach($eventCategory['_events'] as $event)
                                <div class="uk-width-1-4">
                                    <a href="/event/{{$event['id']}}" class="item">
                                        <div class="cover" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}}"></div>
                                        <div class="title uk-text-truncate">
                                            {{$event['title']}}
                                        </div>
                                        <div class="attr">
                                            <div class="time">
                                                <i class="uk-icon-clock-o"></i>
                                                {{\Carbon\Carbon::parse($event['time'])->toDateString()}}
                                            </div>
                                            <div class="status">
                                                @if($event['status']==\App\Types\EventStatus::APPLYING)
                                                    <span class="uk-text-success">正在报名</span>
                                                @else
                                                    {{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventStatus::class,$event['status'])}}
                                                @endif
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

    </div>


@endsection