@extends('theme.default.pc.frame')

@section('pageTitleMain','订单支付')

@section('headerNav')@endsection

@section('bodyScript')
    <script src="@assets('assets/main/default/memberOrderPay.js')"></script>
@endsection

@section('bodyContent')

    <div class="main-container">
        <div class="pb-member-order-pay">
            <div class="container">

                <div>

                    <div class="pay-summary">
                        <div>
                            支付订单：{{$order['sn']}}
                        </div>
                        <div>
                            共支付
                            <span>￥{{$order['payFee']}}</span>
                            元，请选择支付：
                        </div>
                    </div>

                    @if( \Edwin404\Tecmz\Helpers\PayHelper::hasPay() )
                        <div class="pay-list">

                            @if(\Edwin404\Tecmz\Helpers\PayHelper::isAlipayEnable())
                                <a href="javascript:;" data-type="{{\Edwin404\Pay\Types\PayType::ALIPAY}}">
                                    <img src="@assets('theme/default/pc/img/alipay.jpg')"/>
                                    支付宝
                                </a>
                            @endif

                            @if(\Edwin404\Tecmz\Helpers\PayHelper::isWechatEnable())
                                <a href="javascript:;" data-type="{{\Edwin404\Pay\Types\PayType::WECHAT}}">
                                    <img src="@assets('theme/default/pc/img/wechat.jpg')"/>
                                    微信支付
                                </a>
                            @endif

                        </div>

                        <div class="pay-submit">
                            <a href="javascript:;" data-pay-submit>确定支付</a>
                        </div>

                    @else

                        <div class="pay-list">
                            <div class="uk-alert uk-alert-danger">
                                没有开启任何支付方式 T_T
                            </div>
                        </div>

                    @endif

                </div>

            </div>
        </div>
    </div>

@endsection