﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;

namespace ResMangSys
{
    public partial class CombineBaStaQuery : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                using (SqlConnection con = new SqlConnection(GetList.connString))
                {
                    con.Open();
                    ddlBaStaLevel.DataSource = GetDataList("select distinct BaStaLevel from T_NetResLedg", con, "BaStaLevel");
                    ddlBaStaLevel.DataBind();
                    ddlEquiSitu.DataSource = GetDataList("select distinct EquiSitu from T_NetResLedg", con, "EquiSitu");
                    ddlEquiSitu.DataBind();
                    ddlEngRomType.DataSource = GetDataList("select distinct EngRomType from T_NetResLedg", con, "EngRomType");
                    ddlEngRomType.DataBind();
                    ddlAirCondFact.DataSource = GetDataList("select distinct AirCondFact from T_NetResLedg", con, "AirCondFact");
                    ddlAirCondFact.DataBind();
                    ddlIronTowType.DataSource = GetDataList("select distinct IronTowType from T_NetResLedg", con, "IronTowType");
                    ddlIronTowType.DataBind();
                    ddlIsSelfCreaTrans.DataSource = GetDataList("select distinct IsSelfCreaTrans from T_NetResLedg", con, "IsSelfCreaTrans");
                    ddlIsSelfCreaTrans.DataBind();
                    ddlAttrLocal.DataSource = GetDataList("select distinct AttrLocal from T_NetResLedg", con, "AttrLocal");
                    ddlAttrLocal.DataBind();
                    con.Close();
                }
            }
            else
            {
                if (ddlAirCondFact.SelectedItem.Text == "--空调厂家--" && ddlBaStaLevel.SelectedItem.Text == "--基站等级--" && ddlEngRomType.SelectedItem.Text == "--机房类型--" && ddlEquiSitu.SelectedItem.Text == "--设备情况--" && ddlIronTowType.SelectedItem.Text == "--铁塔类型--" && ddlIsSelfCreaTrans.SelectedItem.Text == "--自建变压器--")
                {
                    //AttrLocal.SelectedItem.Text获得数据
                    LVRepNetResLedg.DataSourceID = "ODSNetResLedgByAttrLocal";
                }
                else
                {
                    if (ddlAirCondFact.SelectedItem.Text != "--空调厂家--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalAir";
                    }
                    if (ddlBaStaLevel.SelectedItem.Text != "--基站等级--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalLevel";
                    }
                    if (ddlEngRomType.SelectedItem.Text != "--机房类型--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalEngRom";
                    }
                    if (ddlEquiSitu.SelectedItem.Text != "--设备情况--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalEqui";
                    }
                    if (ddlIronTowType.SelectedItem.Text != "--铁塔类型--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalIronTow";
                    }
                    if (ddlIsSelfCreaTrans.SelectedItem.Text != "--自建变压器--")
                    {
                        LVRepNetResLedg.DataSourceID = "ODSNetResLedgByLocalTrans";
                    }
                    //AttrLocal.SelectedItem.Text and 一个选项值arg组合获得数据
                }
            }
        }
        private string[] GetDataList(string sqlString,SqlConnection conn,string colName)
        {
            List<string> returnData = new List<string>();
            using (SqlCommand cmd = new SqlCommand(sqlString, conn))
            {
                using (SqlDataReader myReader = cmd.ExecuteReader())
                {
                    while (myReader.Read())
                    {
                        if (!string.IsNullOrEmpty(myReader[colName].ToString()))
                        {
                            returnData.Add(myReader[colName].ToString());
                        }
                    }
                }
            }
            return returnData.ToArray();
        } 
    }
}