﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Data.SqlClient;

namespace ResMangSys
{
    public partial class ImportNetResLedg : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["id"] != null)
                {
                    if (Session["role"].ToString() != "manager")
                    {
                        Response.Redirect("Default.aspx");
                        return;
                    }
                }
                else
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
                string savePath = Server.MapPath("~/UpFiles/") + "网络资源台账.xls";
                if (File.Exists(savePath))
                {
                    ltDate.Text = File.GetLastWriteTime(savePath).ToLocalTime().ToString();
                }
                else
                {
                    ltDate.Text = "第一次导入表！";
                }
            }
            else
            {
                if (Session["id"] == null)
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
                if (Session["role"].ToString() != "manager")
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
            }
        }

        protected void btnImport_Click(object sender, EventArgs e)
        {
            if (FUNetResLedg.HasFile == false)
            {
                ltErrorMessage.Text = "请您选择Excel文件";
                return;
            }
            string IsXls = Path.GetExtension(FUNetResLedg.FileName).ToLower();
            if (IsXls != ".xls" && IsXls != ".xlsx")
            {
                ltErrorMessage.Text = "只可以选择Excel文件";
                return;
            }
            string filename = FUNetResLedg.FileName;
            string savePath = Server.MapPath("~/UpFiles/") + filename;
            if (File.Exists(savePath))
            {
                File.Delete(savePath);
            }
            FUNetResLedg.SaveAs(savePath);

            //office 2003导入
            using (SqlConnection con = new SqlConnection(GetList.connString))
            {
                try
                {
                    con.Open();
                    using (SqlCommand cmd = new SqlCommand("insert into T_NetResLedg select * from OPENROWSET('MICROSOFT.JET.OLEDB.4.0','Excel 5.0;HDR=YES;DATABASE=" + savePath + "',Sheet1$)", con))
                    {
                        if (cmd.ExecuteNonQuery() > 0)
                        {
                            ltErrorMessage.Text = "☞Excel表数据已成功导入。请不要重复导入！☜";
                            if (File.Exists(savePath))
                            {
                                ltDate.Text = File.GetLastWriteTime(savePath).ToLocalTime().ToString() + "导入成功";
                            }
                            //Response.Redirect("UpdataSuccess.aspx");
                        }
                    }
                }
                catch
                {
                    ltErrorMessage.Text = "☞Excel表数据导入失败。请先检查Excel表是否为要导入的数据表？请再检查Excel表中的第一个工作簿名称是否为'Sheet1'？如不是请改之为'Sheet1'，若是请检查工作簿中的各列的值的数据类型是否合法？比如整数型的写成了‘2.3’、‘2个’或写成汉字，凡是数字类型的数据后面不能带单位，也不能写成汉字，只能写成数字形式，否则将造成数据导入失败！☜";
                    if (File.Exists(savePath))
                    {
                        ltDate.Text = File.GetLastWriteTime(savePath).ToLocalTime().ToString() + "导入失败";
                    }
                }
                finally
                {
                    con.Close();
                }
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            SqlConnection con = new SqlConnection(GetList.connString);
            try
            {
                con.Open();
                SqlCommand cmd = new SqlCommand("delete from T_NetResLedg", con);
                if (cmd.ExecuteNonQuery() > 0)
                {
                    ltErrorMessage.Text = "☞清空成功！☜";
                }
                else
                {
                    ltErrorMessage.Text = "☞清空失败！☜";
                }
            }
            catch
            {
                ltErrorMessage.Text = "☞数据库连接或清空失败！☜";
            }
            finally
            {
                con.Close();
            }
        }
    }
}