﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using NPOI.HSSF.UserModel;
using System.Data.SqlClient;
using System.Data;
using ResMangSys.DAL.NetResChgTableAdapters;

namespace ResMangSys
{
    /// <summary>
    /// NetResChg 的摘要说明
    /// </summary>
    public class NetResChg : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "application/vnd.ms-excel";
            string filename = HttpUtility.UrlEncode("网络资源变更明细.xls");
            context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);

            string bastaid=context.Request["bastaid"];

            T_NetResChgTableAdapter adapter = new T_NetResChgTableAdapter();
            var NetResChgTable=adapter.GetNetResChgDataByBaStaId(bastaid);
            

            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.CreateSheet();

            //SqlConnection conn;
            //SqlCommand cmd;
            //string cmdString = "select * from T_NetResLedg where BaStaId="+bastaid;
            ////string cmdString = sqlString;
            //conn = new SqlConnection(GetList.connString);
            //cmd = new SqlCommand(cmdString, conn);
            //conn.Open();
            //SqlDataReader myReader;
            ////List<string> returnData = new List<string>();
            //myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            int rownum = 1;
            HSSFRow rowhead = sheet.CreateRow(0);
            //rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("序号");
            rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("基站编号");
            rowhead.CreateCell(1, HSSFCellType.STRING).SetCellValue("基站名称");
            rowhead.CreateCell(2, HSSFCellType.STRING).SetCellValue("变更设备类别");
            rowhead.CreateCell(3, HSSFCellType.STRING).SetCellValue("变更记录");
            foreach(var datarow in NetResChgTable)
            {
                HSSFRow row = sheet.CreateRow(rownum);
                string BaStaName = datarow.IsBaStaNameNull() == true ? "" : datarow.BaStaName;
                string ChgEquiCate = datarow.IsChgEquiCateNull() == true ? "" : datarow.ChgEquiCate;
                string ChgRecord = datarow.IsChgRecordNull() == true ? "" : datarow.ChgRecord;
                //row.CreateCell(0, HSSFCellType.NUMERIC).SetCellValue(datarow.Id);
                row.CreateCell(0, HSSFCellType.STRING).SetCellValue(datarow.BaStaId);
                row.CreateCell(1, HSSFCellType.STRING).SetCellValue(BaStaName);
                row.CreateCell(2, HSSFCellType.STRING).SetCellValue(ChgEquiCate);
                row.CreateCell(3, HSSFCellType.STRING).SetCellValue(ChgRecord);
                rownum++;
                //returnData.Add(myReader["BaStaName"].ToString());
            }
            
            workbook.Write(context.Response.OutputStream);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}