﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using ResMangSys.DAL.NetResLedgTableAdapters;
using NPOI.HSSF.UserModel;

namespace ResMangSys
{
    /// <summary>
    /// NetResLedg 的摘要说明
    /// </summary>
    public class NetResLedg : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "application/vnd.ms-excel";
            string filename = HttpUtility.UrlEncode("网络资源台账.xls");
            context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);

            T_NetResLedgTableAdapter adapter = new T_NetResLedgTableAdapter();
            ResMangSys.DAL.NetResLedg.T_NetResLedgDataTable NetResLedgTable=null;

            string sign = context.Request["sign"];
            
            switch (sign)
            {
                case "0": NetResLedgTable = adapter.GetDataByAttrLocal(context.Request["attrlocal"]); break;
                case "1": NetResLedgTable = adapter.GetDataByLocalLevel(context.Request["attrlocal"], context.Request["arg"]); break;
                case "2": NetResLedgTable = adapter.GetDataByLocalEqui(context.Request["attrlocal"], context.Request["arg"]); break;
                case "3": NetResLedgTable = adapter.GetDataByLocalEngRom(context.Request["attrlocal"], context.Request["arg"]); break;
                case "4": NetResLedgTable = adapter.GetDataByLocalAir(context.Request["attrlocal"], context.Request["arg"]); break;
                case "5": NetResLedgTable = adapter.GetDataByLocalIronTow(context.Request["attrlocal"], context.Request["arg"]); break;
                case "6": NetResLedgTable = adapter.GetDataByLocalTrans(context.Request["attrlocal"], context.Request["arg"]); break;
                case "7": NetResLedgTable = adapter.GetData(); break;
            }

            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.CreateSheet();

            int rownum = 1;
            HSSFRow rowhead = sheet.CreateRow(0);
            //rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("序号");
            rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("主设备厂家");
            rowhead.CreateCell(1, HSSFCellType.STRING).SetCellValue("主设备类别");
            rowhead.CreateCell(2, HSSFCellType.STRING).SetCellValue("基站等级");
            rowhead.CreateCell(3, HSSFCellType.STRING).SetCellValue("基站编号");
            rowhead.CreateCell(4, HSSFCellType.STRING).SetCellValue("基站名称");
            rowhead.CreateCell(5, HSSFCellType.STRING).SetCellValue("归属地");
            rowhead.CreateCell(6, HSSFCellType.STRING).SetCellValue("基站归属期别");
            rowhead.CreateCell(7, HSSFCellType.STRING).SetCellValue("基站入网时间");
            rowhead.CreateCell(8, HSSFCellType.STRING).SetCellValue("基站具体位置");
            rowhead.CreateCell(9, HSSFCellType.STRING).SetCellValue("基站设备情况");
            rowhead.CreateCell(10, HSSFCellType.STRING).SetCellValue("基站内其他设备编号");
            rowhead.CreateCell(11, HSSFCellType.STRING).SetCellValue("机房类型");
            rowhead.CreateCell(12, HSSFCellType.STRING).SetCellValue("基站配套归属");
            rowhead.CreateCell(13, HSSFCellType.STRING).SetCellValue("基站空调厂家");
            rowhead.CreateCell(14, HSSFCellType.STRING).SetCellValue("空调型号");
            rowhead.CreateCell(15, HSSFCellType.STRING).SetCellValue("空调启用时间");
            rowhead.CreateCell(16, HSSFCellType.STRING).SetCellValue("蓄电池I厂家");
            rowhead.CreateCell(17, HSSFCellType.STRING).SetCellValue("蓄电池I型号");
            rowhead.CreateCell(18, HSSFCellType.STRING).SetCellValue("蓄电池I启用时间");
            rowhead.CreateCell(19, HSSFCellType.STRING).SetCellValue("蓄电池II厂家");
            rowhead.CreateCell(20, HSSFCellType.STRING).SetCellValue("蓄电池II型号");
            rowhead.CreateCell(21, HSSFCellType.STRING).SetCellValue("蓄电池II启用时间");
            rowhead.CreateCell(22, HSSFCellType.STRING).SetCellValue("天线极化方式");
            rowhead.CreateCell(23, HSSFCellType.STRING).SetCellValue("天线挂高");
            rowhead.CreateCell(24, HSSFCellType.STRING).SetCellValue("天线所在平台");
            rowhead.CreateCell(25, HSSFCellType.STRING).SetCellValue("铁塔类型");
            rowhead.CreateCell(26, HSSFCellType.STRING).SetCellValue("铁塔高度(m)");
            rowhead.CreateCell(27, HSSFCellType.STRING).SetCellValue("铁塔平台数");
            rowhead.CreateCell(28, HSSFCellType.STRING).SetCellValue("机房所在楼层");
            rowhead.CreateCell(29, HSSFCellType.STRING).SetCellValue("机房面积(m*m)");
            rowhead.CreateCell(30, HSSFCellType.STRING).SetCellValue("是否为自建变压器");
            rowhead.CreateCell(31, HSSFCellType.STRING).SetCellValue("变压器厂家");
            rowhead.CreateCell(32, HSSFCellType.STRING).SetCellValue("变压器型号");
            rowhead.CreateCell(33, HSSFCellType.STRING).SetCellValue("额定功率(kw)");
            rowhead.CreateCell(34, HSSFCellType.STRING).SetCellValue("市电引入长度(m)");
            rowhead.CreateCell(35, HSSFCellType.STRING).SetCellValue("交流配电箱厂家");
            rowhead.CreateCell(36, HSSFCellType.STRING).SetCellValue("交流配电箱型号");
            rowhead.CreateCell(37, HSSFCellType.STRING).SetCellValue("浪涌抑制器厂家");
            rowhead.CreateCell(38, HSSFCellType.STRING).SetCellValue("浪涌抑制器型号");
            rowhead.CreateCell(39, HSSFCellType.STRING).SetCellValue("环境监控厂家");
            rowhead.CreateCell(40, HSSFCellType.STRING).SetCellValue("环境监控型号");
            rowhead.CreateCell(41, HSSFCellType.STRING).SetCellValue("开关电源厂家");
            rowhead.CreateCell(42, HSSFCellType.STRING).SetCellValue("开关电源型号");
            rowhead.CreateCell(43, HSSFCellType.STRING).SetCellValue("整流模块型号");
            rowhead.CreateCell(44, HSSFCellType.STRING).SetCellValue("现网模块配置数量");
            rowhead.CreateCell(45, HSSFCellType.STRING).SetCellValue("单模块额定电流");
            rowhead.CreateCell(46, HSSFCellType.STRING).SetCellValue("悬挂灭火器厂家");
            rowhead.CreateCell(47, HSSFCellType.STRING).SetCellValue("悬挂灭火器型号");
            rowhead.CreateCell(48, HSSFCellType.STRING).SetCellValue("手提灭火器厂家");
            rowhead.CreateCell(49, HSSFCellType.STRING).SetCellValue("手提灭火器型号");
            rowhead.CreateCell(50, HSSFCellType.STRING).SetCellValue("手提灭火器年检时间");
            rowhead.CreateCell(51, HSSFCellType.STRING).SetCellValue("场地租赁合同号");
            rowhead.CreateCell(52, HSSFCellType.STRING).SetCellValue("合同签约方");
            rowhead.CreateCell(53, HSSFCellType.STRING).SetCellValue("租用起始时间");
            rowhead.CreateCell(54, HSSFCellType.STRING).SetCellValue("计划退租时间");
            rowhead.CreateCell(55, HSSFCellType.STRING).SetCellValue("年租金");
            rowhead.CreateCell(56, HSSFCellType.STRING).SetCellValue("最后一次付款月份");
            rowhead.CreateCell(57, HSSFCellType.STRING).SetCellValue("最后一次付租金受益截止日");
            rowhead.CreateCell(58, HSSFCellType.STRING).SetCellValue("业主情况介绍");
            rowhead.CreateCell(59, HSSFCellType.STRING).SetCellValue("备注");
            foreach (var datarow in NetResLedgTable)
            {
                HSSFRow row = sheet.CreateRow(rownum);
                string MainFact = datarow.IsMainFactNull() == true ? "" : datarow.MainFact;
                string MainCate = datarow.IsMainCateNull() == true ? "" : datarow.MainCate;
                string BaStaLevel = datarow.IsBaStaLevelNull() == true ? "" : datarow.BaStaLevel;
                string BaStaId = datarow.BaStaId;
                string BaStaName = datarow.BaStaName;
                string AttrLocal = datarow.IsAttrLocalNull() == true ? "" : datarow.AttrLocal;
                string AttrOfOther = datarow.IsAttrOfOtherNull() == true ? "" : datarow.AttrOfOther;
                string NetWorkDate = datarow.IsNetWorkDateNull() == true ? "" : datarow.NetWorkDate.ToShortDateString();
                string SpecLocal = datarow.IsSpecLocalNull() == true ? "" : datarow.SpecLocal;
                string EquiSitu = datarow.IsEquiSituNull() == true ? "" : datarow.EquiSitu;
                string EquiId = datarow.IsEquiIdNull() == true ? "" : datarow.EquiId;
                string EngRomType = datarow.IsEngRomTypeNull() == true ? "" : datarow.EngRomType;
                string MatchAttr=datarow.IsMatchAttrNull()==true?"":datarow.MatchAttr;
                string AirCondFact = datarow.IsAirCondFactNull() == true ? "" : datarow.AirCondFact;
                string AirCondType = datarow.IsAirCondTypeNull() == true ? "" : datarow.AirCondType;
                string AirCondStarDate = datarow.IsAirCondStarDateNull() == true ? "" : datarow.AirCondStarDate.ToShortDateString();
                string BattIFact = datarow.IsBattIFactNull() == true ? "" : datarow.BattIFact;
                string BattIType = datarow.IsBattITypeNull() == true ? "" : datarow.BattIType;
                string BattIStarDate = datarow.IsBattIStarDateNull() == true ? "" : datarow.BattIStarDate.ToShortDateString();
                string BattIIFact = datarow.IsBattIIFactNull() == true ? "" : datarow.BattIIFact;
                string BattIIType = datarow.IsBattIITypeNull() == true ? "" : datarow.BattIIType;
                string BattIIStarDate = datarow.IsBattIIStarDateNull() == true ? "" : datarow.BattIIStarDate.ToShortDateString();
                string AntePolaWay = datarow.IsAntePolaWayNull() == true ? "" : datarow.AntePolaWay;
                string AnteHight = datarow.IsAnteHightNull() == true ? "" : datarow.AnteHight.ToString();
                string AntePlat = datarow.IsAntePlatNull() == true ? "" : datarow.AntePlat.ToString();
                string IronTowType = datarow.IsIronTowTypeNull() == true ? "" : datarow.IronTowType;
                string IronTowHight = datarow.IsIronTowHightNull() == true ? "" : datarow.IronTowHight.ToString();
                string IronTowCount = datarow.IsIronTowCountNull() == true ? "" : datarow.IronTowCount.ToString();
                string EngRomFloor = datarow.IsEngRomFloorNull() == true ? "" : datarow.EngRomFloor.ToString();
                string EngRomArea = datarow.IsEngRomAreaNull() == true ? "" : datarow.EngRomArea.ToString();
                string IsSelfCreaTrans = datarow.IsIsSelfCreaTransNull() == true ? "" : datarow.IsSelfCreaTrans;
                string TransFact = datarow.IsTransFactNull() == true ? "" : datarow.TransFact;
                string TransType = datarow.IsTransTypeNull() == true ? "" : datarow.TransType;
                string RatePower = datarow.IsRatePowerNull() == true ? "" : datarow.RatePower.ToString();
                string InpCityElecLeng = datarow.IsInpCityElecLengNull() == true ? "" : datarow.InpCityElecLeng.ToString();
                string ACDistBoxFact = datarow.IsACDistBoxFactNull() == true ? "" : datarow.ACDistBoxFact;
                string ACDistBoxType = datarow.IsACDistBoxTypeNull() == true ? "" : datarow.ACDistBoxType;
                string LYSupprFact = datarow.IsLYSupprFactNull() == true ? "" : datarow.LYSupprFact;
                string LYSupprType = datarow.IsLYSupprTypeNull() == true ? "" : datarow.LYSupprType;
                string EnviContrFact = datarow.IsEnviContrFactNull() == true ? "" : datarow.EnviContrFact;
                string EnviContrType = datarow.IsEnviContrTypeNull() == true ? "" : datarow.EnviContrType;
                string SwitPowFact = datarow.IsSwitPowFactNull() == true ? "" : datarow.SwitPowFact;
                string SwitPowType = datarow.IsSwitPowTypeNull() == true ? "" : datarow.SwitPowType;
                string ZhLModeType = datarow.IsZhLModeTypeNull() == true ? "" : datarow.ZhLModeType;
                string NetMConfiCount = datarow.IsNetMConfiCountNull() == true ? "" : datarow.NetMConfiCount.ToString();
                string SingMRateI = datarow.IsSingMRateINull() == true ? "" : datarow.SingMRateI.ToString();
                string SuspFirFigFact = datarow.IsSuspFirFigFactNull() == true ? "" : datarow.SuspFirFigFact;
                string SuspFirFigType = datarow.IsSuspFirFigTypeNull() == true ? "" : datarow.SuspFirFigType;
                string HandFirFigFact = datarow.IsHandFirFigFactNull() == true ? "" : datarow.HandFirFigFact;
                string HandFirFigType = datarow.IsHandFirFigTypeNull() == true ? "" : datarow.HandFirFigType;
                string FirFigNJDate = datarow.IsFirFigNJDateNull() == true ? "" : datarow.FirFigNJDate.ToShortDateString();
                string SiteRentHTNo = datarow.IsSiteRentHtNoNull() == true ? "" : datarow.SiteRentHtNo;
                string HTSignName = datarow.IsHTSingnNameNull() == true ? "" : datarow.HTSingnName;
                string RentStarTime = datarow.IsRentStarTimeNull() == true ? "" : datarow.RentStarTime.ToShortDateString();
                string RentEndTime = datarow.IsRentEndTimeNull() == true ? "" : datarow.RentEndTime.ToShortDateString();
                string YearRentCost = datarow.IsYearRentCostNull() == true ? "" : datarow.YearRentCost.ToString();
                string LastPayDate = datarow.IsLastPayDateNull() == true ? "" : datarow.LastPayDate.ToShortDateString();
                string LastEndTime = datarow.IsLastEndTimeNull() == true ? "" : datarow.LastEndTime.ToShortDateString();
                string HostSitu = datarow.IsHostSituNull() == true ? "" : datarow.HostSitu;
                string Remark = datarow.IsRemarkNull() == true ? "" : datarow.Remark;

                //row.CreateCell(0, HSSFCellType.NUMERIC).SetCellValue(datarow.Id);
                row.CreateCell(0, HSSFCellType.STRING).SetCellValue(MainFact);
                row.CreateCell(1, HSSFCellType.STRING).SetCellValue(MainCate);
                row.CreateCell(2, HSSFCellType.STRING).SetCellValue(BaStaLevel);
                row.CreateCell(3, HSSFCellType.STRING).SetCellValue(BaStaId);
                row.CreateCell(4, HSSFCellType.STRING).SetCellValue(BaStaName);
                row.CreateCell(5, HSSFCellType.STRING).SetCellValue(AttrLocal);
                row.CreateCell(6, HSSFCellType.STRING).SetCellValue(AttrOfOther);
                row.CreateCell(7, HSSFCellType.STRING).SetCellValue(NetWorkDate);
                row.CreateCell(8, HSSFCellType.STRING).SetCellValue(SpecLocal);
                row.CreateCell(9, HSSFCellType.STRING).SetCellValue(EquiSitu);
                row.CreateCell(10, HSSFCellType.STRING).SetCellValue(EquiId);
                row.CreateCell(11, HSSFCellType.STRING).SetCellValue(EngRomType);
                row.CreateCell(12, HSSFCellType.STRING).SetCellValue(MatchAttr);
                row.CreateCell(13, HSSFCellType.STRING).SetCellValue(AirCondFact);
                row.CreateCell(14, HSSFCellType.STRING).SetCellValue(AirCondType);
                row.CreateCell(15, HSSFCellType.STRING).SetCellValue(AirCondStarDate);
                row.CreateCell(16, HSSFCellType.STRING).SetCellValue(BattIFact);
                row.CreateCell(17, HSSFCellType.STRING).SetCellValue(BattIType);
                row.CreateCell(18, HSSFCellType.STRING).SetCellValue(BattIStarDate);
                row.CreateCell(19, HSSFCellType.STRING).SetCellValue(BattIIFact);
                row.CreateCell(20, HSSFCellType.STRING).SetCellValue(BattIIType);
                row.CreateCell(21, HSSFCellType.STRING).SetCellValue(BattIIStarDate);
                row.CreateCell(22, HSSFCellType.STRING).SetCellValue(AntePolaWay);
                row.CreateCell(23, HSSFCellType.STRING).SetCellValue(AnteHight);
                row.CreateCell(24, HSSFCellType.STRING).SetCellValue(AntePlat);
                row.CreateCell(25, HSSFCellType.STRING).SetCellValue(IronTowType);
                row.CreateCell(26, HSSFCellType.STRING).SetCellValue(IronTowHight);
                row.CreateCell(27, HSSFCellType.STRING).SetCellValue(IronTowCount);
                row.CreateCell(28, HSSFCellType.STRING).SetCellValue(EngRomFloor);
                row.CreateCell(29, HSSFCellType.STRING).SetCellValue(EngRomArea);
                row.CreateCell(30, HSSFCellType.STRING).SetCellValue(IsSelfCreaTrans);
                row.CreateCell(31, HSSFCellType.STRING).SetCellValue(TransFact);
                row.CreateCell(32, HSSFCellType.STRING).SetCellValue(TransType);
                row.CreateCell(33, HSSFCellType.STRING).SetCellValue(RatePower);
                row.CreateCell(34, HSSFCellType.STRING).SetCellValue(InpCityElecLeng);
                row.CreateCell(35, HSSFCellType.STRING).SetCellValue(ACDistBoxFact);
                row.CreateCell(36, HSSFCellType.STRING).SetCellValue(ACDistBoxType);
                row.CreateCell(37, HSSFCellType.STRING).SetCellValue(LYSupprFact);
                row.CreateCell(38, HSSFCellType.STRING).SetCellValue(LYSupprType);
                row.CreateCell(39, HSSFCellType.STRING).SetCellValue(EnviContrFact);
                row.CreateCell(40, HSSFCellType.STRING).SetCellValue(EnviContrType);
                row.CreateCell(41, HSSFCellType.STRING).SetCellValue(SwitPowFact);
                row.CreateCell(42, HSSFCellType.STRING).SetCellValue(SwitPowType);
                row.CreateCell(43, HSSFCellType.STRING).SetCellValue(ZhLModeType);
                row.CreateCell(44, HSSFCellType.STRING).SetCellValue(NetMConfiCount);
                row.CreateCell(45, HSSFCellType.STRING).SetCellValue(SingMRateI);
                row.CreateCell(46, HSSFCellType.STRING).SetCellValue(SuspFirFigFact);
                row.CreateCell(47, HSSFCellType.STRING).SetCellValue(SuspFirFigType);
                row.CreateCell(48, HSSFCellType.STRING).SetCellValue(HandFirFigFact);
                row.CreateCell(49, HSSFCellType.STRING).SetCellValue(HandFirFigType);
                row.CreateCell(50, HSSFCellType.STRING).SetCellValue(FirFigNJDate);
                row.CreateCell(51, HSSFCellType.STRING).SetCellValue(SiteRentHTNo);
                row.CreateCell(52, HSSFCellType.STRING).SetCellValue(HTSignName);
                row.CreateCell(53, HSSFCellType.STRING).SetCellValue(RentStarTime);
                row.CreateCell(54, HSSFCellType.STRING).SetCellValue(RentEndTime);
                row.CreateCell(55, HSSFCellType.STRING).SetCellValue(YearRentCost);
                row.CreateCell(56, HSSFCellType.STRING).SetCellValue(LastPayDate);
                row.CreateCell(57, HSSFCellType.STRING).SetCellValue(LastEndTime);
                row.CreateCell(58, HSSFCellType.STRING).SetCellValue(HostSitu);
                row.CreateCell(59, HSSFCellType.STRING).SetCellValue(Remark);
                rownum++;
                //returnData.Add(myReader["BaStaName"].ToString());
            }

            workbook.Write(context.Response.OutputStream);
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}