﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using ResMangSys.DAL.RepRegistTableAdapters;
using NPOI.HSSF.UserModel;

namespace ResMangSys
{
    /// <summary>
    /// RepRegist 的摘要说明
    /// </summary>
    public class RepRegist : IHttpHandler
    {

        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "application/vnd.ms-excel";
            string filename = HttpUtility.UrlEncode("维修备查登记表.xls");
            context.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename);

            T_RepRegistTableAdapter adapter = new T_RepRegistTableAdapter();
            ResMangSys.DAL.RepRegist.T_RepRegistDataTable RepRegistTable = null;

            string signal = context.Request["signal"];

            switch (signal)
            {
                case "0": RepRegistTable = adapter.GetDataByTimeLocal(context.Request["startime"], context.Request["endtime"], context.Request["arg"]); break;
                case "1": RepRegistTable = adapter.GetDataByTimeBaStaId(context.Request["startime"], context.Request["endtime"], context.Request["arg"]); break;
            }

            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.CreateSheet();

            int rownum = 1;
            HSSFRow rowhead = sheet.CreateRow(0);
            //rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("序号");
            rowhead.CreateCell(0, HSSFCellType.STRING).SetCellValue("归属地");
            rowhead.CreateCell(1, HSSFCellType.STRING).SetCellValue("维修资产名称");
            rowhead.CreateCell(2, HSSFCellType.STRING).SetCellValue("资产编号");
            rowhead.CreateCell(3, HSSFCellType.STRING).SetCellValue("规格型号");
            rowhead.CreateCell(4, HSSFCellType.STRING).SetCellValue("维修数量");
            rowhead.CreateCell(5, HSSFCellType.STRING).SetCellValue("维修具体内容");
            rowhead.CreateCell(6, HSSFCellType.STRING).SetCellValue("基站名称");
            rowhead.CreateCell(7, HSSFCellType.STRING).SetCellValue("实际维修金额");
            rowhead.CreateCell(8, HSSFCellType.STRING).SetCellValue("资产责任人");
            rowhead.CreateCell(9, HSSFCellType.STRING).SetCellValue("提交给财务付款资料日期");
            rowhead.CreateCell(10, HSSFCellType.STRING).SetCellValue("费用分类");
            rowhead.CreateCell(11, HSSFCellType.STRING).SetCellValue("资金属性");
            rowhead.CreateCell(12, HSSFCellType.STRING).SetCellValue("基站编号");

            foreach (var datarow in RepRegistTable)
            {
                HSSFRow row = sheet.CreateRow(rownum);
                string AttrLocal = datarow.IsAttrLocalNull() == true ? "" : datarow.AttrLocal;
                string RepAssName = datarow.IsRepAssNameNull() == true ? "" : datarow.RepAssName;
                string AssId = datarow.IsAssIdNull() == true ? "" : datarow.AssId;
                string SpecModel = datarow.IsSpecModelNull() == true ? "" : datarow.SpecModel;
                string RepCount = datarow.IsRepCountNull() == true ? "" : datarow.RepCount.ToString();
                string RepContent = datarow.IsRepContentNull() == true ? "" : datarow.RepContent;
                string BaStaName = datarow.IsBaStaNameNull() == true ? "" : datarow.BaStaName;
                string ActRepCost = datarow.IsActRepCostNull() == true ? "" : datarow.ActRepCost.ToString();
                string Charge = datarow.IsChargeNull() == true ? "" : datarow.Charge;
                string SubPayDate = datarow.IsSubPayDateNull() == true ? "" : datarow.SubPayDate.ToShortDateString();
                string CostSort = datarow.IsCostSortNull() == true ? "" : datarow.CostSort;
                string MonProp = datarow.IsMonPropNull() == true ? "" : datarow.MonProp;
                string BaStaId = datarow.IsBaStaIdNull() == true ? "" : datarow.BaStaId;
                row.CreateCell(0, HSSFCellType.STRING).SetCellValue(AttrLocal);
                row.CreateCell(1, HSSFCellType.STRING).SetCellValue(RepAssName);
                row.CreateCell(2, HSSFCellType.STRING).SetCellValue(AssId);
                row.CreateCell(3, HSSFCellType.STRING).SetCellValue(SpecModel);
                row.CreateCell(4, HSSFCellType.STRING).SetCellValue(RepCount);
                row.CreateCell(5, HSSFCellType.STRING).SetCellValue(RepContent);
                row.CreateCell(6, HSSFCellType.STRING).SetCellValue(BaStaName);
                row.CreateCell(7, HSSFCellType.STRING).SetCellValue(ActRepCost);
                row.CreateCell(8, HSSFCellType.STRING).SetCellValue(Charge);
                row.CreateCell(9, HSSFCellType.STRING).SetCellValue(SubPayDate);
                row.CreateCell(10, HSSFCellType.STRING).SetCellValue(CostSort);
                row.CreateCell(11, HSSFCellType.STRING).SetCellValue(MonProp);
                row.CreateCell(12, HSSFCellType.STRING).SetCellValue(BaStaId);
                rownum++;
            }

            workbook.Write(context.Response.OutputStream);

        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}