﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
// 下载于www.51aspx.com
namespace ResMangSys
{
    public partial class UsersManager : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                if (Session["id"] != null)
                {
                    if (Session["role"].ToString() != "manager")
                    {
                        Response.Redirect("Default.aspx");
                        return;
                    }
                }
                else
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
            }
            else
            {
                if (Session["id"] == null)
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
                if (Session["role"].ToString() != "manager")
                {
                    Response.Redirect("Default.aspx");
                    return;
                }
            }
        }
        // 下载于www.51aspx.com
        protected void LVUsers_ItemCreated(object sender, ListViewItemEventArgs e)
        {
            if (e.Item.ItemType == ListViewItemType.DataItem)
            {
                DropDownList ddlRole = (DropDownList)e.Item.FindControl("ddlRole");
                if (ddlRole != null)
                {
                    ListViewDataItem lvDataItem = (ListViewDataItem)e.Item;
                    DataRowView rowView = (DataRowView)lvDataItem.DataItem;
                    if (rowView != null)
                    {
                        var userRow = (ResMangSys.DAL.Users.T_UsersRow)rowView.Row;
                        ddlRole.SelectedValue = userRow.Role;
                    }
                }
            }
        }

        protected void LVUsers_ItemInserting(object sender, ListViewInsertEventArgs e)
        {
            DropDownList ddlRole = (DropDownList)e.Item.FindControl("ddlRole");
            e.Values["Role"] = ddlRole.SelectedValue;
        }

        protected void LVUsers_ItemUpdating(object sender, ListViewUpdateEventArgs e)
        {
            DropDownList ddlRole= (DropDownList)LVUsers.Items[e.ItemIndex].FindControl("ddlRole");
            e.NewValues["Role"] = ddlRole.SelectedValue;
        }
    }
}