<%
'****************************************************
' Software name:JieYiCMS
' Web: http://www.jieyicms.com
' Copyright (C) JieYiCMS All Rights Reserved.
'****************************************************

Class Cls_Thumb
  Public IsExpir
  Private Sub Class_Initialize()
  	IsExpir = IsExpired("Persits.Jpeg")
	Response.AddHeader "Content-Type", "text/html; charset=UTF-8"
  End Sub
  Private Sub Class_Terminate()
  End Sub
  
  '为图片添加水印
  Sub AddWaterMark(ByVal sFileName)
	  Dim objFso,FileName
	  On Error Resume Next
	  If IsExpir Then Exit Sub
	  If sFileName <> "" And Not IsNull(sFileName) Then
		  FileName = Server.MapPath(sFileName)
		  Set objFso = server.CreateObject("scripting.filesystemobject")
		  If objFso.FileExists(FileName) Then
		  
			  If JY.SiteDraw_Type = 0 Then'文字水印             
				call AddWordMark (JY.SiteDraw_Text, JY.SiteDraw_Color, JY.SiteDraw_Family, 1, JY.SiteDraw_Size,JY.SiteDraw_Location, sFileName)
			  Else                                               
				call AddPhotoMark (JY.SiteDraw_X, JY.SiteDraw_Y, JY.SiteDraw_Logo, JY.SiteDraw_Diap, JY.SiteDraw_BgColor, JY.SiteDraw_Location, sFileName)
			  End If
		  End If
		  Set objFso = Nothing
	  End If 
	  On Error goto 0
  End Sub
  '为图片添加文字水印
  Sub AddWordMark(ByVal MarkText,ByVal  MarkFontColor, ByVal MarkFontFamily, ByVal MarkFontBond, ByVal MarkFontSize, ByVal MarkPosition, ByVal sFileName)
	  Dim objImage, x, y, Text, TextWidth, FontColor, FontFamily, FondBond, FontSize, OriginalWidth, OriginalHeight
	  On Error Resume Next
	  If IsExpir Then Exit Sub
	  FileName = Server.MapPath(sFileName):Text = Trim(MarkText):FontColor = Replace(MarkFontColor, "#", "&H")
	  FontFamily = MarkFontFamily:FontSize = CInt(MarkFontSize)
	  If Text = "" Then Exit Sub
	  If MarkFontBond = "1" Then
		  FondBond = True
	  Else
		  FondBond = False
	  End If
	  
		  Set objImage = Server.CreateObject("Persits.Jpeg")
			  objImage.Open FileName
			  objImage.Canvas.Font.Color = FontColor
			  objImage.Canvas.Font.Family = FontFamily
			  objImage.Canvas.Font.Bold = FondBond
			  objImage.Canvas.Font.size = FontSize
			  On Error Resume Next
			  TextWidth = objImage.Canvas.GetTextExtent(Text)  
			  If err Then err.clear:TextWidth =200
			  If objImage.OriginalWidth < TextWidth Or objImage.OriginalHeight < FontSize Then    
				  Exit Sub
			  End If
			  Call GetPostion (MarkPosition, x, y, objImage.OriginalWidth, objImage.OriginalHeight, TextWidth, FontSize)
			  With objImage.Canvas
				.Print x, y, Text
			  End With
			  objImage.Quality=80 
			  objImage.Save FileName
	  Set objImage = Nothing
	  On Error goto 0
  End Sub

  '为图片添加图片水印
  Sub AddPhotoMark(ByVal MarkWidth, ByVal MarkHeight, ByVal MarkPicture, ByVal MarkOpacity, ByVal MarkTranspColor, ByVal MarkPosition, ByVal sFileName)
	  Dim objImage, objMark, x, y, OriginalWidth, OriginalHeight, Position
	  On Error Resume Next
	  If IsExpir Then Exit Sub
	  FileName = Server.MapPath(sFileName)
	  MarkWidth = ChkClng(MarkWidth)
	  MarkHeight = ChkClng(MarkHeight)
	  If IsNul(MarkPicture) then  MarkPicture=""
	  If IsNul(MarkOpacity) Then
		  MarkOpacity = 1
	  Else
		  MarkOpacity = CSng(MarkOpacity)
	  End If
	  If MarkTranspColor <> "" Then MarkTranspColor = Replace(MarkTranspColor, "#", "&H")
			  Set objImage = Server.CreateObject("Persits.Jpeg")
			  Set objMark = Server.CreateObject("Persits.Jpeg")
			  objImage.Open FileName
			  If objImage.OriginalWidth < MarkWidth Or objImage.OriginalHeight < MarkHeight Then 
				  Exit Sub
			  End If
			  objMark.Open Server.MapPath(MarkPicture)
			  Call GetPostion (MarkPosition, x, y, objImage.OriginalWidth, objImage.OriginalHeight, MarkWidth, MarkHeight)
			  If MarkTranspColor <> "" Then
				  objImage.Canvas.DrawImage x, y, objMark, MarkOpacity, MarkTranspColor
			  Else
				  objImage.DrawImage x, y, objMark, MarkOpacity
			  End If
			  objImage.Quality=80  
			  objImage.Save FileName
			  If MarkTranspColor <> "" Then
				  MarkTranspColor = "&H" & Mid(MarkTranspColor, 7) & Mid(MarkTranspColor, 5, 2) & Mid(MarkTranspColor, 3, 2)
				  objImage.AddWaterMark Server.MapPath(MarkPicture), Position, CSng(MarkOpacity), CLng(MarkTranspColor)
			  Else
				  objImage.AddWaterMark Server.MapPath(MarkPicture), Position, CSng(MarkOpacity)
			  End If
			  objImage.SaveImage 0, objImage.Imageformat, FileName
	  Set objImage = Nothing
	  Set objMark = Nothing
	  On Error goto 0
  End Sub
  
  
  Sub GetPostion(ByVal MarkPosition, ByRef x, ByRef y, ByVal ImageWidth, ByVal ImageHeight, ByVal MarkWidth, ByVal MarkHeight)
  	  On Error Resume Next
  	  MarkPosition = ChkClng(MarkPosition)
	  Select Case MarkPosition
		  Case 0
			  x = 2
			  y = 2
		  Case 1
			  x = 2
			  y = Int(ImageHeight - MarkHeight - 2)
		  Case 2
			  x = Int((ImageWidth - MarkWidth) / 2)
			  y = Int((ImageHeight - MarkHeight) / 2)
		  Case 3
			  x = Int(ImageWidth - MarkWidth - 2)
			  y = 2
		  Case 4
			  x = Int(ImageWidth - MarkWidth - 2)
			  y = Int(ImageHeight - MarkHeight - 2)
	  End Select
	  On Error goto 0
  End Sub


  '由原图片生成指定宽度和高度的缩略图
  Sub CreateThumbPhoto(ByVal sFileName, ByVal Width, ByVal Height,ByVal GoldenPoint, ByVal Rate, ByVal sThumbFileName)
	  On Error Resume Next
	  Dim strSql, RsSetting, objImage, iWidth, iHeight, strFileExt,FsoObj,FileName,ThumbFileName
	  If IsExpir Then Exit Sub
	  If IsNul(sFileName) Or  IsNul(sThumbFileName) Then Exit Sub
	  If not IsNumeric(Rate) Then Rate=0  
	  Width = ChkClng(Width):Height = ChkClng(Height):Rate = CSng(Rate):GoldenPoint=ChkClng(GoldenPoint)
  
	  if Width = 0 then Exit Sub'宽度为0 直接退出
	  FileName = Server.MapPath(sFileName)
	  ThumbFileName = Server.MapPath(sThumbFileName)
	   '------检查原图是否存在---
	   Set FsoObj = server.CreateObject("scripting.filesystemobject")
	   If Not FsoObj.FileExists(FileName) Then Exit Sub
	   Set FsoObj=Nothing

		Set objImage = Server.CreateObject("Persits.Jpeg")
		objImage.Open FileName
		If Rate = 0 And (Width <> 0 Or Height <> 0) Then
			If Width < objImage.OriginalWidth And Height < objImage.OriginalHeight And Height<>0 Then
				Dim qjazhro_h,qjazhro_w,qjazhro_t,qjazhro_hj,qjazhro,mznvhai 
				qjazhro=round((Width/Height),3)'给定的宽高比
				mznvhai=round((objImage.OriginalWidth/objImage.OriginalHeight),3)'实际的宽高比
				If qjazhro < mznvhai Then'给定的宽高比 小于 实际的宽高比
				objImage.Height = Height'以给定的高为基准
				objImage.Width = round((objImage.OriginalWidth / objImage.OriginalHeight * Height),3)
				qjazhro_w=round(((objImage.Width-Width)/2),3)
				qjazhro_t=Width+qjazhro_w
				objImage.crop qjazhro_w,0,qjazhro_t,Height
			   ElseIf qjazhro > mznvhai Then '给定的宽高比 大于 实际的宽高比
				objImage.Width = Width'以给定的宽为基准
				objImage.Height = round((objImage.OriginalHeight / objImage.OriginalWidth * Width),3)
				qjazhro_h=objImage.Height-Height
				qjazhro_hj=qjazhro_h*GoldenPoint  'GoldenPoint为黄金分割点，你可以按自己的要求修改这个值
				qjazhro_t=Height+qjazhro_hj
				objImage.crop 0,qjazhro_hj,Width,qjazhro_t
			   ElseIf qjazhro = mznvhai Then '给定的宽高比 等于 实际的宽高比
				objImage.Width = Width
				objImage.Height = Height
				End If
			End If
			If Height=0 Then      '当高度为0时,自适应高度
			 Height=Width * objImage.OriginalHeight / objImage.OriginalWidth
			 objImage.Height=Height
			 objImage.Width=Width
			End If
		ElseIf Rate <> 0 Then
			objImage.Width = objImage.OriginalWidth * Rate
			objImage.Height = objImage.OriginalHeight * Rate
		End If
		objImage.Interpolation=0
		objImage.Quality=80  
		objImage.Save ThumbFileName
		Set objImage = Nothing
	  If Err.Number <> 0 Then Err.Clear
	  On Error goto 0
  End Sub
  
  
  Public Function IsExpired(ByVal strobj)
	  On Error Resume Next
	  If Err.Number <> 0 Then Err.Clear
	  IsExpired = True
	  Dim xTestObj:Set xTestObj = Server.CreateObject(strobj)
		  If xTestObj.Expires > Now Then
			  IsExpired = False
		  End If
	  Set xTestObj = Nothing
	  If Err.Number <> 0 Then Err.Clear:IsExpired = True
	  On Error goto 0
  End Function

End Class
%> 
