<?php
/* Copyright (c) MetaClass, 2003-2012

Distrubuted and licensed under under the terms of the GNU Affero General Public License
version 3, or (at your option) any later version.

This program is distributed WITHOUT ANY WARRANTY; without even the implied warranty 
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	
See the License, http://www.gnu.org/licenses/agpl.txt */


/** Authenticator that does not do authentication. 
* Allows everybody is allowed to use the application without
* login. All users have all credentials.
*
* This class also defines the interface for PntAuthenticator
* @package pnt
*/
class PntNoAuthenticator {
	
	function __construct($baseUrl) {
		$this->baseUrl = $baseUrl;
	}
	
	/** @return wheather the user is authenticated, or true if
	* authentication is not required (default).
	* @param Array $requestData like $_REQUEST
	* @precondition session has been started
	*/
	function isAuthenticated($requestData) {
		return true;
	}
	
	/** Authenticate the user. If authenticated, register the user session
	* @param String $username The username  
	* @param String $password The password
	* @return true if the user could be authenticated.
	*/
	function authenticate($username, $password) {
		trigger_error('authenticate method should have been implemented by a subclass', E_USER_ERROR);
	}

	/** Default implementation allways returns true.
	* @param string $code Code that identifies the credential, 
	*	or null if only a valid user is required
	* @return boolean Wheather the user has the specified credential 
	*/
	function userHasCredential($code) {
		return true;
	}
	
	function logOut() {
		//ignore
	}

}
?>