<?php

/*********************************************************************************
 * KangPHP 2.0 国产PHP开发框架  - MVC分层处理器
 *-------------------------------------------------------------------------------
 * 版权所有: CopyRight By www.kangphp.com
 * 您可以自由使用该源码，但是在使用过程中，请保留作者信息。尊重他人劳动成果就是尊重自己
 * 声明: 使用本框架开发的一切软件版权最终归软件开发者所有，本框架仅仅提供底层架构
 *-------------------------------------------------------------------------------
 * $Author:Andre Miller
 * $Dtime:2012-09-14
***********************************************************************************/

class Class_Load
{
	//自动载系统模块类库
	public function Dir_Load($Class_Root, $Kang_Class)
	{
		$File=__KANGPATH__ . $Class_Root . $Kang_Class . '.class.php';
		if(!file_exists($File))
		{
			Error::debug('加载文件'.$File.'失败！');
		}
		else 
		{	
			require_once($File);
		}
	}

	// 加载核心类库
	public function System_Load($Class_Root, $Kang_Class)
	{
		foreach ($Kang_Class as $vo) {
			
			$CoreFile=__KANGDIR__ . $Class_Root . '/' . $vo . '.class.php';
			if(!file_exists($CoreFile))
			{
			   Error::debug('加载核心类'.$CoreFile.'失败！');
			}
			else {
				require_once($CoreFile);
			}
		}
	}
}

class KangPHP
{
	//目录检测类成员方法
	public function Kp_CheckDir($Dir_Root)
	{
		if (!file_exists($Dir_Root))
		 {
			mkdir($Dir_Root);
		}
	}

	public function checkmod($str)
	{
		//验证只有英文A-Z a-z 以及数字可以命名
		return preg_match('/^[A-Za-z0-9_]+$/', $str);

	}

	public function Kang_Apps($Class_Root = __M__ , $Kang_Class = 'commonMod')
	{
		//创建框架必有目录
		self::Kp_CheckDir('public');
		self::Kp_CheckDir('upload');
		self::Kp_CheckDir('v');
		self::Kp_Checkdir('cache');

		//定义 __PUBLIC__、__URL__常量
		$baseurl='http://'.$_SERVER['SERVER_NAME'].$_SERVER["REQUEST_URI"];
		$public='http://'.$_SERVER['SERVER_NAME'].'/'.$urlpath['1'].'/public/';
		$urlpath=explode('/',$baserurl['path']);
		define('__URL__',$baseurl );
		$baserurl= parse_url($baseurl);
		define('__PUBLIC__', $public);
		
		//如果模块为空,调用默认indexMod.class.php
		$Kang_mod = !empty($_GET['m']) ? $_GET['m'] : 'index';

		//如果模块方法为空,就调用默认index方法
		$Kang_action = !empty($_GET['a']) ? $_GET['a'] : 'index';

		self::checkmod($Kang_mod); self::checkmod($Kang_action); //过滤入口

		//设定控制器文件名
		$ctrlname = $Kang_mod . 'Mod';
		Class_Load::Dir_Load($Class_Root, $Kang_Class);
		$kang_ctrl_file = __KANGPATH__ . __M__ . $Kang_mod . 'Mod.class.php';
		if (is_file($kang_ctrl_file)) 
		{
			require_once $kang_ctrl_file;

			//初始化控制器
			$controller = new $ctrlname();
		} else 
		{
			Error::debug('模块' . $_GET['m'] . '不存在');
		}

		if (method_exists($ctrlname, $Kang_action))
		 {
			$controller->$Kang_action();
		} else
		 {	
			Error::debug('方法' . $_GET['a'] . '不存在');
		}	
	}
}

$KP_App = new Class_Load();
$KP_App = new KangPHP();