<?php

/*********************************************************************************
 * KangPHP 2.0 国产PHP开发框架  - 全局控制器
 *-------------------------------------------------------------------------------
 * 版权所有: CopyRight By www.kangphp.com
 * 您可以自由使用该源码，但是在使用过程中，请保留作者信息。尊重他人劳动成果就是尊重自己
 * 声明: 使用本框架开发的一切软件版权最终归软件开发者所有，本框架仅仅提供底层架构
 *-------------------------------------------------------------------------------
 * $Author:Andre Miller
 * $Dtime:2012-09-14
 ***********************************************************************************/

Class common
{
    
    //模块间互相调用
    public function Mod($Mod)
    {
        Class_Load::Dir_Load(__M__, $Mod);
        return $KangPHP = new $Mod();
        
    }
    
    /*
     *@ 功能：用来过滤字符串和字符串数组，防止被挂马和sql注入
     *@ 参数$data，待过滤的字符串或字符串数组，
     *@ $force为true，忽略get_magic_quotes_gpc
     */
    public function in($data, $force = false)
    {
        if (is_string($data)) {
            $data = trim(htmlspecialchars($data)); //防止被挂马，跨站攻击
            if (($force == true) || (!get_magic_quotes_gpc())) {
                $data = addslashes($data); //防止sql注入
            }
            return $data;
        } else if (is_array($data)) //如果是数组采用递归过滤
            {
            foreach ($data as $key => $value) {
                $data[$key] = in($value, $force);
            }
            return $data;
        } else {
            return $data;
        }
    }
    
    //用来还原字符串和字符串数组，把已经转义的字符还原回来
    public function out($data)
    {
        if (is_string($data)) {
            return $data = stripslashes($data);
        } else if (is_array($data)) //如果是数组采用递归过滤
            {
            foreach ($data as $key => $value) {
                $data[$key] = out($value);
            }
            return $data;
        } else {
            return $data;
        }
    }
    
    //文本输入
    public function text_in($str)
    {
        $str = strip_tags($str, '<br>');
        $str = str_replace(" ", "&nbsp;", $str);
        $str = str_replace("\n", "<br>", $str);
        if (!get_magic_quotes_gpc()) {
            $str = addslashes($str);
        }
        return $str;
    }
    
    //文本输出
    public function text_out($str)
    {
        $str = str_replace("&nbsp;", " ", $str);
        $str = str_replace("<br>", "\n", $str);
        $str = stripslashes($str);
        return $str;
    }
    
    //html代码输入
    public function html($str)
    {
        $search  = array(
            "'<script[^>]*?>.*?</script>'si", // 去掉 javascript
            "'<iframe[^>]*?>.*?</iframe>'si" // 去掉iframe
        );
        $replace = array(
            "",
            ""
        );
        $str     = @preg_replace($search, $replace, $str);
        $str     = htmlspecialchars($str);
        if (!get_magic_quotes_gpc()) {
            $str = addslashes($str);
        }
        return $str;
    }
    
    //html代码输出
    public function html_out($str)
    {
        if (function_exists('htmlspecialchars_decode'))
            $str = htmlspecialchars_decode($str);
        else
            $str = html_entity_decode($str);
        
        $str = stripslashes($str);
        return $str;
    }
    
    //中文字符串截取
    public function msubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = true)
    {
        switch ($charset) {
            case 'utf-8':
                $char_len = 3;
                break;
            case 'UTF8':
                $char_len = 3;
                break;
            default:
                $char_len = 2;
        }
        //小于指定长度，直接返回
        if (strlen($str) <= ($length * $char_len)) {
            return $str;
        }
        if (function_exists("mb_substr")) {
            $slice = mb_substr($str, $start, $length, $charset);
        } else if (function_exists('iconv_substr')) {
            $slice = iconv_substr($str, $start, $length, $charset);
        } else {
            $re['utf-8']  = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
            $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
            $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
            $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
            preg_match_all($re[$charset], $str, $match);
            $slice = join("", array_slice($match[0], $start, $length));
        }
        if ($suffix)
            return $slice . "…";
        return $slice;
    }
    
    //检查是否是正确的邮箱地址，是则返回true，否则返回false
    public function is_email($user_email)
    {
        $chars = "/^([a-z0-9+_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,6}\$/i";
        if (strpos($user_email, '@') !== false && strpos($user_email, '.') !== false) {
            if (preg_match($chars, $user_email)) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }  
    
    //如有需要自己定义私有方法 调用就按照 common::方法名(参数)
}