<?php

/*********************************************************************************
 * KangPHP 2.0 国产PHP开发框架  - 模版类
 *-------------------------------------------------------------------------------
 * 版权所有: CopyRight By www.kangphp.com
 * 您可以自由使用该源码，但是在使用过程中，请保留作者信息。尊重他人劳动成果就是尊重自己
 * 声明: 使用本框架开发的一切软件版权最终归软件开发者所有，本框架仅仅提供底层架构
 *-------------------------------------------------------------------------------
 * $Author:Andre Miller
 * $Dtime:2012-09-24
 ***********************************************************************************/

class kp_tpl
{
    public $tpl_dir;
    
    // 模板文件所在目录 注意以斜杠结束
    public $tpl_ext;
    
    // 模板文件扩展名 建议为PHP文件 这样在Dreamweaver中PHP代码才会有高亮效果
    public $cache_dir;
    
    // 模板编译后的缓存目录 一样以斜杠结束 无则自动创建
    public $cache_time;
    
    /*@  编译后模板的缓存时间（单位：秒）
     * @ 0为马上过期 即每次都重新编译
     * @ -1为永不过期 网站上线后建议设置为-1
     * @ 自定义的正则替换
     */
    public $my_rep = array('~(\.\./)+static~' => '/static', '~__UP__~' => '/static/upload');
    
    private $kp_rep = array( 
    
    /*   解析变量/常量 标签
     * @ {$name}  => <?php echo $name; ?>
     */ 
    
    '~\{(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\}~' => '<?php echo $1 ?>', 
     
     /*   解析数组输出标签
     * @ {$arr.key} => <?php echo $array[key];?>
     */ 
    
    '~\{(\$[a-z0-9_]+)\.([a-z0-9_]+)\}~i' => '<?php echo $1[\'$2\'] ?>', 
     
     /*  解析多维数组输出标签
     * @ {$array.key.key2} => <?php  echo $array[key][key2]; ?>
     */ 
    
    '~\{(\$[a-z0-9_]+)\.([a-z0-9_]+)\.([a-z0-9_]+)\}~i' => '<?php echo $1[\'$2\'][\'$3\'] ?>', // {$arr.key.key2}

    // {:strip_tags($a)}
        '~\{:(.+?)\}~' => '<?php echo $1 ?>', 
    
    //{~var_dump($a)}
        '~\{\~(.+?)\}~' => '<?php $1 ?>', 
    
    /* 解析loop 循环标签
     * @ {loop $arr $vo}       => <?php $n=1; if (is_array($arr) foreach($arr as $vo){ ?>
     * @ {loop $arr $key $vo}	=>	<?php $n=1; if (is_array($array) foreach($arr as $key => $vo){ ?>
     * @ {/loop}				=>	<?php $n++;}unset($n) ?>
     */
    '~\{loop\s+(\S+)\s+(\S+)\}~'=>'<?php \$n=1;if(is_array(\\1)) foreach(\\1 AS \\2) { ?>',
    '~\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}~'=>'<?php \$n=1; if(is_array(\\1)) foreach(\\1 AS \\2 => \\3) { ?>',
    '~\{\/loop\}~'=>'<?php \$n++;}unset(\$n); ?>',
        
    /* 解析for 标签
     * @ {for $i=0;$i<10;$i++}	=>	<?php for($i=0;$i<10;$i++) { ?>
     * @ {/for}					=>	<?php } ?>
     */
    '~\{for\s+(.+?)\}~'=>'<?php for(\\1) { ?>',
    '~\{\/for\}~'=>'<?php } ?>',
    
     //解析 echo
    '~<\?=\s*~' => '<?php echo ', 
    
    /* 解析 日期函数
     * @ {date('Y-m-d H:i:s')}	=>	<?php echo date('Y-m-d H:i:s');?>
     * @ {$date('Y-m-d H:i:s')}	=>	<?php echo $date('Y-m-d H:i:s');?> 
     */
     '~\{([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}~'=>'<?php echo \\1;?>',
     '~\{(\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff:]*\(([^{}]*)\))\}~'=>'<?php echo \\1;?>',
    
    //解析include
    '~<\?php\s+(include_once|require_once|include|require)\s*\(\s*(.+?)\s*\)\s*;?\s*\?>~i' => '<?php include \$this->_include($2, __FILE__) ?>',
    
    //解析KangPHP中 __ROOT__、__PUBLIC__、__URL__ 路径常量
    '~\__ROOT__~'=>'<?php echo __KANGPATH__;?>',
    '~\__URL__~'=>'<?php echo __URL__;?> ',
    '~\__PUBLIC__~'=>'<?php echo __PUBLIC__;?>',
    

     /*    if else if 判断标签
     *@    {if $name==1}        =>    <?php if ($name==1){ ?>
     *@    {elseif $name==2}    =>    <?php } elseif ($name==2){ ?>
     *@    {else}                =>    <?php } else { ?>
     *@    {/if}                =>    <?php } ?>
     */ '~\{if\s+(.+?)\}~' => '<?php if(\\1) { ?>', '~\{else\}~' => '<?php } else { ?>', '~\{elseif\s+(.+?)\}~' => '<?php } elseif (\\1) { ?>', '~\{\/if\}~' => '<?php } ?>');
    
    // 用于存储模板变量
    public $data = array();
    
    public function __construct($cfg = NULL)
    {
        if ($cfg) {
            $this->config($cfg);
        }
    }
    public function config($cfg)
    {
        if (is_string($cfg)) { $cfg = require $cfg;  }
        if (isset($cfg['tpl_dir']))   { $this->tpl_dir = $cfg['tpl_dir'];}
        if (isset($cfg['tpl_ext']))   { $this->tpl_ext = $cfg['tpl_ext'];}
        if (isset($cfg['cache_dir'])) { $this->cache_dir = $cfg['cache_dir'];}
        if (isset($cfg['cache_time'])){ $this->cache_time = $cfg['cache_time'];}
        if (isset($cfg['my_rep']))    { $this->my_rep = $cfg['my_rep'];}
        if (isset($cfg['data']))      { $this->data = $cfg['data'];}
    }
    
    // 赋值
    public function assign($name, $value = NULL)
    {
        if (is_array($name)) {
            foreach ($name as $k => $v) {
                $this->data[$k] = $v;
            }
        } else {
            $this->data[$name] =& $value;
        }
    }
    
    // 输出页面
    public function display($tpl_file)
    {
        $_cache_path = $this->cache_path($tpl_file);
        if (!$this->is_cached($_cache_path)) {
            $this->compile($this->tpl_path($tpl_file), $_cache_path);
        }
        unset($tpl_file);
        extract($this->data); // 如果data里有个_cache_path...
        include $_cache_path;
    }
    
    // 返回页面
    public function fetch($tpl_file)
    {
        ob_start();
        ob_implicit_flush(0);
        $this->display($tpl_file);
        return ob_get_clean();
    }
    
    // 获取模板文件路径
    public function tpl_path($tpl_file)
    {
        return $this->tpl_dir . $tpl_file . $this->tpl_ext;
    }
    
    // 获取模板缓存路径
    private function cache_path($tpl_file)
    {
        return $this->cache_dir . $tpl_file . $this->tpl_ext;
    }
    
    // 模板缓存是否有效
    public  function is_cached($cache_path)
    {
        if (!file_exists($cache_path)) {
            return false;
        }
        if ($this->cache_time < 0) {
            return true;
        }
        $cache_time = filemtime($cache_path);
        if (time() - $cache_time > $this->cache_time) {
            return false;
        }
        return true;
    }
    
    // 编译模板
    public function compile($tpl_path, $cache_path)
    {
        $tpl = @file_get_contents($tpl_path);
        if ($tpl === FALSE) {
            Error::debug("模板" . $tpl_path . "不存在");
        }
        
        $tmp   = array_merge($this->kp_rep, $this->my_rep);
        $cache = preg_replace(array_keys($tmp), $tmp, $tpl);
        
        @mkdir(dirname($cache_path), 0777, true);
        
        $tmp = @file_put_contents($cache_path, $cache, LOCK_EX);
        if ($tmp === FALSE) {
            Error::debug("编译后的模板文件" . $cache_path . "无法写入");
        }
    }
    
    // 页面有include时用到
    public function _include($inc_file, $cache_path)
    {
        $inc_path = dirname($cache_path) . '/' . $inc_file;
        if (!$this->is_cached($inc_path)) {
            $tpl_path = str_replace(realpath($this->cache_dir), realpath($this->tpl_dir), $inc_path);
            $this->compile($tpl_path, $inc_path);
        }
        return $inc_path;
    }
    
    public function Clean($dir)
    {
        $cachedir = opendir($dir);
        
        while ($filea = @readdir($cachedir)) {
            if ($filea != "." && $filea != ".." && $filea != "Thumbs.db") {
                //删除编译缓存
                unlink($dir . '/' . $filea);      
            }  
        }
        closedir($cachedir);
    }
}