<?php

/*********************************************************************************
 * KangPHP 2.0 国产PHP开发框架  - 上传处理
 *-------------------------------------------------------------------------------
 * 版权所有: CopyRight By www.kangphp.com
 * 您可以自由使用该源码，但是在使用过程中，请保留作者信息。尊重他人劳动成果就是尊重自己
 * 声明: 使用本框架开发的一切软件版权最终归软件开发者所有，本框架仅仅提供底层架构
 *-------------------------------------------------------------------------------
 * $Author:Andre Miller
 * $Dtime:2012-09-26
 ***********************************************************************************/

/*
类名      FileUpload
参数有
$fileName    上传文件的表单name值
$dir        上传文件保存的目录位置
$randBoolean    一个布尔值，true为文件本身的名称，false为随机名称
$type        允许文件上传类型

*/
error_reporting(E_ALL & ~E_NOTICE); //屏蔽notice错误

class FileUpload
{
    public $fileName; //保存上传图像的超全局数组
    public $dir; //用户上传的指定目录
    public $randBoolean; //是否要随机名，false为是，true为否
    public $type; //限制用户上传的文件类型
    public $fileInfo; //保存用户上传文件的信息
    public $errorMsg; //保存错误信息
    public $errorBoolean = false; //这个临时用来判断是否有错误信息出现
    public $file_hou; //保存文件的后缀
    public $maxsize; //文件的允许最大值
    public $uploadName; //文件上传后的名称
    
    function __construct($fileName, $dir = 'uploads', $randBoolean, $maxsize = 20000, $type = array("txt", "jpg", "png", "gif", "wbmp", "rar"))
    {
        $this->fileName = $_FILES[$fileName];
        $this->getFileInfo();
        $this->dir         = $dir;
        $this->randBoolean = $randBoolean;
        $this->type        = $type;
        $this->maxsize     = $maxsize;
    }
    
    //文件上传函数
    public function uploadFile()
    {	
    	//检测Upload目录是否存在
    	KangPHP::Kp_CheckDir('upload');
    	
        if (is_array($this->fileInfo["name"])) {
            for ($i = 0; $i < count($this->fileInfo["name"]); $i++) {
                if (!$this->checkType($this->fileInfo["name"][$i])) {
                    echo $this->getError();
                    continue;
                }
                $this->checkMaxSize($this->fileInfo["size"][$i], $this->fileInfo["name"][$i]);
                if ($this->errorBoolean) {
                    echo $this->getError();
                    continue;
                }
                $this->setErrorMsg($this->fileInfo["error"][$i], $this->fileInfo["name"][$i]);
                if ($this->errorBoolean) {
                    echo $this->getError();
                    continue;
                } else {
                    if (is_uploaded_file($this->fileInfo["tmp_name"][$i])) {
                        if (!$this->randBoolean) {
                            $this->uploadName[$i] = $this->dir . "/" . time() . $i . "." . $this->file_hou;
                        } else {
                            $this->uploadName[$i] = $this->dir . "/" . $this->fileInfo["name"][$i];
                        }
                        
                        if (move_uploaded_file($this->fileInfo["tmp_name"][$i], $this->uploadName[$i])) {
                        } else {
                        }
                    } else {
                    }
                }
            }
        } else {
            if (!$this->checkType($this->fileInfo["name"])) {
                echo $this->getError();
                exit();
            }
            $this->checkMaxSize($this->fileInfo["size"], $this->fileInfo["name"]);
            if ($this->errorBoolean) {
                echo $this->getError();
                exit();
            }
            $this->setErrorMsg($this->fileInfo["error"], $this->fileInfo["name"]);
            if ($this->errorBoolean) {
                echo $this->getError();
                exit();
            } else {
                if (is_uploaded_file($this->fileInfo["tmp_name"])) {
                    $this->uploadName = $this->getPath();

                }
            }
        }
    }
    //这里返回上传文件后文件的名称
    public function getUploadName()
    {
        return $this->uploadName;
    }
    //这个函数是得到上传错误信息
    public function getError()
    {
        return $this->errorMsg;
    }
    
    //得到上传文件的信息
    function getFileInfo()
    {
        $this->fileInfo["name"]     = $this->fileName["name"];
        $this->fileInfo["tmp_name"] = $this->fileName["tmp_name"];
        $this->fileInfo["type"]     = $this->fileName["type"];
        $this->fileInfo["error"]    = $this->fileName["error"];
        $this->fileInfo["size"]     = $this->fileName["size"];
    }
    
    //检查文件是不是符合上传类型
    function checkType($name)
    {
        $arrType        = explode(".", $name);
        $type           = strtolower($arrType[count($arrType) - 1]);
        $this->file_hou = $type;
        if (!in_array($type, $this->type)) {
            $this->setErrorMsg(-1, $name);
            return false;
        }
        return true;
    }
    //检测最大值
    function checkMaxSize($filesize, $name)
    {
        if ($size > $this->maxsize) {
            $this->setErrorMsg(-2, $name);
        }
    }
    function setErrorMsg($errorNum, $fileName)
    {
       
       // Error::debug("您上传的文件:<b>".$fileName."</b><font color=red> 出错</font>");
       
    }
	
    
    //得到文件的名称
    function getFileName()
    {
        if ($this->randBoolean) {
            return $this->fileInfo["name"];
        } else {
            return time() . "." . $this->file_hou;
        }
    }
    //得到上传位置和名称
    function getPath()
    {
        $this->checkDir();
        $name = $this->getFileName();
        return $this->dir . "/" . $name;
    }
}