<?php

/************************************************
 *
 * 控制器逻辑层 (C)
 * @param Object $DB				数据库对象
 * @param Array	 $DBConfig			链接配置
 * @param Array $AirModel		模型对象集
 * @param Object $AirTemplates	模板对象
 * @param Array $EchoData			调试数据
 *
 */
class AirController {

	public $DB;
	public $DBConfig;				// 控制器调用Mysql的链接配置
	public $AirModel;			// 控制器关联的数据模型对象集
	public $AirClass;			// 控制器关联的类对象集
	public $AirTemplates;		// 控制器关联的模板对象
	public $EchoData = array();		// 调试数据

	function AirController()
	{
		global $Config;
		$this -> DBConfig = $Config;

		$this -> DB = new AirMysql();
		$this -> AirTemplates = new AirTemplate();
	     
    }
     protected function assign($name, $value)
    {
        return $this->AirTemplates->assign($name, $value);
    }
    //模板输出
    protected  function display($tpl='')
    {    
        return $this->AirTemplates->display($tpl);    
    }

	/**
	 * 设置数据库配置
	 * @param Array $Config	链接配置
	 */
	function _DBSet($_Config = NULL)
	{
		global $Config;
		$_Config = ($_Config == NULL) ? $Config : $_Config;
		foreach ($Config as $key=>$val)
			(empty($_Config[$key]) && $_Config[$key] = $val);
		$this -> DBConfig = $_Config;
	}

	/**
	 * 模板赋值
	 * @param string $name	名称
	 * @param string $value	值
	 */
	public function __set($name, $value = NULL)
	{
		$this -> AirTemplates -> TemplateValue[$name] = $value;
	}


	/**
	 * 加载自定义类文件
	 * @param	string $file			文件名
	 * @param	string $ClassName		类名(可选,默认为文件名)
	 * @return	Object $ClassName()		类对象
	 */
	public function C($file, $ClassName = NULL) 
	{
		$file = str_replace(_PathTag, DIRECTORY_SEPARATOR, $file);
		$ClassName = ($ClassName == NULL) ? $file : $ClassName;
		$file = _Class . $file . '.php';
		if(is_file($file)) 
		{
			include_once($file);
			if(!class_exists($ClassName))
				Air::AirMsg($ClassName . ' 类对象不存在');

			if(!isset($this -> AirClass[$ClassName]))						// 不存在类对象
				$this -> AirClass[$ClassName] = new $ClassName();
			Return $this -> AirClass[$ClassName];
		}
		
		Air::AirMsg($file . ' 类文件不存在');
	}

	/**
	 * 加载模型文件
	 * @param	string $file			文件名
	 * @param	string $ClassName		模型名(可选,默认为文件名)
	 * @return	Object $ClassName()		模型对象
	 */
	public function M($file, $ClassName = NULL) 
	{
		$file = str_replace(_PathTag, DIRECTORY_SEPARATOR, $file);
		$ClassName = ($ClassName == NULL) ? $file : $ClassName;
		$file = _Model . $file . '.php';
		if(is_file($file)) 
		{
			include_once($file);
			if(!class_exists($ClassName))
				Air::AirMsg($ClassName . ' 模型对象不存在');
			
			$this -> DBConfig['ModelTag'] = $ModelTag = $ClassName . '_' . $this -> DBConfig['ConnectTag'];		// 模型标识
			if(!isset($this -> AirModel[$ModelTag]))															// 不存在模型
			{
				$this -> AirModel[$ModelTag] = new $ClassName();
				if(!isset($this -> DB -> DBS[$ModelTag])) $this -> DB -> DBConnect($this -> DBConfig);	// 没连接就进行数据库连接
				$this -> AirModel[$ModelTag] -> MysqlConnect = $this -> DB -> DBS[$ModelTag];		// 模型使用的数据库连接
			}
			Return $this -> AirModel[$ModelTag];
		}

		Air::AirMsg($file . ' 模型文件不存在');
	}

	/**
	 * 获得相关文件数据(模板目录)
	 * @param	string $file	文件名
	 * @return	string 			数据
	 */
	public function F($file) 
	{
		$file = str_replace(_PathTag, DIRECTORY_SEPARATOR, $file);
		$file = _View . $file . '.php';
		if(is_file($file)) 
			Return file_get_contents($file);

		Air::AirMsg($file . ' 数据文件不存在');
	}
}

?>
