<?php
/**
 +-------------------------
 * 项目控制器类库基类
 +-------------------------
 */
class AppController extends base
{
	protected $components = array();
	protected $models     = array();
	private static $template   = null;
	
	
	public function __construct()
	{
		//自动加载模块
		$this->loadModel();

		//加载模板引擎
		$this->instaceTemplate();
		
		//自动执行 init 事件
		if(method_exists($this, "init")) {
			$this->init();
		}
	}
	

	/**
	 * 加载模板引擎
	 */
	private function instaceTemplate()
	{
		if(!self::$template) {
			$class_file = conf('root').'/core/template.class.php';
			require($class_file);
			self::$template = new Template();
		}
	}


	/**
	 * 自动加载模块
	 */
	protected function loadModel()
	{
		if($this->models) {
			foreach($this->models as $item) {
				$this->models[$item] = & M($item);
			}
		}
	}
	
	/**
	 * 调用自动加载的模块
	 */
	public function M($modelName) {
		return isset($this->models[$modelName])? $this->models[$modelName] : false;
	}
	
	
	/**
	 * 输出模板
	 */
	protected function display($file_name, $mode="")
	{
		self::$template->display($file_name, $mode);
	}
	
	/**
	 * 设置模板变量
	 * $key  string/array  模板变量名称，或变量哈希表
	 */
	protected function assign($key, $value='')
	{
		self::$template->assign($key, $value);
	}

	
	/**
	 * 进行控制器跳转
	 * $url   跳转到页面
	 * $time  跳转延时秒数
	 */
	protected function redirect($url, $time=0)
	{
		echo '<html><head><title></title><meta http-equiv="refresh" content="'.$time.'; url='.$url.'" /></head><body></body></html>';
		exit;
	}

}
?>
