<?php
/**
 +-------------------------
 * 项目应用程序类库
 +-------------------------
 */
class application
{
	protected $controller = null;
	protected $actioner   = null;
	protected $dir        = null;
	/**
	+-----------------
	* 构造函数
	+-----------------
	*/
	public function __construct() {
		if(conf('session_start')) session_start();

		$this->getControllerName();
		$this->getActionerName();
		$this->getDirName();
		$this->loadConfigure();
		$this->loadCommon();
		$this->mkdirs();
	}


	/** 获取控制器名称 */
	protected function getControllerName() {
		$_key = conf('controller');
		if(!isset($_REQUEST[$_key]) || !$_REQUEST[$_key] || empty($_REQUEST[$_key])) {
			$this->controller = "default";
		}
		else {
			$this->controller = strtolower($_REQUEST[$_key]);
		}
	}
	

	/** 获取事件名称 */
	protected function getActionerName() {
		$_key = conf('actioner');
		if(!isset($_REQUEST[$_key]) || !$_REQUEST[$_key] || empty($_REQUEST[$_key])) {
			$this->actioner = "index";
		}
		else {
			$this->actioner = strtolower($_REQUEST[$_key]);
		}
	}

	protected function getDirName() {
		$_key = conf('dir');
		if(!isset($_REQUEST[$_key]) || !$_REQUEST[$_key] || empty($_REQUEST[$_key])) {
			$this->dir = "";
		}
		else {
			$this->dir = strtolower($_REQUEST[$_key]);
		}
	}


	/** 加载自定义设置参数 */
	protected function loadConfigure() {
		$config_path = conf('app_path') . "/configs/";
		if(is_dir($config_path)) {
			$dh = opendir($config_path);
			while(FALSE !== ($file = readdir($dh))) {
				if($file != '.' && $file != '..') {
					include_once($config_path . $file);
				}
			}
		}

		if (conf("debug")) {
			ini_set("display_errors", "On");
		}
		else {
			ini_set("display_errors", "Off");
		}
	}

	/** 加载自定义函数库 **/
	protected function loadCommon() {
		$config_path = conf('app_path') . "/commons/";
		if(is_dir($config_path)) {
			$dh = opendir($config_path);
			while(FALSE !== ($file = readdir($dh))) {
				if($file != '.' && $file != '..') {
					include_once($config_path . $file);
				}
			}
		}
	}


	/** 创建目录 **/
	protected function mkdirs() {
		$base = conf("app_path");
		//系统错误日志(0777)
		if(!file_exists($base."/logs")) {
			makedir($base."/logs");
			@chmod($base."/logs", 0777);
		}
		
		//网站缓存目录(0777)
		if(!file_exists($base."/caches")) {
			makedir($base."/caches");
			@chmod($base."/caches", 0777);
		}
		
		//模板编译目录(0777)
		if(!file_exists($base."/compiler")) {
			makedir($base."/compiler");
			@chmod($base."/compiler", 0777);
		}
		
		//控制器目录
		if(!file_exists($base."/controllers")) {
			makedir($base."/controllers");
		}
		
		//自定义模块目录
		if(!file_exists($base."/models")) {
			makedir($base."/models");
		}
		
		//模板文件目录
		if(!file_exists($base."/views")) {
			makedir($base."/views");
		}
		
		//网站设置目录
		if(!file_exists($base."/configs")) {
			makedir($base."/configs");
		}
		
		//自定义函数目录
		if(!file_exists($base."/commons")) {
			makedir($base."/commons");
		}
	}




	/**
	+-----------------
	* 程序运行入口点
	+-----------------
	*/
	public function run() {
		$_controller = & $this->controller;
		$_actioner   = & $this->actioner;
		$_dir        = empty($this->dir)? "" : $this->dir."/";

		$class_path = str_replace("\\", "/", conf('app_path') . "/controllers/{$_dir}{$_controller}.controller.php");
		$class_name = strtolower($_controller)."_controller";
		
		try {
			if(file_exists($class_path) && !empty($class_path)) {
				include_once($class_path);
			}
			else {
				throw new Except(sprintf('控制器 <b>%s</b> 没有定义', $class_path));
			}

			if(class_exists($class_name)) {
				$class = new $class_name();
			}
			else {
				throw new Except(sprintf('控制器 <b>%s</b> 没有定义', $class_name));
			}

			if(method_exists($class, $_actioner)) {
				$class->$_actioner();
			}
			else {
				throw new Except(sprintf('控制器事件 <b>%s</b> 没有定义', $_actioner));
			}
		}
		catch (Except $e) {
			if (conf("debug")) {
				echo $e->__toString();
			}
			return false;
		}
	}
}
?>
