<?php
class AppModel extends base
{
	protected static $DBO;
	protected $options = array('table'=>'','where'=>'','order'=>'','limit'=>'','field'=>'');
	protected $tableName;
	protected $tableFullName;
	protected $verify = null;
	protected $verifyError = array();
	
	public function __construct() {
		$this->instance();
		$this->setTableName();

		if(method_exists($this, "init")) {
			$this->init();
		}
	}
	
	/** 自动设置数据库表名称 */
	protected function setTableName()
	{
		if(!$this->tableName && !$this->tableFullName){
			$tableName = preg_replace("(.+?)Model", "\\1", get_class($this));
			$this->tableName = conf('db_prefix') . $tableName;
		}
	}
	
	/** 加载并创建驱动的实例 */
	protected function instance() {
		if(!self::$DBO) {
			$driver_path = dirname(__FILE__) . "/drivers/dbo_" . strtolower(conf('driver')) . ".php";
			$class_name  = "mfs_" . strtolower(conf('driver'));
			include_once($driver_path);
			self::$DBO = new $class_name();
		}
	}
	
	/** 直接执行SQL句子 */
	public function query($SQL_string) {
		return self::$DBO->query($SQL_string);
	}
	
	/**
	* 获取数据量
	* @param $conditions 查询过滤条件
	* @param $field      字段名称
	*/
	public function getCount()
	{
		$tableName = $this->_getTable();
		$options = $this->_getOptions();
		$count = self::$DBO->getcount($tableName, $options["where"], $options["field"]);
		return $count;
	}
	
	/** 查询多条数据 */
	public function findAll() {
		$tableName = $this->_getTable();
		$options = $this->_getOptions();
		return self::$DBO->read($tableName, $options['where'], $options['order'], $options['limit'], $options['field']);
	}
	
	/** 查询单条数据 */
	public function find()
	{
		$this->options['limit'] = 1;
		$result = $this->findAll();
		return ($result)? $result[0] : false;
	}
	
	/** 数据更新操作 */
	public function update($data)
	{
		$tableName = $this->_getTable();
		$options = $this->_getOptions();
		return self::$DBO->update($tableName, $data, $options['where'], $options['limit']);
	}
	
	/** 删除所有数据 */
	public function removeAll()
	{
		$tableName = $this->_getTable();
		$options = $this->getOptions();
		return self::$DBO->remove($tableName, null, $options['limit']);
	}
	
	/** 删除数据 */
	public function remove()
	{
		$tableName = $this->_getTable();
		$options = $this->_getOptions();
		return self::$DBO->remove($tableName, $options['where'], $options['limit']);
	}
	
	/** 插入数据 */
	public function create($data)
	{
		$tableName = $this->_getTable();
		$options = $this->_getOptions();
		return self::$DBO->create($tableName, $data);
	}



	/**
	 * 临时设置数据库表名称
	 * @param $tableName
	 * @return unknown_type
	 */
	public function table($tableName)
	{
		$this->options['table'] = $tableName;
		return $this;
	}
	
	
	/**
	 * 设置数据列表查询条件
	 * @param $condition  where_map
	 * @return unknown_type
	 */
	public function where($condition)
	{
		$this->options['where'] = $condition;
		return $this;
	}
	
	
	/**
	 * 设置数据偏移量
	 * @param $limit
	 * @return unknown_type
	 */
	public function limit($limit)
	{
		$this->options['limit'] = $limit;
		return $this;
	}
	
	
	/**
	 * 设置列表排序
	 * @param $order
	 * @return unknown_type
	 */
	public function order($order)
	{
		$this->options['order'] = $order;
		return $this;
	}
	
	/**
	 * 设置字段列表
	 * @param $fields
	 * @return unknown_type
	 */
	public function field($fields)
	{
		$this->options['field'] = $fields;
		return $this;
	}


	private function _getTable() {
		$table = (!$this->tableName)? $this->tableFullName:conf('db_prefix').$this->tableName;
		$table = !empty($this->options['table'])? $this->options['table']:$table;

		return $table;
	}

	private function _getOptions()
	{
		$options = array();
		$options = array_merge($options, $this->options);
		if(!$options["field"]) $options["field"] = "*";

		$this->options = array(
			'table' => '',
			'where' => '',
			'order' => '',
			'limit' => '',
			'field' => '',
		);

		return $options;
	}
	


	/************
	 * 数据验证
	 ************/
	public function verify($data, $verify=null) {
		$this->verifyError = array();
		if (is_null($this->verify) && is_null($verify)) {
			return false;
		}
		else {
			$verify = ($verify)? $verify : $this->verify;

			foreach($verify as $field) {
				$action = $field[0];
				$key    = $field[1];
				
				switch($action) {
					default:
						if (!$this->$action($data[$key])) {
							if(!isset($this->verifyError[$key])) $this->verifyError[$key] = $field[2];
						}
						break;
					
					case "regex":
						if (!$this->regex($field[2], $data[$key])) {
							if(!isset($this->verifyError[$key])) $this->verifyError[$key] = $field[3];
						}
						break;
					
					case "hasOne":						
						if (!$this->hasOne($key, $data[$key])) {
							if(!isset($this->verifyError[$key])) $this->verifyError[$key] = $field[2];
						}
						break;
				}
			}

			return (!$this->verifyError)? true : false;
		}
	}

	
	//返回数据校验错误信息
	public function getVerifyError() {
		return $this->verifyError;
	}


	 //内容不为空
	protected function notEmpty($param) {
		return empty($param)? false : true;
	}


	//是否为数字
	protected function number($param) {
		return is_numeric($param)? true : false;
	}
	

	//邮箱地址是否正确
	protected function isEmail($param) {
		return preg_match('/^[a-zA-Z]\w+@(\w+)\.(\w+)(\.\w+)*/', $param);
	}
	

	//使用正则表达式验证
	protected function regex($regex, $param) {
		return (boolean)preg_match($regex, $param);
	}


	//值是否已经存在
	protected function hasOne($key, $value) {
		$condition = array($key => $value);
		$result = $this->where($condition)->find();
		return (!$result)? true : false;
	}
}
?>
