<?php
/**
 +-------------------------
 * 设置和读取全局设置的类
 +-------------------------
 */
class Configure
{
	/**
	 * 系统默认设置
	 */
	static protected $configs = array(
		'driver'        => 'mysql',
		'db_host'       => 'localhost',
		'db_user'       => 'root',
		'db_password'   => '',
		'db_name'       => 'database',
		'db_prefix'     => '',
		'db_charset'    => 'utf8',
		'controller'    => 'c',
		'actioner'      => 'a',
		'dir'           => 'd',
		'session_start' => true,
		'ldelim'        => '<{',
		'rdelim'        => '}>',
		'debug'         => true,
		'logs'          => true,
		'subdir'        => "/",
		"mail_title"    => "mfs系统邮件",
		"mail_from"     => "admin@abc.com",
		"mail_user"     => "wmbox.cn",
		"mail_reply"    => "admin@abc.com"

	);
	


	/**
	 * 设置全局参数
	 */
	static public function write($key, $value, $define=false)
	{
		if(!$define) {
			self::$configs[strtolower($key)] = $value;
		}
		else {
			if(!defined($key)) {
				define(strToUpper($key), $value);
			}
			self::$configs[strtolower($key)] = $value;
		}
	}
	
	

	/**
	 * 获取全局参数
	 */
	static public function read($key)
	{
		return self::$configs[$key];
	}

	static public function dump()
	{
		echo "<pre>";
		print_r(self::$configs);
		echo "</pre>";
	}
}


/**
example:
设置参数
Configure::write('driver', 'mysql');

读取参数
$db_driver = Configure::read('driver');
*/
?>
