<?php
class Except extends Exception {
	protected static $log_file;
	protected $sql;

	public function __construct($message = null, $code = 0, Exception $previous = null) {
		if (conf("logs")) {
			$this->log_file = conf("app_path") . "/logs/error.php";
			$this->message = $message;

			if (!file_exists(dirname($this->log_file))) {
				makedir(dirname($this->log_file));
			}

			$this->toLog($code);
		}
		
	}
	


	public function __toString() {
		return "<pre>".parent::__toString()."</pre>";
	}



	protected function toLog($code) {
		$msg  = date("[Y-m-d H:i:s]", time());
		$msg .= " file:".$this->getFile();
		$msg .= " line:".$this->getLine();
		$msg .= " error:".str_replace("\n", "", strip_tags($this->message))."\n";

		$fp = @fopen($this->log_file, "a");
		fwrite($fp, $msg);
		fclose($fp);
		unset($fp);
	}
}
?>