<?php
/**
 * 输出变量进行调试
 */
function dump($var)
{
	echo "<pre>";
	$result = print_r($var, true);
	echo htmlspecialchars($result);
	echo "</pre>";
}



function import($file, $base='APP')
{
	if($base == 'APP') {
		$_file = Configure::read('app_path') . $file;
	}
	else {
		$_file = Configure::read('root') . $file;
	}

	if(file_exists($_file)) include_once($_file);
}


/** 实例化模型 */
function M($modelName)
{
	$argnum = func_num_args();
	$args   = func_get_args();

	switch($argnum)
	{
		case 1:
			return MFS::loadModel1($args[0]);
			break;
		
		case 2:
			return MFS::loadModel2($args[0], $args[1]);
			break;
	}
}


/** 缓存生成/读取 **/
function cache($file, $data=null) {
	if(empty($file)) return false;

	if(is_null($data)) {
		return MFS::getCache($file);
	}

	return MFS::setCache($file, $data);
}


/** 全局设置写入/获取 **/
function conf($key, $data=null, $define=false) {
	if(empty($key)) return false;

	if(is_null($data)) {
		return Configure::read($key);
	}

	Configure::write($key, $data, $define);
}


/** session 的设置与获取 **/
function sess($key, $value=null) {
	if(empty($key)) return false;
	if(is_null($value) && isset($_SESSION[$key])) {
		return $_SESSION[$key];
	}
	else if(is_null($value) && !isset($_SESSION[$key])) {
		return false;
	}

	$_SESSION[$key] = $value;
}


/**
 * 从哈希表 $data 中提取指定的数据
 * @param $data    hashtable  数据
 * @param $fields  array      字段名列表
 **/
function parseFields($data, $fields) {
	if(!$data || !$fields) return false;
	
	$newData = array();
	foreach($fields as $k) {
		if(array_key_exists($k, $data)) $newData[$k] = $data[$k];
	}

	return $newData;
}


/**
 * 检查数据是否有空的值
 * param  $data  array    要进行检查的数据
 * param  $fields  array  要检查的键列表
 * return bool
 */
function checkNull($data, $fields) {
	foreach($fields as $field) {
		if(!isset($data[$field]) || is_null($data[$field]) || empty($data[$field])) {			
			return false;
		}
	}

	return true;
}


/**
 * 清除字符串两边的空格
 */
function trims($data) {
	if(is_string($data)) {
		return trim($data);
	}

	if(is_array($data)) {
		return array_map("trims", $data);
	}
}


/**
 * 对指定的键进行清除HTML元素的操作
 *@ param $data 关联数组(哈希表)
 *@ param $keys 要进行清除的哈希表键名
 */
function parseHTML($data, $keys) {
	foreach($keys as $k) {
		if(array_key_exists($k, $data)) {
			$data[$k] = strip_tags($data[$k]);
		}
	}
	return $data;
}


/**
 * 是否有数据进行POST提交
 *@return bool
 */
function isPost() {
	return ($_SERVER['REQUEST_METHOD'] == 'POST')? true:false;
}


/**
 * 创建目录
 *@ param $path 目录路径，支持创建多级目录
 */
function makedir($path) {
	
	$dirs = preg_split('/\/|\\|\\\\/', $path);
	
	$dir = "";
	foreach($dirs as $k=>$v) {
		if($k == 0 && preg_match('/[a-zA-Z]:/', $v) || empty($v)) {
			$dir = $v;
		}
		else {
			$dir .= "/{$v}";
		}

		if(!empty($dir) && !file_exists($dir)) {
			mkdir($dir);
			@chmod($dir, 0777);
		}
	}
}


/**
 * 发送电子邮件
 * $to 收件人
 * $subject 邮件标题
 * $content 邮件内容
 */
function sendMail($to, $subject, $content) {
	if (!preg_match('/^[a-zA-Z]\w+@(\w+)\.(\w+)(\.\w+)*/', $to)) {
		return false;
	}
	else {
		$vbrs = (DIRECTORY_SEPARATOR == "/")? "\n" : "\r\n";

		$title    = empty($subject)? conf("mail_title") : strval($subject);
		$content  = strval($content);
		$to       = strval($to);

		$headers  = "From: =?utf-8?B?".base64_encode(conf("mail_user"))."?= <".conf("mail_from").">".$vbrs;
		$headers .= "Reply-To: ".conf("mail_reply").$vbrs;
		$headers .= "MIME-Version: 1.0".$vbrs;
		$headers .= "Content-type: text/html; charset=utf-8".$vbrs;
		$headers .= "Content-Transfer-Encoding: base64".$vbrs;

		$title    = "=?utf-8?B?" . base64_encode($title) . "?=";
		$content  = "=?utf-8?B?" . base64_encode($content) . "?=";

		$bool = mail($to, $title, $content, $headers);

		return ($bool)? true : false;
	}
}


/**
 * 生成链接路径
 */
function rewrite($action, $controller="default", $dir="") {
	$url = $_SERVER["PHP_SELF"] . "?";
	if ($controller != "default") $url .= conf("controller") . "=" . $controller;
	if (strlen($url) > 2) $url .= "&";
	$url .= conf("actioner") . "=" . $action;
	if (!empty($dir)) $url .= "&".conf("dir")."=" . $dir;
	
	return $url;
}



function def($var, $default="") {
	return isset($var)? $var : $default;
}


/**
 * 进行页面跳转
 */
function redirect($url, $title="", $time=0) {
	echo <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><title>$title</title><meta http-equiv="refresh" content="$time;URL=$url" /></head><body></body></html>
EOF;
}
?>
