<?php
class MFS
{
	static private $models = array();
	static private $times = array();
	
	/** 加载用户自定义模块 */
	static public function loadModel1($modelName)
	{
		$key       = strtolower($modelName);
		$modelName = ucfirst($key).'Model';
		$model     = conf('app_path').'/models/'.$key.'.model.php';
		
		if(isset(self::$models[$key]))
		{
			return self::$models[$key];
		}
		elseif(file_exists($model))
		{
			include_once $model;
			$M = new $modelName();
			self::$models[$key] = & $M;
			return $M;
		}
		else {
			return;
		}
	}

	
	/**
	 * 标准的类库加载方法
	 * @param $inlet     加载的模型入口点，SYS/APP
	 * $param $modelName 模型的文件名
	 */
	static public function loadModel2($inlet='SYS', $modelName)
	{
		if(!$inlet) return;
		if(!$modelName) return;

		$key       = strtolower($modelName);
		$modelName = ucfirst($key).'Model';

		switch(strtoupper($inlet))
		{
			case 'APP':
				$model = conf('app_path').'/models/'.$key.'.model.php';
				break;
			
			case 'SYS':
				$model = conf('root').'/models/'.$key.'.model.php';
				break;
		}
		
		if(isset(self::$models[$key]))
		{
			return self::$models[$key];
		}
		elseif(file_exists($model))
		{
			include_once $model;
			$M = new $modelName();
			self::$models[$key] = & $M;
			return $M;
		}
		else {
			return;
		}
		
	}

	
	/**
	 * 创建缓存
	 * @param $file  缓存文件名
	 * @param $data  要生成缓存的数据
	 * 
	 * @return bool
	 */
	public static function setCache($file, $data) {
		if(dirname($file) != ".") {
			$dir = Configure::read('app_path').'/caches/'.dirname($file);
		}
		else {
			$dir = Configure::read('app_path').'/caches';
		}

		if(!file_exists($dir)) {
			makedir($dir);
		}

		$cache = $dir . "/" . basename($file) . '.php';
		$pf = fopen($cache, 'wb');
		fwrite($pf, serialize($data));
		fclose($pf);
		unset($pf);
		chmod($cache, 0777);
	}



	/**
	 * 读取缓存
	 * @param $file  缓存文件名
	 * 
	 * @return bool/data
	 */
	public static function getCache($file) {
		$dir = Configure::read('app_path').'/caches/';
		$cache = $dir. $file . '.php';
		
		if(file_exists($cache)) {
			$data = "";
			$pf = fopen($cache, 'rb');
			while($line = fgets($pf, 254)) {
				$data .= $line;
			}
			fclose($pf);
			unset($pf);

			return unserialize($data);
		}
		else {
			return false;
		}
	}


	/**
	 * 清除缓存文件
	 * @param $file  缓存文件名称，如果不设置，则清空整个目录的缓存
	 * 
	 * @return bool
	 */
	public static function clearCache($file=null) {
		$dir = conf('app_path').'/caches/';
		$old = umask(0);

		if(!is_null($file)) {	
			$cache = $dir. $file . '.php';

			if(file_exists($cache)) {
				return unlink($cache);
			}
			else {
				return false;
			}
		}
		else {
			$files = glob($dir.'*.*');
			foreach($files as $f) {
				@unlink($f);
			}

			return true;
		}

		umask($old);
	}
	

	/**
	 * 启动计时器
	 *@param $key 计时器名称
	 */
	public static function startTime($key) {
		list($msec, $sec) = explode(' ', microtime());
		self::$times[$key] = $msec;
	}
	
	/**
	 * 结束计时器
	 *@param $key 计时器名称
	 *@return float 执行的时间
	 */
	public static function endTime($key) {
		list($msec, $sec) = explode(' ', microtime());
		$runed = $msec - self::$times[$key];
		unset(self::$times[$key]);
		return $runed;
	}
}
?>