<?php
class Template
{
	protected $compildir = null;
	protected $vars = array();
	
	public function __construct()
	{
		$this->compildir = conf('app_path').'/compiler';
		if(!file_exists($this->compildir))
		{
			mkdir($this->compildir, 0777);
		}
	}
	
	
	public function display($file_name, $mode="")
	{
		if(!file_exists(conf('app_path').'/views'.$file_name)) exit('模板文件"'.$file_name.'"不存在，请检查路径是否有误!');

		foreach($this->vars as $_key => $_val) {
			$$_key = $_val;
		}

		$basename = md5(basename($file_name)).'.php';
		$basedir  = dirname($file_name);
		if($basedir == "/") $basedir = "";
		
		if(!file_exists($this->compildir.$basedir)) {
			makedir($this->compildir.$basedir);
		}

		$compilPage = $this->compildir.$basedir.'/'.$basename;
		if(!file_exists($compilPage) || conf('debug') == TRUE)
		{
			$data = $this->loadtemplate($file_name);
			$this->create($compilPage, $this->compil($data));
		}
		
		switch($mode) {
			case "gzhandler":
				ob_start("ob_gzhandler");
				include $compilPage;
				ob_end_flush();
				break;
			
			case "compress":
				ob_start();
				include $compilPage;
				$pattent = array(
					'/(\s{2,})|(\r\n)|\n/',
					'/\<!--([^-]+)--\>/'
				);

				$code = preg_replace($pattent, '', ob_get_clean());
				
				ob_start("ob_gzhandler");
				echo $code;
				ob_end_flush();
				break;
			
			default:
				include $compilPage;
		}
	}
	
	public function compil($data)
	{
		$matchs = array();
		$compiler = $data;
		$ldelim = conf('ldelim');
		$rdelim = conf('rdelim');
		
		$compiler = preg_replace('/\<\?php([\s\n\r])(.+?)([\s\n\r]+)\?\>/', '&lt;\\1\\2\\3?&gt;', $data);

		preg_match_all('/'.$ldelim.'include\s(.+?)'.$rdelim.'/', $compiler, $matchs, PREG_PATTERN_ORDER);
		
		foreach($matchs[1] as $index => $item) {
			$item = str_replace(array("\"","'"), "", $item);
			ob_start();
			$this->display($item);
			$icode = ob_get_clean();
			$compiler = str_replace($matchs[0][$index], $icode, $compiler);
		}

		$compiler = preg_replace('/'.$ldelim.'\*(.+?)\*'.$rdelim.'/', '', $compiler);
		$compiler = preg_replace('/'.$ldelim.'\$(.+?)'.$rdelim.'/', '<?php echo $\\1 ?>', $compiler);
		$compiler = preg_replace('/'.$ldelim.'\/foreach'.$rdelim.'/', '<?php endforeach ?>', $compiler);
		$compiler = preg_replace('/'.$ldelim.'if (.+?)'.$rdelim.'/', '<?php if(\\1): ?>', $compiler);
		$compiler = preg_replace('/'.$ldelim.'else'.$rdelim.'/', '<?php else: ?>', $compiler);
		$compiler = preg_replace('/'.$ldelim.'\/if'.$rdelim.'/', '<?php endif ?>', $compiler);
		
		
		preg_match_all('/'.$ldelim.'foreach\s(.+?)'.$rdelim.'/', $compiler, $matchs, PREG_PATTERN_ORDER);
		
		foreach($matchs[1] as $index => $item) {
			$keys = array();
			$member = explode(" ", $item);

			foreach($member as $param) {	
				$exp = explode("=", $param);
				$keys[$exp[0]] = substr($exp[1], 1, -1);
			}

			if(array_key_exists('key', $keys)) {
				$compiler = str_replace($matchs[0][$index], "<?php foreach(\${$keys['from']} as \${$keys['key']}=>\${$keys['item']}): ?>", $compiler);
			}
			else {
				$compiler = str_replace($matchs[0][$index], "<?php foreach(\${$keys['from']} as \${$keys['item']}): ?>", $compiler);
			}
		}

		$compiler = preg_replace('/'.$ldelim.'(.+?)'.$rdelim.'/', '<?php echo \\1 ?>', $compiler);

		return $compiler;
	}
	
	
	
	public function assign($key, $value)
	{
		if(is_array($key))
		{
			array_merge($this->vars, $key);
		}
		else
		{
			$this->vars[$key] = $value;
		}
	}
	
	
	private function loadtemplate($file_name)
	{
		$file = conf('app_path').'/views'.$file_name;
		
		if(file_exists($file) && is_file($file)) {
			$data = '';
			
			$pf = fopen($file, 'r');
			while(!feof($pf))
			{
				$data .= fgets($pf, 254);
				
			}
			fclose($pf);
			return $data;
		}
		else {
			return '';
		}		
	}
	
	
	private function create($compil_file, $data='')
	{
		$compil_file = str_replace("\\","/",$compil_file);

		if(!empty($data)) {
			$dirs = dirname($compil_file);
			if(!file_exists($dirs)) makedir($dirs);

			$pf = fopen($compil_file, 'w');
			fwrite($pf, $data);
			fclose($pf);
			chmod($compil_file, 0777);
		}
	}
}
?>