<?php
class ImageModel
{
	/** 类保护变量 */
	protected $th_width    = 100;
	protected $th_height   = 50;
	protected $quality     = 85;   //图片质量
	protected $transparent = 50;   //水印透明度
	protected $background  = "255,255,255";  //背景颜色
	

	/**
	 * 生成缩略图文件
	 * @param  $src  原图文件
	 * @param  $dst  目标文件
	 */
	public function thumb($src, $dst=null, $output=true)
	{
		$thumb = array($this->th_width, $this->th_height);

		if(!file_exists($src)) die('File not exists.');

		$src_im    = $this->IM($src);
		$resize_im = $this->imageresize($src_im, $this->th_width, $this->th_height);

		if(!$output) {
			header("Content-type: image/jpeg");
			imagejpeg($resize_im, null, $this->quality);
		}
		else {
			$new_file = empty($dst)? $src:$dst;
			imagejpeg($resize_im, $new_file, $this->quality);
		}

		@imagedestroy($src_im);
		@imagedestroy($resize_im);
	}
	

	/**
	 * 对图片按百分比进行缩放处理
	 * @param  string       $src     原图文件
	 * @param  string       $dst     输入的目标文件
	 * @param  float/array  $zoom    缩放比例，浮点类型时按百分比绽放，数组类型时按指定大小时行缩放
	 * @param  boolean      $output  是否生成文件输出
	 */
	public function scale($src, $dst=null, $zoom=1, $output=true)
	{
		if(!file_exists($src)) die('File not exists.');
		if(!$zoom) die('the zoom undefine.');

		$src_im     = $this->IM($src);
		$old_width  = imagesx($src_im);

		if(is_float($zoom)) {
			//按百分比进行缩放
			$new_width  = $old_width * $zoom;
		}
		elseif(is_array($zoom)) {
			//明确的缩放尺寸
			$new_width  = $zoom[0];
		}
		
		//是否定义的缩放的高度
		if(!isset($zoom[1])) {
			//等比例缩放
			$resize_im = $this->imageresize($src_im, $new_width);
		}
		else {
			//非等比例缩放
			$resize_im = $this->imageresize($src_im, $new_width, $zoom[1]);
		}

		if(!$output) {
			header("Content-type: image/jpeg");
			imagejpeg($resize_im, null, $this->quality);
		}
		else {
			$new_file = empty($dst)? $src:$dst;
			imagejpeg($resize_im, $new_file, $this->quality);
		}

		imagedestroy($im);
		imagedestroy($nIm);
	}

	

	/**
	 * 对图片进行裁切
	 * @param $src    原始文件
	 * @param $dst    目标文件
	 * @param $output 是否生成目标文件
	 */
	public function capture($src, $dst=null, $output=true) {
		if(!file_exists($src)) die('File not exists.');

		$width  = $this->th_width;
		$height = $this->th_height;
		$src_im = $this->IM($src);
		$old_width  = imagesx($src_im);
		$old_height = imagesy($src_im);
		
		$capture = imagecreatetruecolor($width, $height);
		$rgb = explode(",", $this->background);
		$white = imagecolorallocate($capture, $rgb[0], $rgb[1], $rgb[2]);
		imagefill($capture, 0, 0, $white);

		//当图片大于缩略图时进行缩放
		if($old_width > $width && $old_height>$height) {
			$resize_im  = $this->imageresize($src_im, $width);

			//图片比例不合规范时，重新计算比例进行裁切
			if(imagesy($resize_im) < $height) {
				$proportion = $old_height/$this->th_height;
				$resize_im = $this->imageresize($src_im, $old_width/$proportion);
			}
			
			$posx = 0;
			$posy = 0;
		}
		else {
			//图片小于缩略图时将图片居中显示
			$posx      = ($width-$old_width)/2;
			$posy      = ($height-$old_height)/2;
			$resize_im = $src_im;			
		}

		imagecopy($capture, $resize_im, $posx, $posy, 0, 0, imagesx($resize_im), imagesy($resize_im));
		
		if(!$output) {
			header("Content-type: image/jpeg");
			imagejpeg($capture, null, $this->quality);
		}
		else {
			$new_file = empty($dst)? $src:$dst;
			imagejpeg($capture, $new_file, $this->quality);
		}

		imagedestroy($src_im);
		@imagedestroy($resize_im);
		imagedestroy($capture);
	}



	/**
	 * 写入水印图片
	 * @param $src          需要写入水印的图片
	 * @param $mark         水印图片
	 * @param $transparent  水印透明度
	 */
	public function mark($src, $mark, $dst='', $output=true)
	{
		$mark_info = getimagesize($mark);
		$src_info  = getimagesize($src);
		list($mw,$mh) = $mark_info;
		list($sw,$sh) = $src_info;
		
		$px = $sw - $mw;
		$py = $sh - $mh;
		
		$im  = $this->IM($src);
		$mim = $this->IM($mark);
		
		imagecopymerge($im, $mim, $px, $py, 0, 0, $mw, $mh, $this->transparent);
		
		if($output){
			$new_file = empty($dst)? $src:$dst;
			imagejpeg($im, $new_file, $this->quality);
		}
		else
		{
			header('Content-type: image/jpeg');
			imagejpeg($im);
		}
		imagedestroy($im);
		imagedestroy($mim);
	}
	
	



	/**
	 * 通过文件，获取不同的GD对象
	 */
	protected function IM($file)
	{
		if(!file_exists($file)) die('File not exists.');
		$info = getimagesize($file);
		switch($info['mime'])
		{
			case 'image/gif':
				$mim = imagecreatefromgif($file);
				break;
			
			case 'image/png':
				$mim = imagecreatefrompng($file);
				imagealphablending($mim, false);
				imagesavealpha($mim, true);
				break;
			
			case 'image/jpeg':
				$mim = imagecreatefromjpeg($file);
				break;
			
			default:
				die('File format errors.');
		}
		return $mim;
	}


	/**
	 * 对图片进行缩放的处理
	 * @param resource $src_im 图像GD对象
	 * @param integer  $width  图片的宽度
	 * @param integer  $height 图片的高度，如果不设置高度，将对图片进行等比例缩放
	 * @return resuorce $im    返回一个GD对象
	 */
	protected function imageresize($src_im, $width, $height=null) {
		$old_width  = imagesx($src_im);
		$old_height = imagesy($src_im);
		$proportion = $old_width/$old_height;

		$new_width = $width;
		$new_height = is_null($height)? round($new_width / $proportion):$height;

		
		//创建新的图象并填充默认的背景色
		$im  = imagecreatetruecolor($new_width, $new_height);
		$rgb = explode(",", $this->background);
		$white = imagecolorallocate($im, $rgb[0], $rgb[1], $rgb[2]);
		imagefill($im, 0, 0, $white);

		//对图片进行缩放
		imagecopyresized($im, $src_im, 0, 0, 0, 0, $new_width, $new_height, $old_width, $old_height);
		return $im;
	}



	public function verifyCode($len=5) {
		$str = "ABCDEFGHIJKLNMPQRSTUVWXYZ123456789";

		$im  = imagecreatetruecolor ( 70, 20 );
		$bgc = imagecolorallocate($im, 255, 255, 255);
		$bgtxt = imagecolorallocate($im, 220, 220, 220);

		$colors = array(
			imagecolorallocate($im, 255, 0, 0),
			imagecolorallocate($im, 30, 200, 0),
			imagecolorallocate($im, 0, 0, 255),
			imagecolorallocate($im, 0, 0, 0),
			imagecolorallocate($im, 255, 128, 0),
			imagecolorallocate($im, 255, 208, 0),
			imagecolorallocate($im, 98, 186, 245),
		);

		imagefill($im, 0, 0, $bgc);
		
		//随机获取数字
		$verify = "";
		
		while (strlen($verify) < $len) {
			$i = strlen($verify);
			$random = $str[rand(0, strlen($str))];
			$verify .= $random;
			
			imagestring($im, 6, ($i*10)+3, rand(0,6), $random, $bgtxt);
			imagestring($im, 6, ($i*10)+3, rand(0,6), $random, $colors[rand(0, count($colors)-1)]);
		}
		
		//添加随机杂色
		for($i=0; $i<100; $i++) {
			$color = imagecolorallocate($im, rand(50,220), rand(50,220), rand(50,220));
			imagesetpixel($im, rand(0,70), rand(0,20), $color);
		}
		
		$_SESSION["verify"] = $verify;
		header('Content-type: image/png');
		imagepng($im);
		imagedestroy($im);
	}



	/**
	 * 类变量赋值
	 */
	public function __set($key, $value)
	{
		$this->$key = $value;
	}
	




	/**
	 * 获取类变量值
	 */
	public function __get($key)
	{
		return $this->$key;
	}
}
?>