<?php
class UploadModel
{
	protected $keys;
	protected $err = array();
	protected $target;
	protected $exts;
	protected $maxSize;
	protected $randName;
	protected $files = array();
	
	/**
	 * ʼ
	 */
	public function __construct()
	{
		$this->exts = array('jpeg','jpg','gif','png','zip','rar');
		$this->maxSize = 1024*1024*2;
		$this->target = conf('app_path') . '/upload/';
		$this->randName = true;
		$this->keys = $this->getKeys();
	}
	
	/**
	 * ȡ file 
	 */
	protected function getKeys()
	{
		$keys = array_keys($_FILES);
		return $keys;
	}
	
	
	/**
	 * òͬ͵ı
	 */
	public function __set($name, $value)
	{
		$property = array('target','exts','maxSize','randName');
		if(!in_array($name, $property)) return false;

		switch(strval($name))
		{
			case 'target':
				$this->$name = conf('app_path') . $value;
				break;
			
			case 'exts':
				$this->$name = explode(',', $value);
				break;
			
			case 'randName':
				if($value === true || $value == 1)
				{
					$this->$name = true;
				}
				else {
					$this->$name = false;
				}
				break;

			default:
				$this->$name = $value;
		}
	}

	
	/**
	 * ƶϴļָĿ¼
	 * @param $fileName ƶļƵʱ򣬶ϴļ
	 */
	public function save($fileName="")
	{
		$this->err = array();
		$this->files = array();

		if(!file_exists($this->target)) {
			mkdir($this->target);
			chmod($this->target, 0777);
		}

		foreach($this->keys as $key)
		{
			
			if(is_array($_FILES[$key]['name']))
			{
				$count = count($_FILES[$key]['name']);
				for($i=0; $i<$count; $i++)
				{
					$keys = array_keys($_FILES[$key]);
					foreach($keys as $item)
					{
						$file[$item] = $_FILES[$key][$item][$i];
					}
					$this->upload($file, $fileName);
				}
				return (count($this->err) > 0)? false:true; 
			}
			else {
				return $this->upload($_FILES[$key], $fileName);
			}
		}
	}
	

	/** ڲϴļĹ */
	protected function upload($file, $fileName)
	{
		if(!is_uploaded_file($file['tmp_name'])) return false;
		if(!$this->checkExt($file)) return false;
		if(!$this->checkSize($file)) return false;
		
		if($this->randName)
		{
			$newFileName = $this->target . date('YmdHis', time()) . rand(0,9) . '.' . $this->getExt($file['name']);
		}
		elseif(empty($fileName))
		{
			$newFileName = $this->target . '/' . $file['name'];
		}
		else {
			$newFileName = $this->target . '/' . $fileName;
		}

		$result = move_uploaded_file($file['tmp_name'], $newFileName);
		if(!$result)
		{
			return false;
		}
		else {
			$this->files[] = str_replace($this->target, '', $newFileName);
			return true;
		}
		
	}
	

	/**
	 * Ƿǿϴļ
	 * @param $file  ļ
	 */
	public function checkExt($file)
	{
		if(!in_array($this->getExt($file['name']), $this->exts))
		{
			$this->err[] = $file['name'].':ext';
			return false;
		}
		else {
			return true;
		}
	}


	/**
	 * ȡļ׺
	 */
	public function getExt($fileName)
	{
		$pos = strrpos($fileName, '.')+1;
		return substr($fileName, $pos);
	}
	

	/**
	 * ļСǷϷ
	 */
	public function checkSize($file)
	{
		if($size > $this->maxSize)
		{
			$this->err[] = $file['name'].':max';
			return false;
		}
		else {
			return true;
		}
	}

	/**
	 * ȡѾϴļ
	 */
	public function getFiles()
	{
		return $this->files;
	}
}