<?php
/**
 * The control class file of ZenTaoPHP.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: control.class.php 1161 2009-04-27 06:43:51Z wwccss $
 * @link        http://www.zentao.cn
 */
class control
{
    protected $moduleName = '';       // ģ֡
    protected $modulePath = '';       // ģڵ·
    private   $models     = array();  // ¼Ѿعmodel
    private   $vars       = array();  // ¼ֵviewı
    private   $modelFile  = '';       // Ҫصmodel 
    private   $viewFile   = '';       // Ҫصview 
    private   $output     = '';       // ݡ

    protected $app        = '';
    protected $config     = '';
    protected $lang       = '';
    protected $dbh        = '';
    protected $pathFix    = '';

    public function __construct()
    {
        /* ȫֶ󣬲ֵ*/
        global $app, $config, $lang, $dbh;
        $this->app        = $app;
        $this->config     = $config;
        $this->lang       = $lang;
        $this->dbh        = $dbh;
        $this->pathFix    = $this->app->getPathFix();
        $this->moduleName = $this->app->getModuleName();
        $this->modulePath = $this->app->getModuleRoot() . $this->moduleName . $this->pathFix;

        /* Զ$config$langֵģС*/
        $this->assign('lang',   $lang);
        $this->assign('config', $config);

        /* Զصǰģmodelļ*/
        $this->loadModel();
    }

    //-------------------- modelصķ--------------------//

    /* model*/
    private function setModelFile($moduleName)
    {
        $this->modelFile = $this->app->getModuleRoot() . strtolower(trim($moduleName)) . $this->pathFix . 'model.php';
        return file_exists($this->modelFile);
    }

    /* model*/
    public function loadModel($moduleName = '')
    {
        /* ûָmoduleȡǰصģΪmodel*/
        if(empty($moduleName)) $moduleName = $this->moduleName;
        if(!$this->setModelFile($moduleName)) return false;

        if(in_array($moduleName, $this->models)) return;
        include $this->modelFile;
        $modelClass = $moduleName. 'Model';
        if(!class_exists($modelClass)) $this->app->error(" The model $modelClass not found", __FILE__, __LINE__, $exit = true);
        $this->$moduleName = new $modelClass();
    }

    //-------------------- viewصķ--------------------//

    /* ͼļ*/
    private function setViewFile($moduleName, $methodName)
    {
        $moduleName = strtolower(trim($moduleName));
        $methodName = strtolower(trim($methodName));
        $viewFile = $this->app->getModuleRoot() . $moduleName . $this->pathFix . 'view' . $this->pathFix . $methodName . '.' . $this->app->getViewType() . '.php';
        if(!file_exists($viewFile)) $this->app->error("the view file $viewFile not found", __FILE__, __LINE__, $exit = true);
        return $viewFile;
    }

    /* ֵһviewͼ*/
    public function assign($name, $value)
    {
        $this->vars[$name] = $value;
    }

    /* outputݡ*/
    public function clear()
    {
        $this->output = '';
    }

    /* ͼļ*/
    public function parse($moduleName = '', $methodName = '')
    {
        if(empty($moduleName)) $moduleName = $this->moduleName;
        if(empty($methodName)) $methodName = $this->app->getMethodName();
        $viewFile = $this->setViewFile($moduleName, $methodName);
        $currentPWD = getcwd();
        chdir(dirname($viewFile));
        extract($this->vars);
        ob_start();
        include $viewFile;
        $this->output .= ob_get_contents();
        ob_end_clean();
        chdir($currentPWD);
    }

    /* ȡͼݡ*/
    public function fetch($moduleName = '', $methodName = '', $clear = false)
    {
        if($clear) $this->clear();
        if(empty($this->output)) $this->parse($moduleName, $methodName);
        return $this->output;
    }

    /* ʾͼݡ*/
    public function display($moduleName = '', $methodName = '')
    {
        if(empty($this->output)) $this->parse($moduleName, $methodName);
        echo $this->output;
    }

    /* ĳһģĳӡ*/
    public function createLink($moduleName, $methodName = 'index', $vars = array())
    {
        if(empty($moduleName)) $moduleName = $this->moduleName;
        return helper::createLink($moduleName, $methodName, $vars);
    }

    /* תһҳ档*/
    public function goto($url)
    {
        header("location: $url");
        exit;
    }
}
