<?php
/**
 * The demo app router file of ZenTaoPHP.
 *
 * All request should be routed by this router.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: index.php 1128 2009-03-23 11:20:46Z wwccss $
 * @link        http://www.zentao.cn
 */
/* ¼ʼʱ䡣*/
$timeStart = _getTime();

/* ļ*/
if(file_exists('../../../framework/all.class.php'))
{
    include '../../../framework/all.class.php';
}
else
{
    include '../../../framework/router.class.php';
    include '../../../framework/control.class.php';
    include '../../../framework/model.class.php';
    include '../../../framework/helper.class.php';
}

/* ʵ·ɶ󣬲ãӵݿ⡣*/
$router = new router('demo');
$config = $router->loadConfig('common');
$dbh    = $router->connectDB();

/* ÿͻʹõԡ*/
$router->setClientLang();
$router->setClientTheme();
$lang = $router->loadLang('common');

/* 󣬼Ӧģ顣*/
$router->parseRequest();
$router->loadModule();

/* DebugϢҳִʱڴռá*/
$timeUsed = round(_getTime() - $timeStart, 4) * 1000;
$memory   = round(memory_get_usage() / 1024, 1);

if(!$config->debug) exit;
echo <<<EOT
<div style='text-align:center'>
<strong>Time</strong>: $timeUsed ms
<strong>Mem</strong>: $memory KB
</div>
EOT;

/* ȡϵͳʱ䣬΢Ϊλ*/
function _getTime()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}
