<?php

/**

 *	  [Jsen.net] (C)2013-2099 Jason Group Science and technology co., LTD.

 *	  This is NOT a freeware, use is subject to license terms

 *

 *	  http://www.jsen.net

 *	  tel:400-681-9511

 */

class AdminMoneyLogController extends AdminBaseController {

	/**

	 * 自动执行

	 */

	public function _initialize() {

		parent::_initialize(); 

		$this->db = model('user_moneylog');

	}



	/**

	 * 会员财务管理

	 */   

	public function index() {

		

		if($_GET["act"]=="excel"){

			$sqlmap = array();

			if ($_GET['keyword']) {

				$map = array();

				$map['username'] = array('LIKE',"%".trim($_GET['keyword'])."%");

				$ids = model('user')->where($map)->getField('id',TRUE);

				$sqlmap['user_id'] = array('IN',$ids);

			}

			if($_GET["start"]!="" or $_GET["end"]!=""){

					$start = strtotime($_GET['start'].' 00:00:00');

					$end = strtotime($_GET['end'].' 23:59:59');

					$sqlmap['dateline'] =array('between',$start.','.$end);

			}

			if($_GET["type"]!=""){

				$sqlmap['type'] = array('eq',$_GET["type"]);

			}

			$_GET['pagenum'] = isset($_GET['page']) ? intval($_GET['page']) : 1;

			$_GET['rowsnum'] = isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

			

			foreach(C("MONEY_TYPE") as $key=>$val){

				$data['money_type'][$i]["id"]=$key;	

				$data['money_type'][$i]["name"]=$val;

				$i+=1;

			}

			$headerArr = array('username'=>'会员名',

				'money'=>'金额',

				'type'=>'类型',

				'user_money'=>'可用余额',

				'freeze_money'=>'冻结金额',

				'dateline'=>'时间',

				'msg'=>'描述',

			);

			$list = $this->db->field(true)->where($sqlmap)->order("id desc");

			$this->DownloadCSV($list, $headerArr);

			exit;

		}

		

		if (IS_POST) {

			//分页

			$is_cache=true;

			$sqlmap = array();

			if ($_GET['keyword']) {

				$map = array();

				$map['username|mobile_phone'] = array('LIKE',"%".trim($_GET['keyword'])."%");

				$ids = model('user')->where($map)->getField('id',TRUE);

				$sqlmap['user_id'] = array('IN',$ids);

				$is_cache=false;

			}

			if($_GET["start"]!="" or $_GET["end"]!=""){

					$start = strtotime($_GET['start'].' 00:00:00');

					$end = strtotime($_GET['end'].' 23:59:59');

					$sqlmap['dateline'] =array('between',$start.','.$end);

					$is_cache=false;

			}

			if($_GET["type"]!=""){

				$sqlmap['type'] = array('eq',$_GET["type"]);

				$is_cache=false;

			}

			$_GET['pagenum'] = isset($_GET['page']) ? intval($_GET['page']) : 1;

			$_GET['rowsnum'] = isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

			$result = $this->db->lists($_GET);

			if (!$result) $result=array();

			$data = array();

			if($is_cache==true){

				$data_sum=S("admin_money_log");

				if($data_sum==""){

					$data_sum = $this->db->cache('admin_money_log',1800)->field("count(id) as total,sum(money) as money,sum(user_money) as user_money,sum(freeze_money) as freeze_money")->where($sqlmap)->find();	

					S('last_log_time',date("Y-m-d H:i:s"),1800);

					$data_sum=S("admin_money_log");

				}

				$data['total']=$data_sum[0]["total"];

				$data['money']=$data_sum[0]["money"];

				$data['user_money']=$data_sum[0]["user_money"];

				$data['freeze_money']=$data_sum[0]["freeze_money"];

				$data['title']="统计概览（30分钟更新一次,上次更新时间".S('last_log_time')."）-累计变动金额：" . ($data["money"] == "" ? "0.00" : $data["money"]) . "元&nbsp;&nbsp;累计可用金额：" . ($data["user_money"] == "" ? "0.00" : $data["user_money"]) . "元&nbsp;&nbsp;累计冻结金额：" . ($data["freeze_money"] == "" ? "0.00" : $data["freeze_money"]) . "元";

			}else{

				$data_sum = $this->db->field("count(id) as total,sum(money) as money,sum(user_money) as user_money,sum(freeze_money) as freeze_money")->where($sqlmap)->find();	

				$data['total']=$data_sum["total"];

				$data['money']=$data_sum["money"];

				$data['user_money']=$data_sum["user_money"];

				$data['freeze_money']=$data_sum["freeze_money"];

				$data['title']="统计概览 -累计变动金额：" . ($data["money"] == "" ? "0.00" : $data["money"]) . "元&nbsp;&nbsp;累计可用金额：" . ($data["user_money"] == "" ? "0.00" : $data["user_money"]) . "元&nbsp;&nbsp;累计冻结金额：" . ($data["freeze_money"] == "" ? "0.00" : $data["freeze_money"]) . "元";

			}

			$data['rows'] = $result;

			$i=0;

			foreach(C("MONEY_TYPE") as $key=>$val){

				$data['money_type'][$i]["id"]=$key;	

				$data['money_type'][$i]["name"]=$val;

				$i+=1;

			}

			echo json_encode($data);

		}else {

			$pays = getcache('payment', 'pay');

			if ($pays['ws_wap']['pay_name']) $pays['ws_wap']['pay_name'] = $pays['ws_wap']['pay_name'].' (不支持)';

			if ($pays['alipay_escow']['pay_name']) $pays['alipay_escow']['pay_name'] = $pays['alipay_escow']['pay_name'].' (不支持)';

			include $this->admin_tpl('admin_money_log');

		}

	}



	public function browse_money(){

		if(IS_POST){



			$sqlmap = array();



			$order['id'] = 'DESC';



			$pagenum=isset($_POST['page']) ? intval($_POST['page']) : 1;



			$rowsnum=isset($_POST['rows']) && (int)($_POST['rows']) != 0 ? intval($_POST['rows']) : PAGE_SIZE;

			$join='';

			$join = 'LEFT JOIN __USER__ AS u ON b.user_id = u.id';

			//$join .= ' LEFT JOIN __ARTICLE__ AS a ON b.article_id = a.id';

			if($_GET["start"]!="" or $_GET["end"]!=""){

				$start = strtotime($_GET['start'].' 00:00:00');

				$end = strtotime($_GET['end'].' 23:59:59');

				$sqlmap['b.fa_time'] =array('between',$start.','.$end);

			}

			if ($_GET['keyword']) {

				$map = array();

				$map['username|mobile_phone'] = array('LIKE',"%".trim($_GET['keyword'])."%");

				$ids = model('user')->where($map)->getField('id',TRUE);

				$sqlmap['b.user_id'] = array('IN',$ids);

				$is_cache=false;

			}

			$data['total'] = M('browse_money')->count();	//计算总数 

			$data['money'] = M('browse_money')->sum('money');	//计算总数 

			$where['time'] = array(

	            array('egt',strtotime(date('Y-m-d',time()))),

	            array('lt',strtotime(date('Y-m-d',time()+86400)))

	        );
			$data['jizn_time']=M('browse_money')->count();
			$data['jin_time']=M('browse_money')->where($where)->count();

			$data['fa_money']=M('browse_money')->where(array('status'=>1))->sum('money')+0.00;
	        $data['jin_money']=M('browse_money')->where($where)->sum('money')+0.00;

			$data['title']="统计概览-累计奖励金额：".$data['money'].' 总数量:'.$data['jizn_time'].' 今天数量:'.$data['jin_time'].' 今日奖励金额:'.$data['jin_money'].' 发放金额:'.$data['fa_money'];

			$data['rows']=M('browse_money')->alias('b')->field('b.*,u.username')->join($join)->where($sqlmap)->limit(($pagenum-1)*$rowsnum.','.$rowsnum)->order($order)->select();

			foreach ($data['rows'] as $key => $value) {
				if($value['fa_time']==''){
					$data['rows'][$key]['fa_time']='';
				}else{
					$data['rows'][$key]['fa_time']=date('Y-m-d H:i:s',$value['fa_time']);
				}
			}

			if (!$data['rows']) $data['rows']=array();



			echo json_encode($data);



		}else{



			include $this->admin_tpl('browsemoney');



		}

	}

	

	private function DownloadCSV($selectObject,$head){

		$fileName=time();

		if ( !is_object( $selectObject ) || !is_array( $head ) ) {

			exit('参数错误!');

		}

		set_time_limit(0);

		//下载头.

		header ('Content-Type: application/vnd.ms-excel;charset=gbk');

		header ('Content-Disposition: attachment;filename="'.$fileName.'.csv"');

		header ('Cache-Control: max-age=0');

		//输出流;

		$file = 'php://output';

		$fp = fopen ( $file, 'a' );



		function changCode( $changArr ) {

			// 破Excel2003中文只支持GBK编码;

			foreach ( $changArr as $k => $v ) {

				$changArr [$k] = iconv ( 'utf-8', 'gbk', $v );

			}

			//返回一个 索引数组;

			return array_values( $changArr );

		};

		//写入头部;

		fputcsv ( $fp, changCode( $head ) );



		//写入数据;

		$pageSize = 100;//每次查询一百条;

		$page  = 1;//起始页码;

		$list = array();

		//查库;

		$money_type=C("MONEY_TYPE");

		$cloneObj = clone $selectObject;//因为thinkphp内部执行完select方法后会清空对象属性,所以clone;

		while ( $list = $cloneObj ->limit( $pageSize*( ($page++)-1 ), $pageSize )->select()  ) {

			$cloneObj = clone $selectObject;

			//对查询结果二次处理

			foreach ( $list as $key => $value ) {

				$value['dateline']= date('Y-m-d H:i',$value['dateline']); 

				$value['username'] = get_nickname($value['user_id']);

				$value['type'] = $money_type[$value["type"]];

				$value = array_intersect_key( $value, $head );//返回需要写入CSV的数据;

				$value = array_merge( $head, $value );//利用此函数返回需要的顺序;

				$value = changCode( $value );

				fputcsv ( $fp, $value );//写入数据;

				flush();

			}

			ob_flush();

		}

		exit();

	}



	/* 财务设置 */

	public function admin_money_log_set() {

		$file = $_POST['files'];

		if(IS_POST) {

			unset($_POST['files']);

			//生成密钥

			$site_key =  C('site_key') ;

			$site_key = isset($site_key) ? $site_key : generate_password();

			$_POST['site_key'] = $site_key;

            if (file_exists(CONF_PATH . $file)){

				if ($this->update_config(daddslashes($_POST), CONF_PATH . $file)) {

					showmessage('操作成功', '', -1);

				} else {

					showmessage('操作失败');

				}	

			}else{

				$conf_file=file_put_contents(CONF_PATH . $file, '<?php return array(); ?>');

				if ($this->update_config(daddslashes($_POST), CONF_PATH . $file)) {

					showmessage('操作成功', '', -1);

				} else {

					showmessage('操作失败');

				}	

			}		

		} else {

			showmessage('请勿非法访问');

		}

	}



	/* 保存配置文件 */

	private function update_config($config, $config_file = '') {

        if(empty($config_file)) return false;

        if($fp = @fopen($config_file, 'wb')) {

            fwrite($fp, "<?php \nreturn " . stripslashes(var_export($config, true)) . ";");

            fclose($fp);

            return true;

        } else {

            return false;

        }

    }



}