<?php

/**

 *	  [Haidao] (C)2013-2099 Dmibox Science and technology co., LTD.

 *	  This is NOT a freeware, use is subject to license terms

 *

 *	  http://www.haidao.la

 *	  tel:400-600-2042

 */

class AdminTradeLogController extends AdminBaseController {

	/**

	 * 自动执行

	 */

	public function _initialize() {

		parent::_initialize(); 

		$this->db = model('UserTrade');

	}

	/**

	 * 交易列表

	 */   

	public function index() {

		if (IS_POST) {

			if ($_GET['keyword']) {

				$map = array();

				$map['username|mobile_phone'] = array('LIKE',"%".trim($_GET['keyword'])."%");

				$ids = model('user')->where($map)->getField('id',TRUE);

				$sqlmap['user_id|sell_id'] = array('IN',$ids);

				$is_cache=false;

			}





			if($_GET["start"]!="" or $_GET["end"]!=""){

					$start = strtotime($_GET['start'].' 00:00:00');

					$end = strtotime($_GET['end'].' 23:59:59');

					$sqlmap['dateline'] =array('between',$start.','.$end);

					$is_cache=false;

			}

			if($_GET["type"]!=""){

				$sqlmap['type'] = array('eq',$_GET["type"]);



				$search_type = $sqlmap['type'];





				// if()

				// $is_cache=false;

			}



			$_GET['pagenum'] = isset($_GET['page']) ? intval($_GET['page']) : 1;

			$_GET['rowsnum'] = isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

	    	$result = M("user_trade ut")

	    	->field("ut.*,b.username as buyer_username,b.mobile_phone as buyer_mobile_phone,s.username as seller_username,s.mobile_phone as seller_mobile_phone")

	    	->join("__USER__ b on b.id=ut.user_id")

	    	->join("__USER__ s on s.id=ut.sell_id")

	    	->where($sqlmap)->order('id DESC')

	    	->limit(($_GET['pagenum']-1)*$_GET['rowsnum'].','.$_GET['rowsnum'])

	    	->select();

			$data = array();

			$data['total'] = (int) M("user_trade")->where($sqlmap)->count();	//计算总数

			$data['rows']  = (array) $result;

			if($result[0]==false) $data['rows'] = array();

			$bla_config = C('bla_config');

			$site_msg_type = array();

			foreach ($bla_config as $key => $value) {

				$terms['id'] = $key;

				$terms['name'] = $value;

				$site_msg_type[] = $terms;

				unset($terms);

			}

			$data['money_type'] = array(

				array(

					'id'=>1,

					'name'=>"卖出"

				),

				array(

					'id'=>2,

					'name'=>"买入"

				)			

			);



			foreach ($data['money_type'] as $kk => $vv) {

				if($vv['id']==$search_type) $data['money_type'][$kk]['selected'] = true;

			}

			// $data['msg_type'] = $site_msg_type;

			$data['search']['type_txt'] = isset($_GET['msgtype']) ? $_GET['msgtype'] :'';

			echo json_encode($data);

		}else {

			include $this->admin_tpl('admin_trade_log');

		}

	}





	/**

	 * 实时统计

	 * @return [type] [description]

	 */

	public function count(){



			$sqlmap = array();

			if($_GET["start_time"]!="" or $_GET["end_time"]!=""){

					$start = strtotime($_GET['start_time'].' 00:00:00');

					$end = strtotime($_GET['end_time'].' 23:59:59');

					$sqlmap['dateline'] =array('between',$start.','.$end);

			}

			$sqlmap['sell_id'] = array("gt",0);

			$sell_count = M("user_trade")->where($sqlmap)->count();

			unset($sqlmap['sell_id']);

			$sqlmap['user_id'] = array("gt",0);

			$buy_count = M("user_trade")->where($sqlmap)->count();

			unset($sqlmap['user_id']);

			$sqlmap['order_status'] = array("eq",3);

			$fee_sum = M("user_trade")->where($sqlmap)->sum("fee");





			$_day = date('Y-m-d');

			$tdmap = array();

			$tdmap['status'] = 3;

            $tdmap['_string'] = "DATE_FORMAT(FROM_UNIXTIME(confi_time),'%Y-%m-%d') = '".$_day."'";

            $today_fee = (float)M("user_trade")->where($tdmap)->sum('fee');

	

			// 计算 对应等级的的手续费

			$today_fee2 = bcmul($today_fee,0.3,4);

			$today_fee3 = bcmul($today_fee,0.25,4);

			$today_fee4 = bcmul($today_fee,0.15,4);

			$today_fee5 = bcmul($today_fee,0.1,4);

			$counts = M("user")->field("user_type,count(id) as count")->group("user_type")->where("user_type>1")->select();

			foreach ($counts as $key => $value) {

				if($value['user_type']==2){

					$counts[$key]['today_fee'] = $today_fee2;

					$counts[$key]['fee'] = bcdiv($today_fee2,$value['count'],4);

				}

				if($value['user_type']==3){

					$counts[$key]['today_fee'] = $today_fee3;

					$counts[$key]['fee'] = bcdiv($today_fee3,$value['count'],4);

				}

				if($value['user_type']==4){

					$counts[$key]['today_fee'] = $today_fee4;

					$counts[$key]['fee'] = bcdiv($today_fee4,$value['count'],4);

				}

				if($value['user_type']==5){

					$counts[$key]['today_fee'] = $today_fee5;

					$counts[$key]['fee'] = bcdiv($today_fee5,$value['count'],4);

				}		

			}



// p($counts);

		include $this->admin_tpl('admin_trade_count');

	}

	/**

	 * 投诉

	 */   

	public function complaint() {

		if (IS_POST) {



			if ($_GET['keyword']) {

				$map = array();

				$map['username|mobile_phone'] = array('LIKE',"%".trim($_GET['keyword'])."%");

				$ids = model('user')->where($map)->getField('id',TRUE);

				$sqlmap['user_id|to_uid'] = array('IN',$ids);

				$is_cache=false;

			}

			if($_GET["start"]!="" or $_GET["end"]!=""){

					$start = strtotime($_GET['start'].' 00:00:00');

					$end = strtotime($_GET['end'].' 23:59:59');

					$sqlmap['dateline'] =array('between',$start.','.$end);

					$is_cache=false;

			}



			$_GET['pagenum'] = isset($_GET['page']) ? intval($_GET['page']) : 1;

			$_GET['rowsnum'] = isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

	    	$result = M("complain cc")

	    	->field("cc.*,a.username as ausername,a.mobile_phone as aphone,a.true_name as atruename,b.true_name as btruename,b.username as busername,b.mobile_phone as bphone,ut.order_sn")

	    	->join("__USER__ a on a.id=cc.user_id")

	    	->join("__USER_TRADE__ ut on ut.id=cc.order_id")

	    	->join("__USER__ b on b.id=cc.to_uid")

	    	->where($sqlmap)->order('id DESC')

	    	->limit(($_GET['pagenum']-1)*$_GET['rowsnum'].','.$_GET['rowsnum'])

	    	->select();

			$data = array();

			$data['total'] = (int) M("complain")->where($sqlmap)->count();	//计算总数

			if($data['total']==0){

				$data['rows']  = array();

			}else{

				$data['rows']  = (array) $result;

			}

			

			$bla_config = C('bla_config');

			$site_msg_type = array();

			foreach ($bla_config as $key => $value) {

				$terms['id'] = $key;

				$terms['name'] = $value;

				$site_msg_type[] = $terms;

				unset($terms);

			}

			// $data['msg_type'] = $site_msg_type;

			$data['search']['type_txt'] = isset($_GET['msgtype']) ? $_GET['msgtype'] :'';

			echo json_encode($data);

		}else {

			include $this->admin_tpl('admin_trade_complaint');

		}

	}	

    /**

     * 反馈列表

     */

    public function feedback(){

        if(IS_POST){

            //分页

            $pagenum=isset($_GET['page']) ? intval($_GET['page']) : 1;

            $rowsnum=isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

            //计算总数

            $data['total'] = model('user_feedback')->count();

            $data['rows'] = model('user_feedback')->limit(($pagenum-1)*$rowsnum.','.$rowsnum)->order('id desc')->select();

            if (!$data['rows']) $data['rows'] = array();

            foreach ($data['rows'] as $key => $value) {

                $data['rows'][$key]['username'] = get_nickname($value['user_id']);

            }

            echo json_encode($data);

        }else{

            include $this->admin_tpl('feedback_list');

        }

    }

    /**

     * 反馈回复

     */

    public function reply()

    {

        $reply = trim(I('reply'));

        $id = I('id');

        if (empty($reply)) showmessage('输入回复内容');

        $data = array(

            'id'=>$id,

            'reply'=>$reply,

            'is_reply'=>1,

            'replytime'=>NOW_TIME,

        );

        $res = model('user_feedback')->save($data);

        if($res){

            showmessage('回复成功', U('admin_trade_log/feedback'), 1);

        }else{

            showmessage('回复失败');

        }

    }

    public function union(){

        if(IS_POST){    	

			$_GET['pagenum'] = isset($_GET['page']) ? intval($_GET['page']) : 1;

			$_GET['rowsnum'] = isset($_GET['rows']) && (int)($_GET['rows']) != 0 ? intval($_GET['rows']) : PAGE_SIZE;

	    	$result = M("union cc")

	    	->field("cc.*,a.username as username")

	    	->join("__USER__ a on a.id=cc.user_id")

	    	->where($sqlmap)->order('id DESC')

	    	->limit(($_GET['pagenum']-1)*$_GET['rowsnum'].','.$_GET['rowsnum'])

	    	->select();

			$data = array();

			$data['total'] = (int) M("union")->where($sqlmap)->count();	//计算总数

			$data['rows']  = (array) $result;

			// $bla_config = C('bla_config');

			// $site_msg_type = array();

			// foreach ($bla_config as $key => $value) {

			// 	$terms['id'] = $key;

			// 	$terms['name'] = $value;

			// 	$site_msg_type[] = $terms;

			// 	unset($terms);

			// }

			// $data['msg_type'] = $site_msg_type;

			$data['search']['type_txt'] = isset($_GET['msgtype']) ? $_GET['msgtype'] :'';

			echo json_encode($data);

		}else {

			include $this->admin_tpl('admin_trade_union');

		}    	

    }

    public function unionset(){

	    $id = $_GET['id'];

	    $status = $_GET['at'];

	    $msg = $_GET['msg'];

	    $info = M("union")->find($id);

	    if($info['union_status']!=0) showmessage('审核失败！');

	    $user = M("user")->find($info['user_id']);

	    // 驳回

	    if($status==2){

			$save = array();

			$save['id'] = $info['id']; 

			$save['union_status'] = 2;

			$save["deal_user"]=ADMIN_ID;

			$save["deal_info"]=$msg;

			$save['deal_time'] = NOW_TIME;

			$rut = M("union")->save($save);

	    	if($rut){

	    		showmessage('操作成功！');

	    	}else{

	    		showmessage('操作失败！');

	    	}

	    }

	    if($status==1){

			M()->startTrans();

			// 认证状态

			$save = array();

			$save['id'] = $info['id']; 

			$save['union_status'] = 1;

			$save["deal_user"]=ADMIN_ID;

			$save["deal_info"]=$msg;

			$save['deal_time'] = NOW_TIME;

			$rut = M("union")->save($save);

			$rut1 = M("user")->where("id=".$user['id'])->setField("is_union",1);

	    	if($rut!==false && $rut1!==false){

	    		M()->commit();

	    		showmessage('操作成功！');

	    	}else{

	    		M()->rollback();

	    		showmessage('操作失败！');

	    	}

	    }

    }

	private function DownloadCSV($selectObject,$head){

		$fileName=time();

		if ( !is_object( $selectObject ) || !is_array( $head ) ) {

			exit('参数错误!');

		}

		set_time_limit(0);

		//下载头.

		header ('Content-Type: application/vnd.ms-excel;charset=gbk');

		header ('Content-Disposition: attachment;filename="'.$fileName.'.csv"');

		header ('Cache-Control: max-age=0');

		//输出流;

		$file = 'php://output';

		$fp = fopen ( $file, 'a' );

		function changCode( $changArr ) {

			// 破Excel2003中文只支持GBK编码;

			foreach ( $changArr as $k => $v ) {

				$changArr [$k] = iconv ( 'utf-8', 'gbk', $v );

			}

			//返回一个 索引数组;

			return array_values( $changArr );

		};

		//写入头部;

		fputcsv ( $fp, changCode( $head ) );

		//写入数据;

		$pageSize = 100;//每次查询一百条;

		$page  = 1;//起始页码;

		$list = array();

		//查库;

		$money_type=C("SILVER_TYPE");

		$cloneObj = clone $selectObject;//因为thinkphp内部执行完select方法后会清空对象属性,所以clone;

		while ( $list = $cloneObj ->limit( $pageSize*( ($page++)-1 ), $pageSize )->select()  ) {

			$cloneObj = clone $selectObject;

			//对查询结果二次处理

			foreach ( $list as $key => $value ) {

				$value['dateline']= date('Y-m-d H:i',$value['dateline']); 

				$value['username'] = get_nickname($value['user_id']);

				$value['type'] = $money_type[$value["type"]];

				$value = array_intersect_key( $value, $head );//返回需要写入CSV的数据;

				$value = array_merge( $head, $value );//利用此函数返回需要的顺序;

				$value = changCode( $value );

				fputcsv ( $fp, $value );//写入数据;

				flush();

			}

			ob_flush();

		}

		exit();

	}

}