<?php

/**

 *      会员中心 - 我的收藏夹

 *      [Jsen.net] (C)2013-2099 Jason Group Science and technology co., LTD.

 *      This is NOT a freeware, use is subject to license terms

 *

 *      http://www.jsen.net

 *      tel:400-681-9511

 */

class UserController extends UserBaseController

{

    public function _initialize() {

        parent::_initialize();

        $this->db = model('User');

    }

    /**

     * 用户反馈

     */

    public function feedback()

    {

        if(IS_POST){

            $txt = I('txt');

            if(trim($txt) == ''){

                showmessage('请输入内容');

            }

            $data = array(

                'user_id'=>$this->userid,

                'content'=>$txt,

                'dateline'=>NOW_TIME,

            );

            $res = M('user_feedback')->add($data);

            if($res){

                showmessage('反馈成功',1);

            }else{

                showmessage('反馈失败');

            }

        }else{

            $list = M("user_feedback")->where("user_id=".$this->userinfo['id'])->order("id asc")->limit(10)->select();

            $SEO = seo(0, '用户反馈');

            include template('feedback');

        }

    }

    /**

     * 认证

     * @return [type] [description]

     */

    public function usercert(){

        $rzinfo = M("user_renzheng")->where("user_id=".$this->userinfo['id'])->find();

        include template('usercert');

    }

    public function dousercert(){

        $truename = I("truename","","htmlspecialchars");

        $idcard = I("idcard","","htmlspecialchars");

 //p(mb_strlen($truename));

// p($this->IsAllChinese($truename));

// die;

        if(!$this->IsAllChinese($truename) || mb_strlen($truename)<2){

            showmessage('姓名为2-4个汉字');

        }

       // die;

        if(!$this->validateIdCard($idcard)){

            showmessage('身份证填写不正确！');

        }

        $data = array();

        $data['user_id'] = $this->userinfo['id'];

        $data['truename']  =$truename;

        $data['idcard']  =$idcard;

        $data['add_time'] = time();

        $map = array();

        $map['user_id'] = $this->userinfo['id'];

        $rzinfo = (int)M("user_renzheng")->where($map)->find();

        // if($rzinfo){

        //     $data['id'] = $rzinfo['id'];

        //     $rut = M("user_renzheng")->save($data);

        // }else{

        //     $rut = M("user_renzheng")->add($data);     

        // }

        $rut = true;

        if(!$rzinfo){

            $rut = M("user_renzheng")->add($data);     

        }

        if($rut){

            redirect('/index.php?m=user&c=user&a=usercert_img');

        }else{

            showmessage('信息填写错误！');

        }

    }

    function IsAllChinese($str){

        $len = preg_match('/^[\x{4e00}-\x{9fa5}]+$/u',$str);

        if($len) return true;

        return false;

    }

    function validateIdCard($value)

    {

        if (!preg_match('/^\d{17}[0-9xX]$/', $value)) { //基本格式校验

            return false;

        }

        $parsed = date_parse(substr($value, 6, 8));

        if (!(isset($parsed['warning_count']) 

            && $parsed['warning_count'] == 0)) { //年月日位校验

            return false;

        }

        $base = substr($value, 0, 17);

        $factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];

        $tokens = ['1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'];

        $checkSum = 0;

        for ($i=0; $i<17; $i++) {

            $checkSum += intval(substr($base, $i, 1)) * $factor[$i];

        }

        $mod = $checkSum % 11;

        $token = $tokens[$mod];

        $lastChar = strtoupper(substr($value, 17, 1));

        return ($lastChar === $token); //最后一位校验位校验

    }

    public function usercert_img(){

        $rzinfo = M("user_renzheng")->where("user_id=".$this->userinfo['id'])->find();

        include template('usercert_img');

    }

    public function dousercert_pic(){

        $pic1 = I("pic1");

        $pic2 = I("pic2");

        $pic3 = I("pic3");

        if($pic1=="") showmessage('请上传身份证正面');

        if($pic2=="") showmessage('请上传身份证背面');

        if($pic3=="") showmessage('请上传手持身份证照');

        $rzinfo = M("user_renzheng")->where("user_id=".$this->userinfo['id'])->find();

        if($rzinfo['status']==1) showmessage('等待管理员审核中，请勿重复上传');

        // p($rzinfo);

        if($rzinfo && $rzinfo['status']!=1){

            $data = array();

            $data['pic1'] = $pic1;

            $data['pic2'] = $pic2;

            $data['pic3'] = $pic3;

            $data['status'] = 0;

            $data['id'] = $rzinfo['id'];

            $data['add_time'] = time();

            $rut = M("user_renzheng")->save($data);

            // echo M()->getlastsql();

            // var_dump($rut);

            if($rut!==false) showmessage('提交成功，请等待审核',"",1);

        }

        showmessage('提交失败，请重试');

    }

    public function bank_find(){

        include template('bank_find');

    }

    public function weixin(){

        if(IS_AJAX){

            $weixin = I("weixin");

            $weixin_qr = I("weixin_qr");

            if($weixin=="") showmessage('请填写微信号码');

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['weixin'] = $weixin;

            if($weixin_qr!="") $data['weixin_qr'] = $weixin_qr;

            $rut = M("user")->save($data);

            if($rut!==false) showmessage('绑定成功！',"",1);

            showmessage('绑定失败，请重试');

        }

        include template('weixin');

    }

    public function alipay(){

        if(IS_AJAX){

            $alipay = I("alipay");

            $alipay_qr = I("alipay_qr");

            if($alipay=="") showmessage('请填写支付宝号码');

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['alipay'] = $alipay;

            if($alipay_qr!="") $data['alipay_qr'] = $alipay_qr;

            $rut = M("user")->save($data);

            if($rut!==false) showmessage('绑定成功！',"",1);

            showmessage('绑定失败，请重试');

        }

        include template('alipay');

    }

    public function bank(){

        if(IS_AJAX){

            $banknum = I("banknum");

            $bankaddress = I("bankaddress");
            $idcard = I("idcard");
            if($idcard==""){ showmessage('请输入持卡人',U('user/bank'),0);}

            if($banknum==""){ showmessage('请填写银行卡号！',U('user/bank'),0);}

            if($bankaddress=="") { showmessage('请填写银行开户行！',U('user/bank'),0);}

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['banknum'] = $banknum;
            $data['idcard'] = $idcard;

            $data['bankaddress'] = $bankaddress;

            $rut = M("user")->save($data);

            if($rut!==false) showmessage('绑定成功！',"",1);

            showmessage('绑定失败，请重试');

        }

        include template('bank');

    }

    public function up_bank(){

        if(IS_AJAX){
            $idcard = I("idcard");

            $banknum = I("banknum");

            $bankaddress = I("bankaddress");
            if($idcard==""){

                $arr['msg']='false';

                $arr['info']='请输入持卡人';

                echo json_encode($arr);die;

            }

            if($banknum==""){

                $arr['msg']='false';

                $arr['info']='请填写银行卡号！';

                echo json_encode($arr);die;

            }

            if($bankaddress=="") {

                $arr['msg']='false';

                $arr['info']='请填写银行开户行！';

                echo json_encode($arr);die;

            }

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['banknum'] = $banknum;
            $data['idcard'] = $idcard;
            $data['bankaddress'] = $bankaddress;

            $rut = M("user")->save($data);

            if($rut!==false){

                $arr['msg']='true';

                $arr['info']='绑定成功！';

                echo json_encode($arr);die;

            }else{

                $arr['msg']='false';

                $arr['info']='绑定失败，请重试';

                echo json_encode($arr);die;

            }

        }

        include template('up_bank');

    }

    public function bank_li(){

        include template('bank_li');

    }

    public function repass_list(){

        include template('repass_list');

    }

    public function bank22(){      

        $_SESSION["send_code_time"]=random(10);

        if (IS_POST){

            if(I("code")==""){ 

                    showmessage('手机验证码错误',"",1);

            }

            if(I("code")!=$_SESSION["reg_code"]){ 

                    showmessage('手机验证码错误',"",1);

            }

            if($_GET['bank_name']==""){ showmessage('请填写银行名称！',U('user/bank'),0);}

            if($_GET['bankaddress']==""){ showmessage('请填写银行开户行！',U('user/bank'),0);}

            unset($_SESSION["reg_code"]);

            $uid = $this->userid;

            $data['id'] = $uid;

            $data['true_name'] = $_GET['true_name'];

            $data['idcard'] = $_GET['idcard'];

            $data['bankaddress'] = $_GET['bank_name'].$_GET['bankaddress'];

            $data['banknum'] = $_GET['banknum'];

            if($data['true_name']=="")unset($data['true_name']);

            if($data['idcard']=="")unset($data['idcard']);

            if($data['bankaddress']=="")unset($data['bankaddress']);

            if($data['banknum']=="")unset($data['banknum']);

            $res = M('User')->save($data);

            if ($res>0){

                showmessage('银行卡修改成功！',U('user/bank'),1);

            }else{

                showmessage('银行卡修改失败！',U('user/bank'),0);

            }

        }else{

            $SEO=seo(0,"银行卡");

            $userInfoList = getUserInfo($this->userid);

            include template('bank');

        }

    }

    /**

     * 

     * 个人资料

     * @author wj 

     * @date  2014-10-14

     * 

     */

    public function userInfo(){ 

        $region = model('Region')->where(array('parent_id'=>1))->select(); 

        if (IS_POST){

            $uid = $this->userid;

            $data['id'] = $uid;

            $data['sex'] = $_GET['sex'];

            if($data['true_name']=="")unset($data['true_name']);

            if($data['idcard']=="")unset($data['idcard']);

            if($data['bankaddress']=="")unset($data['bankaddress']);

            if($data['banknum']=="")unset($data['banknum']);

            $data['birthday'] = strtotime($birthday);

            $data['qq'] = $_GET['qq'];

            $data['province'] = $_GET['province'];

            $data['city'] = $_GET['city'];

            $data['district'] = $_GET['district'];

            $data['address'] = $_GET['address'];

            if($data['mobile_phone']=="")unset($data['mobile_phone']);

            $data['email'] = $_GET['email'];

            $res = M('User')->save($data);

            if ($res>0){

                showmessage('个人信息修改成功！',U('user/userinfo'),1);

            }else{

                showmessage('个人信息修改失败！',U('user/userInfo'),0);

            }

        }else{

             $SEO=seo(0,"个人资料信息");

             $userInfoList = getUserInfo($this->userid);

             $city = model('region')->where(array('parent_id' => $userInfoList['province']))->select();

             $district = model('region')->where(array('parent_id' => $userInfoList['city']))->select();    

             include template('userinfo');

        }

    }

    /**

     * 

     * 账号信息

     * @author wj 

     * @date  2014-10-14

     * 

     */

    public function manage(){

        $userInfoList = getUserInfo($this->userid);//获取用户详细信息

        $address  = model('UserAddress')->where(array('id'=>$userInfoList['address_id']))->find();

        $userInfoList['userAddress']['province'] = model('User')->getCityByid($address['province']);//获取地址名称

        $userInfoList['userAddress']['city'] = model('User')->getCityByid($address['city']);

        $userInfoList['userAddress']['district'] = model('User')->getCityByid($address['district']);

        $uid = $userInfoList['id'];

        if(!empty($userInfoList['mobile_phone'])){//处理手机号码

            $userInfoList['phone'] = substr($userInfoList['mobile_phone'], 0, 3).'*****'.substr($userInfoList['mobile_phone'], -3, 3);

        }else{

            $userInfoList['phone'] = '还未绑定手机号码！';

        }

        if(!empty($userInfoList['email'])){//处理邮箱

            $temp = explode('@', $userInfoList['email']);

            $userInfoList['nemail'] = substr($userInfoList['email'], 0, 3).'*****'.$temp[1];

        }else{

            $userInfoList['nemail'] = '还未绑定邮箱！';

        }

        $user=$userInfoList;

        $SEO=seo(0,"个人账号信息");

        include template('manage');

    }

    /**

    * 

    * 账户安全

    * @author wj

    * @date 2014-10-15

    */

   public function security(){

        $userInfoList = getUserInfo($this->userid);//获取用户详细信息

        if(IS_POST){

            $valid = random(10);

            $password = $this->_post('pwd');

            $r = model('User')->chekPassword($userInfoList['id'],$password);//检查密码是否正确

            if (!$r) showmessage('旧密码错误！');

            $newpwd  = trim($this->_post('newpwd'));

            $newpwd2 = trim($this->_post('newpwd2'));

            if (!$newpwd) showmessage('请输入新密码');

            if (!$newpwd2) showmessage('请输入确认密码');

            if ($newpwd!=$newpwd2) showmessage('两次密码不一致,请重新输入');

            if(md5($newpwd)==$userInfoList["pinpass"]){

                 showmessage('登录密码不能和二级密码相同');

            }

            $data['valid'] = $valid;

            $data['id'] = $userInfoList['id'];

            $data['password'] = md5($valid.$newpwd);

            $res = model('User')->save($data);

            if (!$res>0) showmessage('修改失败！');

            showmessage('修改成功！',U('User/index/index'),1);            

        }else{

            $SEO=seo(0,"账户安全信息");

            include template('security');

        }

   }

   public function pinpass(){

        $userInfoList = getUserInfo($this->userid);//获取用户详细信息

        if(IS_POST){

            $password = $this->_post('pwd');

            $r = model('User')->chekPinPassword($userInfoList['id'],$password);//检查密码是否正确

            if (!$r) showmessage('旧二级密码错误！');

            $newpwd  = trim($this->_post('newpwd'));

            $newpwd2 = trim($this->_post('newpwd2'));

            if (!$newpwd) showmessage('请输入新二级密码');

            if (!$newpwd2) showmessage('请输入确认二级密码');

            if ($newpwd!=$newpwd2) showmessage('两次二级密码不一致,请重新输入');

            if(md5($userInfoList["valid"].$newpwd)==$userInfoList["password"]){

                 showmessage('二级密码不能和登录密码相同');

            }

            $data['id'] = $userInfoList['id'];

            $data['pinpass'] = md5($newpwd);

            $_SESSION["chp"]=$newpwd;

            $res = model('User')->save($data);

            if (!$res>0) showmessage('修改失败！');

            showmessage('修改成功！',U('User/index/index'),1);            

        }else{

            $SEO=seo(0,"账户二级密码");

            include template('pinpass');

        }

   }

   /**

    * 修改密码

    * @return [type] [description]

    */

    public function repass(){

        if(IS_POST){

            $param = $_POST;

            if (empty($param['mobi_code'])) showmessage('验证码不能为空');

            if (empty($param['password'])) showmessage('登录密码不能为空');

            if( $param['mobi_code'] != $_SESSION["reg_code"]){

                showmessage('验证码错误');

            }

            session("reg_code",null);

            session("verify",null);

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['valid']    = random(10);

            $data['password'] = $param['password'] ? md5($data['valid'].$param['password']) : false;

            $rut = M("user")->save($data);

            if($rut) showmessage('登录密码已经成功更改！',"",1);

            showmessage('修改密码失败！');

        }

        $_SESSION["send_code_time"]=random(10);

        $SEO=seo(0,"修改登录密码");

        include template('repass');

    }

    public function repass_up(){

        if(IS_POST){

            $param = $_POST;

            

            if (empty($param['yuan_password'])){

                $arr['msg']='false';

                $arr['info']='原登录密码不能为空';

                echo json_encode($arr);die;

            }
            if (empty($param['new_password'])){

                $arr['msg']='false';

                $arr['info']='新登录密码不能为空';

                echo json_encode($arr);die;

            }

            if ($param['new_password']!=$param['zainew_password']){

                $arr['msg']='false';

                $arr['info']='两次密码输入不一致';

                echo json_encode($arr);die;

            }
            $new=md5($this->userinfo['valid'].$param['yuan_password']);
            if($new!=$this->userinfo['password']){
                $arr['msg']='false';

                $arr['info']='原密码不正确';

                echo json_encode($arr);die;
            }
            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['valid']    = random(10);

            $data['password'] = $param['new_password'] ? md5($data['valid'].$param['new_password']) : false;

            $rut = M("user")->save($data);

            if($rut){

                $arr['msg']='true';

                $arr['info']='登录密码已经成功更改！';

                echo json_encode($arr);die;

            }else{

                $arr['msg']='false';

                $arr['info']='修改密码失败！';

                echo json_encode($arr);die;

            }

        }

    }

    public function passzhi(){

        if(IS_POST){

            $param = $_POST;

            if (empty($param['yuan_password'])){

                $arr['msg']='false';

                $arr['info']='原提现密码不能为空';

                echo json_encode($arr);die;

            }
            if (empty($param['new_password'])){

                $arr['msg']='false';

                $arr['info']='新提现密码不能为空';

                echo json_encode($arr);die;

            }

            if ($param['new_password']!=$param['zainew_password']){

                $arr['msg']='false';

                $arr['info']='两次密码输入不一致';

                echo json_encode($arr);die;

            }
            //echo $param['$param['pinpass']'];die;
            $new=md5($param['yuan_password']);
           
            if($new!=$this->userinfo['pinpass']){
                $arr['msg']='false';

                $arr['info']= '原密码不正确';

                echo json_encode($arr);die;
            }

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['pinpass'] = md5($param['new_password']);

            $rut = M("user")->save($data);

            if($rut!==false){

                $arr['msg']='true';

                $arr['info']='提现密码已经成功更改！';

                echo json_encode($arr);die;

            }else{

                $arr['msg']='false';

                $arr['info']='修改提现失败！';

                echo json_encode($arr);die;

            }

        }else{

            include template('passzhi');

        }

        

    }

   /**

    * 修改交易密码

    * @return [type] [description]

    */

    public function repinpass(){

        if(IS_POST){

            $param = $_POST;

            $param['pinpass'] = intval($param['pinpass']);

            if (empty($param['mobi_code'])) showmessage('验证码不能为空');

            if (empty($param['pinpass'])) showmessage('交易密码不能为空');

            if($param['pinpass']===0)  showmessage('交易密码为6位数字');

            if( $param['mobi_code'] != $_SESSION["reg_code"]){

                showmessage('验证码错误');

            }

            session("reg_code",null);

            session("verify",null);

            $data = array();

            $data['id'] = $this->userinfo['id'];

            $data['pinpass'] = md5($param['pinpass']);

            $rut = M("user")->save($data);

            if($rut) showmessage('交易密码已经成功更改！',"",1);

            showmessage('交易密码失败！');

        }

        $_SESSION["send_code_time"]=random(10);

        $SEO=seo(0,"修改交易密码");

        include template('repinpass');

    }

   /**

    * 

    * 头像设置 展示页面

    * @author wj

    * @date 2014-10-15

    */

   public function avatar(){

    die;

    $userInfoList = getUserInfo($this->userid);//获取用户详细信息

    $ico = $userInfoList['ico'];

    $SEO=seo(0,"个人头像信息");

    include template('avatar');

   }

    /**

    * 

    * 头像设置 修改

    * @author wj

    * @date 2014-10-15

    */

   public function editAvatar(){

        $id = $_GET('id');

        if (empty($id)){

            showmessage('头像设置失败！');

        }

        $userInfoList = getUserInfo($id);//获取用户详细信息

        if(!empty($userInfoList['ico'])){

            showmessage('头像设置成功！','',1);

        }

        $map['id'] = array('eq',$userInfoList['id']);

        $data['ico'] = '/uploadfile/avatar/'.$userInfoList['id'].'_200.jpg';

        $res = model('User')->where($map)->save($data);

        if ($res>0){

            showmessage('头像设置成功！','',1);

        }else{

           showmessage('头像设置失败！','',1);

        }

   }

    /**

    * 

    * 修改电话 [wap]

    * @author  xvzhonglin

    * @date 2015-4-28

    */  

    public function update_phone() {

        if (IS_POST) {

            $update_phone = $_GET['update_phone'];

            if(preg_match('#^13[\d]{9}$|14^[0-9]\d{8}|^15[0-9]\d{8}$|^18[0-9]\d{8}$#', $update_phone))

                {

                $result = $this->db->where(array('id' => $this->userid))->setField('mobile_phone',$update_phone);

                if (!result) showmessage('请输入正确的手机号');

                showmessage('手机号码修改成功',U('User/User/userinfo'),1);

                } else {

                $mobile_phone = $this->db->getFieldById($this->userid,'mobile_phone');

                showmessage('请输入正确的手机号',U('User/User/update_phone'));

                }

                }else{

        include template ('update_phone');

        }       

    }

}