<?php

// +----------------------------------------------------------------------

// | ThinkPHP [ WE CAN DO IT JUST THINK IT ]

// +----------------------------------------------------------------------

// | Copyright (c) 2006-2012 http://thinkphp.cn All rights reserved.

// +----------------------------------------------------------------------

// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )

// +----------------------------------------------------------------------

// | Author: liu21st <liu21st@gmail.com>

// +----------------------------------------------------------------------



/**

 * Think 命令行模式公共函数库

 * @category   Think

 * @package  Common

 * @author   liu21st <liu21st@gmail.com>

 */



// 错误输出

function halt($error) {

    exit($error);

}



// 自定义异常处理

function throw_exception($msg, $type='ThinkException', $code=0) {

    halt($msg);

}



// 浏览器友好的变量输出

function dump($var, $echo=true, $label=null, $strict=true) {

    $label = ($label === null) ? '' : rtrim($label) . ' ';

    if (!$strict) {

        if (ini_get('html_errors')) {

            $output = print_r($var, true);

            $output = "<pre>" . $label . htmlspecialchars($output, ENT_QUOTES) . "</pre>";

        } else {

            $output = $label . print_r($var, true);

        }

    } else {

        ob_start();

        var_dump($var);

        $output = ob_get_clean();

        if (!extension_loaded('xdebug')) {

            $output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);

            $output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';

        }

    }

    if ($echo) {

        echo($output);

        return null;

    }else

        return $output;

}



 // 区间调试开始

function debug_start($label='') {

    $GLOBALS[$label]['_beginTime'] = microtime(TRUE);

    if (MEMORY_LIMIT_ON)

        $GLOBALS[$label]['_beginMem'] = memory_get_usage();

}



// 区间调试结束，显示指定标记到当前位置的调试

function debug_end($label='') {

    $GLOBALS[$label]['_endTime'] = microtime(TRUE);

    echo '<div style="text-align:center;width:100%">Process ' . $label . ': Times ' . number_format($GLOBALS[$label]['_endTime'] - $GLOBALS[$label]['_beginTime'], 6) . 's ';

    if (MEMORY_LIMIT_ON) {

        $GLOBALS[$label]['_endMem'] = memory_get_usage();

        echo ' Memories ' . number_format(($GLOBALS[$label]['_endMem'] - $GLOBALS[$label]['_beginMem']) / 1024) . ' k';

    }

    echo '</div>';

}



// 全局缓存设置和读取

function S($name, $value='', $expire='', $type='',$options=null) {

    static $_cache = array();

    alias_import('Cache');

    //取得缓存对象实例

    $cache = Cache::getInstance($type,$options);

    if ('' !== $value) {

        if (is_null($value)) {

            // 删除缓存

            $result = $cache->rm($name);

            if ($result)

                unset($_cache[$type . '_' . $name]);

            return $result;

        }else {

            // 缓存数据

            $cache->set($name, $value, $expire);

            $_cache[$type . '_' . $name] = $value;

        }

        return;

    }

    if (isset($_cache[$type . '_' . $name]))

        return $_cache[$type . '_' . $name];

    // 获取缓存数据

    $value = $cache->get($name);

    $_cache[$type . '_' . $name] = $value;

    return $value;

}



// 快速文件数据读取和保存 针对简单类型数据 字符串、数组

function F($name, $value='', $path=DATA_PATH) {

    static $_cache = array();

    $filename = $path . $name . '.php';

    if ('' !== $value) {

        if (is_null($value)) {

            // 删除缓存

            return unlink($filename);

        } else {

            // 缓存数据

            $dir = dirname($filename);

            // 目录不存在则创建

            if (!is_dir($dir))

                mkdir($dir);

            return file_put_contents($filename, strip_whitespace("<?php\nreturn " . var_export($value, true) . ";\n?>"));

        }

    }

    if (isset($_cache[$name]))

        return $_cache[$name];

    // 获取缓存数据

    if (is_file($filename)) {

        $value = include $filename;

        $_cache[$name] = $value;

    } else {

        $value = false;

    }

    return $value;

}



// 取得对象实例 支持调用类的静态方法

function get_instance_of($name, $method='', $args=array()) {

    static $_instance = array();

    $identify = empty($args) ? $name . $method : $name . $method . to_guid_string($args);

    if (!isset($_instance[$identify])) {

        if (class_exists($name)) {

            $o = new $name();

            if (method_exists($o, $method)) {

                if (!empty($args)) {

                    $_instance[$identify] = call_user_func_array(array(&$o, $method), $args);

                } else {

                    $_instance[$identify] = $o->$method();

                }

            }

            else

                $_instance[$identify] = $o;

        }

        else

            halt(L('_CLASS_NOT_EXIST_') . ':' . $name);

    }

    return $_instance[$identify];

}



// 根据PHP各种类型变量生成唯一标识号

function to_guid_string($mix) {

    if (is_object($mix) && function_exists('spl_object_hash')) {

        return spl_object_hash($mix);

    } elseif (is_resource($mix)) {

        $mix = get_resource_type($mix) . strval($mix);

    } else {

        $mix = serialize($mix);

    }

    return md5($mix);

}



// 加载扩展配置文件

function load_ext_file() {

    // 加载自定义外部文件

    if(C('LOAD_EXT_FILE')) {

        $files =  explode(',',C('LOAD_EXT_FILE'));

        foreach ($files as $file){

            $file   = COMMON_PATH.$file.'.php';

            if(is_file($file)) include $file;

        }

    }

    // 加载自定义的动态配置文件

    if(C('LOAD_EXT_CONFIG')) {

        $configs =  C('LOAD_EXT_CONFIG');

        if(is_string($configs)) $configs =  explode(',',$configs);

        foreach ($configs as $key=>$config){

            $file   = CONF_PATH.$config.'.php';

            if(is_file($file)) {

                is_numeric($key)?C(include $file):C($key,include $file);

            }

        }

    }

}