<?php

/**

 *      [Jsen.net] (C)2013-2099 Jason Group Science and technology co., LTD.

 *      This is NOT a freeware, use is subject to license terms

 *

 *      http://www.jsen.net

 *      tel:400-681-9511

 */

libfile('pay_abstract');

class allinpay extends pay_abstract {

	public function __construct($config = array()) {	

		if (!empty($config)) $this->set_config($config);        

		$this->config['gateway_url'] = 'http://ceshi.allinpay.com/gateway/index.do?';

		$this->config['gateway_method'] = 'POST';

		$this->config['notify_url'] = return_url('allinpay', 'notify');

		$this->config['return_url'] = return_url('allinpay', 'return');

	}



	public function getpreparedata() {

		$prepare_data['inputCharset'] = 1;

		$prepare_data['pickupUrl'] = $this->config['return_url']; //$this->product_info['trade_sn'];

		$prepare_data['receiveUrl'] = $this->config['notify_url'];//$this->product_info['total_fee'];

		$prepare_data['version'] ="v1.0";

		$prepare_data['language'] = "1";             

		$prepare_data['signType'] = 1;

		$prepare_data['merchantId'] = $this->config['account'];//$this->getSign( "ecpss", $prepare_data);		

		$prepare_data['payerName'] = "";

		$prepare_data['payerEmail'] = "";

		$prepare_data['payerTelephone'] = "";

		$prepare_data['payerIDCard'] = "";

		$prepare_data['pid'] = "";

		$prepare_data['orderNo'] = $this->product_info['trade_sn'];

		$prepare_data['orderAmount'] = $this->product_info['total_fee']*100;

		$prepare_data['orderCurrency'] = "0";

		$prepare_data['orderDatetime'] = date("YmdHis",time());

		$prepare_data['orderExpireDatetime'] = "";

		$prepare_data['productName'] = "";

		$prepare_data['productPrice'] = "";

		$prepare_data['productNum'] = "";

		$prepare_data['productId'] = "";

		$prepare_data['productDesc'] = "";

		$prepare_data['ext1'] = "";

		$prepare_data['ext2'] = "";

		$prepare_data['extTL'] = "";

		$prepare_data['payType'] = 0;

		$prepare_data['issuerId'] = "";

		$prepare_data['pan'] = "";

		$prepare_data['tradeNature'] = "";

		$prepare_data['customsExt'] = "";

		$prepare_data['signMsg'] = $this->getSign( "allinpay", $prepare_data);

		

		return $prepare_data;

	}



	public function _delivery() {

		return TRUE;

	}

    

    public function _return() {

        $MD5key = $this->config['merchantId'];

		$version = "v1.0";

		$signType=1;

		$paymentOrderId=$_REQUEST["paymentOrderId"];

		$orderNo=$_REQUEST["orderNo"];

		$orderDatetime=$_REQUEST["orderDatetime"];

		$orderAmount=$_REQUEST["orderAmount"];

		$payDatetime=$_REQUEST["payDatetime"];

		$payAmount=$_REQUEST["payAmount"];

		$payResult=$_REQUEST["payResult"];

		$returnDatetime=$_REQUEST["returnDatetime"];

		//订单号

		$BillNo = $_REQUEST["orderNo"];

		//金额

		$Amount = $_REQUEST["orderAmount"]/100;

		//支付状态

		$Succeed = $_REQUEST["Succeed"];

		//支付结果

		$Result = $_REQUEST["Result"];

		//取得的MD5校验信息

		$SignMD5info = $_REQUEST["SignMD5info"]; 

		//备注

		$Remark = $_REQUEST["Remark"];

		//校验源字符串

	  	$md5src = $BillNo."&".$Amount."&".$Succeed."&".$MD5key;

	  //MD5检验结果

		$md5sign = strtoupper(md5($md5src));

		//$SignMD5info=$md5sign=1;

        if ($payResult==1){

			$result['result'] = 'success';

            $result['pay_code'] = 'allinpay';

            $result['trade_no'] = $_REQUEST['paymentOrderId'];

            $result['out_trade_no'] = $_REQUEST['orderNo'];

            return $result;

        } else {

            return false;

        }

    }

    /**

	 * POST接收数据

	 * 状态码说明  （0 交易完成 1 待付款 2 待发货 3 待收货 4 交易关闭 5交易取消

	 */

    public function _notify() {

        return $this->_return();

    }

	

    private function getSign($type,$data){

        $signarray=array('inputCharset','pickupUrl','receiveUrl','version','language','signType','merchantId','orderNo','orderAmount','orderCurrency','orderDatetime','payType');//校验源字符串

		foreach($signarray as $v){

			if(!isset($data[$v])) $md5str .= "";

			else $md5str .= '&'.$v."=$data[$v]";

		}

		$md5str.='&key='.$this->config['partner'];//MD5密钥

		$md5str = trim($md5str,'&');	

		

		$md5str = strtoupper(md5($md5str));

		return $md5str;

    }

		

    /**

     * 相应服务器应答状态

     * @param $result

     */

    public function response($result) {

    	if (FALSE == $result) echo '';

		else echo 'success';

    }

    

    /**

     * 返回字符过滤

     * @param $parameter

     */

    private function filterParameter($parameter)

    {

        $para = array();

        foreach ($parameter as $key => $value) {

            if ('sign' == $key || 'sign_type' == $key || '' == $value || 'm' == $key  || 'a' == $key  || 'c' == $key   || 'code' == $key || 'method' == $key || 'page' == $key) continue;

            else $para[$key] = $value;

        }

        return $para;

    }

    public function getCodeUrl(){

    	

    }

}