<?php

/**

 *      咨询模型

 *      [Jsen.net] (C)2013-2099 Jason Group Science and technology co., LTD.

 *      This is NOT a freeware, use is subject to license terms

 *

 *      http://www.jsen.net

 *      tel:400-681-9511

 */

class PayModel extends Model {

    protected $_validate = array(

        array('trade_sn','require','订单号不能为空', Model::EXISTS_VALIDATE, 'regex', Model:: MODEL_INSERT), 

        array('goods_id','require','咨询商品不能为空！', Model::EXISTS_VALIDATE, 'regex', Model:: MODEL_BOTH), 

    );



    protected $_auto = array(

        array('status', '0', 'string', Model:: MODEL_INSERT), 

        array('dateline', NOW_TIME, 'string', Model:: MODEL_INSERT),

    );





    public function update($data, $iscreate = TRUE) {       

        if ($iscreate == TRUE) $data = $this->create($data);

        if (empty($data)) {

            $this->error = $this->getError();

            return false;

        }

        if (isset($data['id']) && is_numeric($data['id'])) {

            $result = $this->save($data);

            if (!$result) {

                $this->error = '更新数据失败';

                return false;

            }

        } else {

            $result = $this->add($data);

            if ($result === false) {

                $this->error = '添加数据失败';

                return false;

            }

        }

        return $result;

    }

	

	public function lists() {

    	$sqlmap = array();

    	if ($_GET['keyword']) {

            $sqlmap['a.trade_sn'] = trim($_GET['keyword']);

    	}

		  if ($_GET['uesrname']) {

            $sqlmap['u.username'] = trim($_GET['uesrname']);

        }

		if($_GET["start"]!="" or $_GET["end"]!=""){

				$start = strtotime($_GET['start'].' 00:00:00');

				$end = strtotime($_GET['end'].' 23:59:59');

				$sqlmap['a.dateline'] =array('between',$start.','.$end);

			}

			

			if ($_GET["status"]!="") {

				$sqlmap['a.status'] = $_GET["status"]-1;

			}

			if ($_REQUEST["paytype"]!="") {

				$sqlmap['a.code'] = $_REQUEST["paytype"];

			}

			//p($sqlmap);

		$field = "a.*,u.username,u.true_name,u.freeze_money,u.pay_points,u.user_money";

    	$infos = M("pay a")->field($field)->where($sqlmap)->join(" LEFT JOIN  __USER__ as u ON a.user_id=u.id")->order('a.id DESC')->limit(($_GET['pagenum']-1)*$_GET['rowsnum'].','.$_GET['rowsnum'])->select();

    	//p($infos);

    	return $infos;

    }

}