<?php

/**

 *      文章列表标签

 *      [Jsen.net] (C)2013-2099 Jason Group Science and technology co., LTD.

 *      This is NOT a freeware, use is subject to license terms

 *

 *      http://www.jsen.net

 *      tel:400-681-9511

 */

class union{

	function __construct() {

		$this->db = D('Union');

	}



	/* 获取总数 */

	public function count($attr) {

		return $this->db->where($this->build_map($attr))->count();

	}



	/* 列表方法 */

	public function lists($attr){

		extract($attr);		

		$order = (!empty($order)) ? $order : " u.id DESC";

		/* 是否开启分页 */

		if (isset($page)) {

			D('Union u')->page($page, $limit);

		} else {

			D('Union u')->limit($limit);

		}

		

		$join = " LEFT JOIN `__REGION__` as b ON u.province=b.area_id";

		$join.= " LEFT JOIN `__REGION__` as c ON u.city=c.area_id";

		$join.= " LEFT JOIN `__REGION__` as d ON u.district=d.area_id";	

		$join.= " LEFT JOIN `__UNION_TYPE__` as t ON u.fenlei=t.id";	

		//"LEFT JOIN __UNION_TYPE__ t on t.id=u.fenlei"

		$arr=D('Union u')->join($join)->field("u.*,t.type_name,b.area_name as prov_name,c.area_name as city_name,d.area_name as dist_name")->where($this->build_map($attr))->order($order)->select();

		//echo D('Union u')->getlastsql();

		//p($arr);

		return $arr;

	}

	/* 列表方法 */

	public function type($attr){

		extract($attr);		

		$order = (!empty($order)) ? $order : "`id` asc";

		if (isset($page)) {

			M('union_type')->page($page, $limit);

		} else {

			M('union_type')->limit($limit);

		}

		return M("union_type")->where($this->build_map($attr))->order($order)->select();

	}

	/* 获取SQL查询语句 */

	private function build_map($data) {

		//extract($attr);

		/* 已审核 */

		//p($_GET);

		

		if($data["fenlei"]!="" and $data["fenlei"]!=-1){

			$sqlmap["u.fenlei"]=$data["fenlei"];	

		}

		if($data["tuijian"]!=""){

			$sqlmap["u.tuijian"]=$data["tuijian"];	

		}

		if($data["province"]!="" and $data["province"]!=-1){

			$sqlmap["u.province"]=$data["province"];	

		}

		if($data["city"]!="" and $data["city"]!=-1){

			$sqlmap["u.city"]=$data["city"];	

		}

		if($data["district"]!="" and $data["district"]!=-1){

			$sqlmap["u.district"]=$data["district"];	

		}

		if($data["title"]!=""){

			$sqlmap["u.company_name"]=array('like','%'.$data["title"].'%');	

		}

		if($data["page"]>0){

			if($_GET["fenlei"]!="" and $_GET["fenlei"]!=-1){

				$sqlmap["u.fenlei"]=$_GET["fenlei"];	

			}

			if($_GET["province"]!="" and $_GET["province"]!=-1){

				$sqlmap["u.province"]=$_GET["province"];	

			}

			if($_GET["city"]!="" and $_GET["city"]!=-1){

				$sqlmap["u.city"]=$_GET["city"];	

			}

			if($_GET["district"]!="" and $_GET["district"]!=-1){

				$sqlmap["u.district"]=$_GET["district"];	

			}

			if($_GET["title"]!=""){

				$sqlmap["u.company_name"]=array('like','%'.$_GET["title"].'%');	

			}

		}

		if ($where) $sqlmap['_string'] = $where;

		return $sqlmap;

	}

}