<!DOCTYPE html>
<html>
	<?php echo $this->fetch('head.html'); ?>
	<body>
		<div class="header">
			<div class="header-back"></div>
			<div class="header-title">我的订单</div>
		</div>
		<div class="header-row"></div>
		<div class="main-body">
			<div id="app" style="display: none;">
				<div class="tabs-border">
					<div @click="setType('all')" v-bind:class="{'tabs-border-active':type=='all'}" class="tabs-border-item ">全部</div>
					<div @click="setType('unpay')"  v-bind:class="{'tabs-border-active':type=='unpay'}" class="tabs-border-item">待付款</div>
					<div @click="setType('unpin')"  v-bind:class="{'tabs-border-active':type=='unpin'}" class="tabs-border-item">待成团</div>
					<div @click="setType('unsend')"  v-bind:class="{'tabs-border-active':type=='unsend'}" class="tabs-border-item">待发货</div>
					<div @click="setType('unreceive')"  v-bind:class="{'tabs-border-active':type=='unreceive'}" class="tabs-border-item">待收货</div>
					<div @click="setType('unraty')"  v-bind:class="{'tabs-border-active':type=='unraty'}" class="tabs-border-item">待评价</div>
				</div>
				<div class="item row-box mgb-10" v-for="(item,index) in list" :key="index">
					<div class="flex bd-mp-5">
						<div v-if="item.ispin==1" class="mgr-5"><div class="btn-pin-cycle">拼</div></div>
						<div class="flex-1 cl2">订单号：{{item.orderno}}</div>
						
						<div class="cl-primary">{{item.status_name}}</div>
					</div>
					<div class="flexlist-item" v-for="(pro,proIndex) in item.prolist" :key="proIndex">
						<img class="flexlist-img" :src="pro.imgurl+'.100x100.jpg'">
						<div class="flex-1">
							<div class="flexlist-title">{{pro.title}}</div>
							<div class="flexlist-ks">{{pro.ks_title}}</div>
							<div class="flex ">
								<div class="flex-1 cl-money">￥{{pro.price}}</div>
								<div class="cl3">x {{pro.amount}}</div>
							</div>
							
						</div>
					</div>
					 
					<div class="flex mgb-5">
						 共<div class="cl-num">{{item.total_num}}</div>件商品  
						 订单金额：<div class="cl-money">￥{{item.money}}</div>元
						 
						 <div class="flex-1"></div> 
						 
					</div>
					 
					<div v-if="item.status==0" class="flex flex-jc-end">
						<div class="cl3 f12">{{item.timeago}}</div>
						<div class="flex-1"></div>
						
						<div @click="pay(item.orderid)" v-if="item.ispay==0" class="btn-small btn-outline-danger mgr-10">去支付</div>
						<view class="btn-small btn-outline-success mgr-5" @click="goPin(item.orderid)" v-else-if="item.ispin && item.pin_success==0">邀请拼团</view>
						<div class="btn-small  btn-outline-danger" @click="goOrder(item.orderid)">查看详情</div>
					</div>
					<div v-else-if="item.status==1" class="flex flex-jc-end">
						<div class="cl3 f12">{{item.timeago}}</div>
						<div class="flex-1"></div>
						<div class="btn-small  btn-outline-danger" @click="goOrder(item.orderid)">查看详情</div>
					</div>
					<div v-else-if="item.status==2" class="flex flex-jc-end">
						<div class="cl3 f12">{{item.timeago}}</div>
						<div class="flex-1"></div>
						<div class="btn-small  btn-outline-danger" @click="goOrder(item.orderid)">查看详情</div>
					</div>
					<div v-else-if="item.status==3" class="flex flex-jc-end">
						<div class="cl3 f12">{{item.timeago}}</div>
						<div class="flex-1"></div>
						<div class="btn-small  btn-outline-danger" @click="goOrder(item.orderid)">查看详情</div>
					</div>	
				</div>
				<div class="loadMore" @click="getList" v-if="per_page>0">加载更多</div>
			</div>
		</div>
		<?php $this->assign('ftnav','household_order'); ?>
		<?php echo $this->fetch('ftnav.html'); ?>
		<?php echo $this->fetch('footer.html'); ?>
		<script>
			var type="<?php echo $this->_var['type']; ?>";
		</script>
		<script src="<?php echo $this->_var['skins']; ?>household_order/my.js"></script>
	</body>
</html>
