<?php
require 'common.php';

@header('Content-Type: text/html; charset=UTF-8');

$trade_no=daddslashes($_GET['trade_no']);
if($conf['alipay_api']!=3)exit('当前支付接口未开启');
$row=$DB->query("SELECT * FROM `wcms_order` WHERE `order_no`='{$trade_no}' limit 1")->fetch();

if(!$row)exit('该订单号不存在，请返回来源地重新发起请求！');

require_once(SYSTEM_ROOT."f2fpay/model/builder/AlipayTradePrecreateContentBuilder.php");
require_once(SYSTEM_ROOT."f2fpay/AlipayTradeService.php");

// 创建请求builder，设置请求参数
$qrPayRequestBuilder = new AlipayTradePrecreateContentBuilder();
$qrPayRequestBuilder->setOutTradeNo($trade_no);
$qrPayRequestBuilder->setTotalAmount($row['money']);
$qrPayRequestBuilder->setSubject($row['name']);
// 调用qrPay方法获取当面付应答
$qrPay = new AlipayTradeService($config);
//var_dump($qrPay->query($qrPayRequestBuilder)); ;exit;
$qrPayResult = $qrPay->qrPay($qrPayRequestBuilder);
//	根据状态值进行业务处理
$status = $qrPayResult->getTradeStatus();
$response = $qrPayResult->getResponse();

if($status == 'SUCCESS'){
	$code_url = $response->qr_code;
}elseif($status == 'FAILED'){
	sysmsg('支付宝创建订单二维码失败！['.$response->sub_code.']'.$response->sub_msg);
}else{
	print_r($response);
	sysmsg('系统异常，状态未知！');
}

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Language" content="zh-cn">
<meta name="renderer" content="webkit">
<title>支付宝扫码支付 - <?php echo $conf['web_name']?></title>
<link href="assets/css/alipay_pay.css" rel="stylesheet" media="screen">
</head>
<body>
<div class="body">
<h1 class="mod-title">
<span class="ico-wechat"></span><span class="text">支付宝扫码支付</span>
</h1>
<div class="mod-ct">
<div class="order">
</div>
<div class="amount">￥<?php echo $row['money']?></div>
<div class="qr-image" id="qrcode">
</div>
 
<div class="detail" id="orderDetail">
<dl class="detail-ct" style="display: none;">
<dt>购买物品</dt>
<dd id="productName"><?php echo $row['name']?></dd>
<dt>商户订单号</dt>
<dd id="billId"><?php echo $row['order_no']?></dd>
<dt>创建时间</dt>
<dd id="createTime"><?php echo $row['date']?></dd>
</dl>
<a href="javascript:void(0)" class="arrow"><i class="ico-arrow"></i></a>
</div>
<div class="tip">
<span class="dec dec-left"></span>
<span class="dec dec-right"></span>
<div class="ico-scan"></div>
<div class="tip-text">
<p>请使用支付宝扫一扫</p>
<p>扫描二维码完成支付</p>
</div>
</div>
<div class="tip-text">
</div>
</div>
<div class="foot">
<div class="inner">
<div id="J_downloadInteraction" class="download-interaction download-interaction-opening">
	<div class="inner-interaction">
		<p class="download-opening">正在打开支付宝<span class="download-opening-1">.</span><span class="download-opening-2">.</span><span class="download-opening-3">.</span></p>
		<p class="download-asking">如果没有打开支付宝，<a id="J_downloadBtn" href="javascript:;" onclick="openAli();">请点此重新唤起</a></p>
</div>
</div>
</div>
</div>
<script src="//cdn.staticfile.org/jquery/1.12.4/jquery.min.js"></script>
<script src="//cdn.staticfile.org/jquery.qrcode/1.0/jquery.qrcode.min.js"></script>
<script>
	var code_url = '<?php echo $code_url?>';
    $('#qrcode').qrcode({
        text: code_url,
        width: 230,
        height: 230,
        foreground: "#000000",
        background: "#ffffff",
        typeNumber: -1
    });
    // 订单详情
    $('#orderDetail .arrow').click(function (event) {
        if ($('#orderDetail').hasClass('detail-open')) {
            $('#orderDetail .detail-ct').slideUp(500, function () {
                $('#orderDetail').removeClass('detail-open');
            });
        } else {
            $('#orderDetail .detail-ct').slideDown(500, function () {
                $('#orderDetail').addClass('detail-open');
            });
        }
    });
    // 检查是否支付完成
    function loadmsg() {
        $.ajax({
            type: "GET",
            dataType: "json",
            url: "getshop.php",
            timeout: 10000, //ajax请求超时时间10s
            data: {type: "wxpay", trade_no: "<?php echo $row['order_no']?>"}, //post数据
            success: function (data, textStatus) {
                //从服务器得到数据，显示数据并继续查询
                if (data.code == 1) {
					if (confirm("您已支付完成，需要跳转到订单页面吗？")) {
                        window.location.href=data.backurl;
                    } else {
                        // 用户取消
                    }
                }else{
                    setTimeout("loadmsg()", 4000);
                }
            },
            //Ajax请求超时，继续查询
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                if (textStatus == "timeout") {
                    setTimeout("loadmsg()", 1000);
                } else { //异常
                    setTimeout("loadmsg()", 4000);
                }
            }
        });
    }


    function openAli(){
        var scheme = 'alipays://platformapi/startapp?saId=10000007&qrcode=';
        scheme += encodeURIComponent(code_url);

        if(navigator.userAgent.indexOf("Safari") > -1){
            window.location.href = scheme;
        }
        else{
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            iframe.src = scheme;
            document.body.appendChild(iframe);
        }
    }
    window.onload = function(){
        openAli();
        setTimeout("loadmsg()", 2000);
    }
</script>
</body>
</html>
    <script type="text/javascript">
        (function () {
            var schemeParam = 'saId=10000007&amp;clientVersion=3.7.0.0718&amp;qrcode='+code_url+'?_s=web-other';
            schemeParam = schemeParam.replace(/&amp;/ig, '&');


            if (!location.hash) {
                AlipayWallet.open({
                    params: schemeParam,
                    jumpUrl: '',
                    openAppStore: false
                });
            }



            function pageFuntion() {
                var interactionNode = document.getElementById('J_downloadInteraction');
                setTimeout(function () {
                    interactionNode.className = "download-interaction download-interaction-asking";
                }, 3000);
            }

            if (/complete|loaded|interactive/.test(document.readyState && document.body)) {
                pageFuntion();
            } else {
                document.addEventListener('DOMContentLoaded', function () {
                    pageFuntion();
                }, true);
            }
        })();
        function openAli()
        {
            var scheme = 'alipays://platformapi/startapp?saId=10000007&qrcode=';
            scheme += encodeURIComponent(code_url);

            if(navigator.userAgent.indexOf("Safari") > -1){
                window.location.href = scheme;
            }
            else{
                var iframe = document.createElement("iframe");
                iframe.style.display = "none";
                iframe.src = scheme;
                document.body.appendChild(iframe);
            }
        }
    </script>
</body>
</html>