<?php
/**
 * Defines customizer options
 *
 * @package Customizer Library Demo
 */

function customizer_library_demo_options() {

	// Theme defaults
	$primary_color = '#0099e5';
	$secondary_color = '#ff5a00';
	$mobile_color = '#0099e5';
	$header_color = '#3d4557';
	$footer_color = '#3d4557';	
	// Stores all the controls that will be added
	$options = array();

	// Stores all the sections to be added
	$sections = array();

	// Stores all the panels to be added
	$panels = array();

	// Adds the sections to the $options array
	$options['sections'] = $sections;


	// Arrays 

	$site_layout_choices = array(
		'choice-1' => '自适应布局（完美兼容电脑和移动设备）',
		'choice-2' => '固定布局（只适合PC电脑浏览）'
	);

	$latest_style_choices = array(
		'choice-1' => '最新文章',
		'choice-2' => '热点文章'
	);	

	$ad_position_choices = array(
		'1','2', '3','4','5','6','7','8','9','10'													
	);

	$menu_column_choices = array(
		'choice-0' => '自适应宽度',		
		'choice-1' => '1列',
		'choice-2' => '2列',
		'choice-3' => '3列',
		'choice-4' => '4列',
		'choice-5' => '5列',
		'choice-6' => '6列',
		'choice-7' => '7列',
		'choice-8' => '8列'							
	);

	/* General */
	$section = 'general';

	$sections[] = array(
		'id' => $section,
		'title' => __( '主题常规设置', 'daohang' ),
		'priority' => '10'
	);

	$options['site-layout'] = array(
		'id' => 'site-layout',
		'label'   => __( '网站布局', 'daohang' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $site_layout_choices,
		'default' => 'choice-1'
	);

	$options['tablet-columns'] = array(
		'id' => 'tablet-columns',
		'label'   => __( '主菜单链接固定宽度 (平板)', 'daohang' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $menu_column_choices,
		'default' => 'choice-6',
	);	

	$options['phone-columns'] = array(
		'id' => 'phone-columns',
		'label'   => __( '主菜单链接固定宽度 (手机)', 'daohang' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $menu_column_choices,
		'default' => 'choice-4',
	);		

	$options['no-category-base-on'] = array(
		'id' => 'no-category-base-on',
		'label'   => __( '移除文章分类目录/category/链接', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => false,
	);

	$options['close-comments-on'] = array(
		'id' => 'close-comments-on',
		'label'   => __( '关闭全站文章评论', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => false,
	);	
	
	$options['header-day-on'] = array(
		'id' => 'header-day-on',
		'label'   => __( '在网站头部显示星期', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-date-on'] = array(
		'id' => 'header-date-on',
		'label'   => __( '在网站头部显示日期', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-login-on'] = array(
		'id' => 'header-login-on',
		'label'   => __( '在网站头部显示登录链接', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-reg-on'] = array(
		'id' => 'header-reg-on',
		'label'   => __( '在网站头部显示注册链接', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-search-on'] = array(
		'id' => 'header-search-on',
		'label'   => __( '在网站头部显示百度搜索框', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['header-mobile-on'] = array(
		'id' => 'header-mobile-on',
		'label'   => __( '在网站头部显示网站地址二维码', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-weixin-on'] = array(
		'id' => 'header-weixin-on',
		'label'   => __( '在网站头部显示微信二维码', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['header-weibo-on'] = array(
		'id' => 'header-weibo-on',
		'label'   => __( '在网站头部显示微博链接', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);		

	$options['site-desc-on'] = array(
		'id' => 'site-desc-on',
		'label'   => __( '在网站图标旁显示自定义副标题', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['header-slogan1'] = array(
		'id' => 'header-slogan1',
		'label'   => __( '自定义副标题 1', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '网址导航主题',
	);	

	$options['header-slogan2'] = array(
		'id' => 'header-slogan2',
		'label'   => __( '自定义副标题 2', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '新一代网站模版',
	);	

	$options['back-top-on'] = array(
		'id' => 'back-top-on',
		'label'   => __( '在网站底部右侧显示“返回顶部”按钮', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 1,
	);

	$options['site-url-qrcode'] = array(
		'id' => 'site-url-qrcode',
		'label'   => __( '网站地址二维码图片', 'daohang' ),
		'section' => $section,
		'type'    => 'image',
		'default' => get_template_directory_uri() . '/assets/img/site-url-qrcode.png'
	);

	$options['weixin-qrcode'] = array(
		'id' => 'weixin-qrcode',
		'label'   => __( '微信号二维码图片', 'daohang' ),
		'section' => $section,
		'type'    => 'image',
		'default' => get_template_directory_uri() . '/assets/img/weixin-qrcode.png'
	);

	$options['weibo-url'] = array(
		'id' => 'weibo-url',
		'label'   => __( '新浪微博地址', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => 'https://weibo.com/zhutibaba'
	);		

	$options['footer-credit'] = array(
		'id' => 'footer-credit',
		'label'   => __( '网站底部版权信息/链接', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => '&copy; ' . date("o") . ' <a href="' . home_url() .'">' . get_bloginfo('name') . '</a> - 某某导航网<a href="#" target="_blank">WordPress主题</a> &bullet; <a href="http://www.beian.miit.gov.cn/">京ICP备11111111号-1</a>'
	);	

	/* Color */
	$section = 'color';

	$sections[] = array(
		'id' => $section,
		'title' => __( '主题颜色设置', 'daohang' ),
		'priority' => '10'
	);	

	$options['primary-color'] = array(
		'id' => 'primary-color',
		'label'   => __( '主题配色一', 'daohang' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $primary_color // hex
	);

	$options['secondary-color'] = array(
		'id' => 'secondary-color',
		'label'   => __( '主题配色二', 'daohang' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $secondary_color // hex
	);
	$options['header-color'] = array(
		'id' => 'header-color',
		'label'   => __( '顶部导航栏背景颜色', 'daohang' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $header_color // hex
	);
	$options['footer-color'] = array(
		'id' => 'footer-color',
		'label'   => __( '网站底部区域背景颜色', 'daohang' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $footer_color // hex
	);	
	$options['mobile-color'] = array(
		'id' => 'mobile-color',
		'label'   => __( '移动端导航菜单颜色', 'daohang' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $mobile_color // hex
	);
	/* Home */

	$section = 'home';
	
	$sections[] = array(
		'id' => $section,
		'title' => __( '网站首页设置', 'daohang' ),
		'priority' => '10'
	);		

	$options['home-friend-title'] = array(
		'id' => 'home-friend-title',
		'label'   => __( '首页友情链接标题', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '友情链接'
	);						

	/* Archive */

	$section = 'archive';
	
	$sections[] = array(
		'id' => $section,
		'title' => __( '文章列表设置', 'daohang' ),
		'priority' => '10'
	);

	$options['pagination-style'] = array(
		'id' => 'pagination-style',
		'label'   => __( '文章列表分页样式', 'daohang' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $pagination_style_choices,
		'default' => 'choice-1'
	);
	
	$options['loop-featured-on'] = array(
		'id' => 'loop-featured-on',
		'label'   => __( '在文章列表显示特色图片', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['loop-default-thumb-on'] = array(
		'id' => 'loop-default-thumb-on',
		'label'   => __( '在文章列表显示随机缩略图 (文章无图时)', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['loop-excerpt-on'] = array(
		'id' => 'loop-excerpt-on',
		'label'   => __( '在文章列表显示文章摘要', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['loop-excerpt-length'] = array(
		'id' => 'loop-excerpt-length',
		'label'   => __( '文章列表自动获取摘要字数', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '55'
	);

	$options['loop-category-on'] = array(
		'id' => 'loop-category-on',
		'label'   => __( '在文章列表显示文章所属分类目录', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);


	$options['loop-author-avatar-on'] = array(
		'id' => 'loop-author-avatar-on',
		'label'   => __( '在文章列表显示作者头像', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => false,
	);

	$options['loop-author-name-on'] = array(
		'id' => 'loop-author-name-on',
		'label'   => __( '在文章列表显示作者名字', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => false,
	);	

	$options['loop-date-on'] = array(
		'id' => 'loop-date-on',
		'label'   => __( '在文章列表显示文章发布时间', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['loop-view-on'] = array(
		'id' => 'loop-view-on',
		'label'   => __( '在文章列表显示浏览数', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['loop-comment-on'] = array(
		'id' => 'loop-comment-on',
		'label'   => __( '在文章列表显示评论数', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	/* Single */

	$section = 'single';
	
	$sections[] = array(
		'id' => $section,
		'title' => __( '文章页面设置', 'daohang' ),
		'priority' => '10'
	);

	$options['single-indent-on'] = array(
		'id' => 'single-indent-on',
		'label'   => __( '文章内容段落首行自动缩进', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-share-on'] = array(
		'id' => 'single-share-on',
		'label'   => __( '在文章页面启用百度分享', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-breadcrumbs-on'] = array(
		'id' => 'single-breadcrumbs-on',
		'label'   => __( '在文章页面显示面包屑导航', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-author-avatar-on'] = array(
		'id' => 'single-author-avatar-on',
		'label'   => __( '在文章页面显示作者头像', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-author-name-on'] = array(
		'id' => 'single-author-name-on',
		'label'   => __( '在文章页面显示作者名字', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['single-date-on'] = array(
		'id' => 'single-date-on',
		'label'   => __( '在文章页面显示文章发布时间', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-view-on'] = array(
		'id' => 'single-view-on',
		'label'   => __( '在文章页面显示浏览数', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);

	$options['single-comment-on'] = array(
		'id' => 'single-comment-on',
		'label'   => __( '在文章页面显示评论数', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['single-featured-on'] = array(
		'id' => 'single-featured-on',
		'label'   => __( '在文章页面(内容顶部)显示特色图片', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => false,
	);	

	$options['single-excerpt-on'] = array(
		'id' => 'single-excerpt-on',
		'label'   => __( '在文章页面(内容顶部)显示摘要', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);		

	$options['single-credit-on'] = array(
		'id' => 'single-credit-on',
		'label'   => __( '在文章页面(内容底部)显示来源详情', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);	

	$options['single-credit-text'] = array(
		'id' => 'single-credit-text',
		'label'   => __( '文章来源信息', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => '免责声明：文章内容不代表本站立场，本站不对其内容的真实性、完整性、准确性给予任何担保、暗示和承诺，仅供读者参考，文章版权归原作者所有。如本文内容影响到您的合法权益（内容、图片等），请及时联系本站，我们会及时删除处理。',
	);	

	$options['single-like-on'] = array(
		'id' => 'single-like-on',
		'label'   => __( '在文章页面(内容底部)显示点赞按钮', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);		

	$options['single-sponsor-on'] = array(
		'id' => 'single-sponsor-on',
		'label'   => __( '在文章页面(内容底部)显示打赏按钮', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => true,
	);		

	$options['author-box-on'] = array(
		'id' => 'author-box-on',
		'label'   => __( '在文章页面显示作者说明', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 1,
	);	

	$options['related-posts-on'] = array(
		'id' => 'related-posts-on',
		'label'   => __( '在文章页面显示相关文章', 'daohang' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 1,
	);	

	$options['related-num'] = array(
		'id' => 'related-num',
		'label'   => __( '要显示的相关文章数', 'daohang' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '5',		
	);	

	/* Ads */

	$section = 'ads';
	
	$sections[] = array(
		'id' => $section,
		'title' => __( '广告设置', 'daohang' ),
		'priority' => '10'
	);

	$options['content-ad-position'] = array(
		'id' => 'content-ad-position',
		'label'   => __( '列表广告(1)显示在第几篇文章之后？', 'daohang' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $ad_position_choices,		
		'default' => '1',
	);

	$options['content-ad-1'] = array(
		'id' => 'content-ad-1',
		'label'   => __( '文章列表广告 1', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => ''
	);	

	$options['content-ad-position2'] = array(
		'id' => 'content-ad-position2',
		'label'   => __( '列表广告(2)显示在第几篇文章之后？', 'daohang' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $ad_position_choices,		
		'default' => '4',
	);

	$options['content-ad-2'] = array(
		'id' => 'content-ad-2',
		'label'   => __( '文章列表广告 2', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => ''
	);	

	$options['content-ad-position3'] = array(
		'id' => 'content-ad-position3',
		'label'   => __( '列表广告(3)显示在第几篇文章之后？', 'daohang' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $ad_position_choices,		
		'default' => '7',
	);		

	$options['content-ad-3'] = array(
		'id' => 'content-ad-3',
		'label'   => __( '文章列表广告 3', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => ''
	);

	$options['single-top-ad'] = array(
		'id' => 'single-top-ad',
		'label'   => __( '文章内容顶部广告', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => ''
	);	

	$options['single-bottom-ad'] = array(
		'id' => 'single-bottom-ad',
		'label'   => __( '文章内容底部广告', 'daohang' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => ''
	);		

	//$options['example-range'] = array(
	//	'id' => 'example-range',
	//	'label'   => __( 'Example Range Input', 'daohang' ),
	//	'section' => $section,
	//	'type'    => 'range',
	//	'input_attrs' => array(
	//      'min'   => 0,
	//        'max'   => 10,
	//        'step'  => 1,
	//       'style' => 'color: #0a0',
	//	)
	//);

	// Adds the sections to the $options array
	$options['sections'] = $sections;

	// Adds the panels to the $options array
	$options['panels'] = $panels;

	$customizer_library = Customizer_Library::Instance();
	$customizer_library->add_options( $options );

	// To delete custom mods use: customizer_library_remove_theme_mods();

}
add_action( 'init', 'customizer_library_demo_options' );